/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchNode;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.common.server.application.configuration.DbConfigurationImpl;
import fr.gouv.vitam.common.server.application.configuration.MongoDbNode;
import fr.gouv.vitam.logbook.common.server.config.LogbookIndexationConfiguration;
import java.time.temporal.ChronoUnit;
import java.util.List;

public final class LogbookConfiguration
extends DbConfigurationImpl {
    private String p12LogbookPassword;
    private String p12LogbookFile;
    private String workspaceUrl;
    private String processingUrl;
    private String clusterName;
    private List<ElasticsearchNode> elasticsearchNodes;
    private List<LogbookEvent> alertEvents;
    private Integer operationTraceabilityTemporizationDelay;
    private Integer operationTraceabilityMaxRenewalDelay;
    private ChronoUnit operationTraceabilityMaxRenewalDelayUnit;
    private Integer lifecycleTraceabilityTemporizationDelay;
    private Integer lifecycleTraceabilityMaxRenewalDelay;
    private ChronoUnit lifecycleTraceabilityMaxRenewalDelayUnit;
    private Integer lifecycleTraceabilityMaxEntries;
    private Integer operationTraceabilityThreadPoolSize;
    private int reconstructionMetricsCacheDurationInMinutes = 15;
    private List<String> opEventsNotInWf;
    private List<String> opWithLFC;
    private List<String> opLfcEventsToSkip;
    @JsonProperty(value="elasticsearchTenantIndexation")
    private LogbookIndexationConfiguration logbookTenantIndexation;
    @JsonProperty(value="elasticsearchConfigurationFile")
    private String elasticsearchConfigurationFile;

    public LogbookConfiguration(List<MongoDbNode> mongoDbNodes, String dbName, String clusterName, List<ElasticsearchNode> elasticsearchNodes) {
        super(mongoDbNodes, dbName);
        ParametersChecker.checkParameter((String)"elasticsearch cluster name is a mandatory parameter", (String[])new String[]{clusterName});
        ParametersChecker.checkParameter((String)"elasticsearch nodes are a mandatory parameter", (Object[])new Object[]{elasticsearchNodes});
        this.clusterName = clusterName;
        this.elasticsearchNodes = elasticsearchNodes;
    }

    public LogbookConfiguration(List<MongoDbNode> mongoDbNodes, String dbName, String clusterName, List<ElasticsearchNode> elasticsearchNodes, boolean dbAuthentication, String dbUserName, String dbPassword) {
        super(mongoDbNodes, dbName, dbAuthentication, dbUserName, dbPassword);
        ParametersChecker.checkParameter((String)"elasticsearch cluster name is a mandatory parameter", (String[])new String[]{clusterName});
        ParametersChecker.checkParameter((String)"elasticsearch nodes are a mandatory parameter", (Object[])new Object[]{elasticsearchNodes});
        this.clusterName = clusterName;
        this.elasticsearchNodes = elasticsearchNodes;
    }

    public LogbookConfiguration() {
    }

    public String getP12LogbookPassword() {
        return this.p12LogbookPassword;
    }

    public void setP12LogbookPassword(String p12LogbookPassword) {
        this.p12LogbookPassword = p12LogbookPassword;
    }

    public String getP12LogbookFile() {
        return this.p12LogbookFile;
    }

    public void setP12LogbookFile(String p12LogbookFile) {
        this.p12LogbookFile = p12LogbookFile;
    }

    public String getWorkspaceUrl() {
        return this.workspaceUrl;
    }

    public void setWorkspaceUrl(String workspaceUrl) {
        this.workspaceUrl = workspaceUrl;
    }

    public String getProcessingUrl() {
        return this.processingUrl;
    }

    public void setProcessingUrl(String processingUrl) {
        this.processingUrl = processingUrl;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public LogbookConfiguration setClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public List<ElasticsearchNode> getElasticsearchNodes() {
        return this.elasticsearchNodes;
    }

    public LogbookConfiguration setElasticsearchNodes(List<ElasticsearchNode> elasticsearchNodes) {
        this.elasticsearchNodes = elasticsearchNodes;
        return this;
    }

    public List<LogbookEvent> getAlertEvents() {
        return this.alertEvents;
    }

    public void setAlertEvents(List<LogbookEvent> alertEvents) {
        this.alertEvents = alertEvents;
    }

    public List<String> getOpWithLFC() {
        return this.opWithLFC;
    }

    public void setOpWithLFC(List<String> opWithLFC) {
        this.opWithLFC = opWithLFC;
    }

    public List<String> getOpLfcEventsToSkip() {
        return this.opLfcEventsToSkip;
    }

    public void setOpLfcEventsToSkip(List<String> opLfcEventsToSkip) {
        this.opLfcEventsToSkip = opLfcEventsToSkip;
    }

    public List<String> getOpEventsNotInWf() {
        return this.opEventsNotInWf;
    }

    public void setOpEventsNotInWf(List<String> opEventsNotInWf) {
        this.opEventsNotInWf = opEventsNotInWf;
    }

    public Integer getOperationTraceabilityTemporizationDelay() {
        return this.operationTraceabilityTemporizationDelay;
    }

    public void setOperationTraceabilityTemporizationDelay(Integer operationTraceabilityTemporizationDelay) {
        this.operationTraceabilityTemporizationDelay = operationTraceabilityTemporizationDelay;
    }

    public Integer getLifecycleTraceabilityTemporizationDelay() {
        return this.lifecycleTraceabilityTemporizationDelay;
    }

    public void setLifecycleTraceabilityTemporizationDelay(Integer lifecycleTraceabilityTemporizationDelay) {
        this.lifecycleTraceabilityTemporizationDelay = lifecycleTraceabilityTemporizationDelay;
    }

    public Integer getLifecycleTraceabilityMaxEntries() {
        return this.lifecycleTraceabilityMaxEntries;
    }

    public void setLifecycleTraceabilityMaxEntries(Integer lifecycleTraceabilityMaxEntries) {
        this.lifecycleTraceabilityMaxEntries = lifecycleTraceabilityMaxEntries;
    }

    public Integer getOperationTraceabilityMaxRenewalDelay() {
        return this.operationTraceabilityMaxRenewalDelay;
    }

    public void setOperationTraceabilityMaxRenewalDelay(Integer operationTraceabilityMaxRenewalDelay) {
        this.operationTraceabilityMaxRenewalDelay = operationTraceabilityMaxRenewalDelay;
    }

    public ChronoUnit getOperationTraceabilityMaxRenewalDelayUnit() {
        return this.operationTraceabilityMaxRenewalDelayUnit;
    }

    public LogbookConfiguration setOperationTraceabilityMaxRenewalDelayUnit(ChronoUnit operationTraceabilityMaxRenewalDelayUnit) {
        this.operationTraceabilityMaxRenewalDelayUnit = operationTraceabilityMaxRenewalDelayUnit;
        return this;
    }

    public Integer getLifecycleTraceabilityMaxRenewalDelay() {
        return this.lifecycleTraceabilityMaxRenewalDelay;
    }

    public void setLifecycleTraceabilityMaxRenewalDelay(Integer lifecycleTraceabilityMaxRenewalDelay) {
        this.lifecycleTraceabilityMaxRenewalDelay = lifecycleTraceabilityMaxRenewalDelay;
    }

    public ChronoUnit getLifecycleTraceabilityMaxRenewalDelayUnit() {
        return this.lifecycleTraceabilityMaxRenewalDelayUnit;
    }

    public void setLifecycleTraceabilityMaxRenewalDelayUnit(ChronoUnit lifecycleTraceabilityMaxRenewalDelayUnit) {
        this.lifecycleTraceabilityMaxRenewalDelayUnit = lifecycleTraceabilityMaxRenewalDelayUnit;
    }

    public Integer getOperationTraceabilityThreadPoolSize() {
        return this.operationTraceabilityThreadPoolSize;
    }

    public void setOperationTraceabilityThreadPoolSize(int operationTraceabilityThreadPoolSize) {
        this.operationTraceabilityThreadPoolSize = operationTraceabilityThreadPoolSize;
    }

    public LogbookIndexationConfiguration getLogbookTenantIndexation() {
        return this.logbookTenantIndexation;
    }

    public LogbookConfiguration setLogbookTenantIndexation(LogbookIndexationConfiguration logbookTenantIndexation) {
        this.logbookTenantIndexation = logbookTenantIndexation;
        return this;
    }

    public int getReconstructionMetricsCacheDurationInMinutes() {
        return this.reconstructionMetricsCacheDurationInMinutes;
    }

    public void setReconstructionMetricsCacheDurationInMinutes(int reconstructionMetricsCacheDurationInMinutes) {
        this.reconstructionMetricsCacheDurationInMinutes = reconstructionMetricsCacheDurationInMinutes;
    }

    public String getElasticsearchConfigurationFile() {
        return this.elasticsearchConfigurationFile;
    }

    public void setElasticsearchConfigurationFile(String elasticSearchConfigurationFile) {
        this.elasticsearchConfigurationFile = elasticSearchConfigurationFile;
    }
}

