/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.StringUtils;
import fr.gouv.vitam.common.auth.web.filter.CertUtils;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.model.administration.ContextStatus;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import fr.gouv.vitam.security.internal.client.InternalSecurityClient;
import fr.gouv.vitam.security.internal.client.InternalSecurityClientFactory;
import fr.gouv.vitam.security.internal.common.exception.InternalSecurityException;
import fr.gouv.vitam.security.internal.common.model.IdentityModel;
import fr.gouv.vitam.security.internal.exception.VitamSecurityException;
import jakarta.annotation.Priority;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;

@PreMatching
@Priority(value=3030)
public class InternalSecurityFilter
implements ContainerRequestFilter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(InternalSecurityFilter.class);
    public static final String ACCESS_EXTERNAL = "/access-external/";
    public static final String INGEST_EXTERNAL = "/ingest-external/";
    private final boolean allowSslClientHeader;
    @Context
    private HttpServletRequest httpServletRequest;
    private InternalSecurityClientFactory internalSecurityClientFactory;
    private AdminManagementClientFactory adminManagementClientFactory;

    public InternalSecurityFilter(boolean allowSslClientHeader) {
        this.allowSslClientHeader = allowSslClientHeader;
        this.internalSecurityClientFactory = InternalSecurityClientFactory.getInstance();
        this.adminManagementClientFactory = AdminManagementClientFactory.getInstance();
    }

    @VisibleForTesting
    InternalSecurityFilter(HttpServletRequest httpServletRequest, InternalSecurityClientFactory internalSecurityClientFactory, AdminManagementClientFactory adminManagementClientFactory, boolean allowSslClientHeader) {
        this.httpServletRequest = httpServletRequest;
        this.internalSecurityClientFactory = internalSecurityClientFactory;
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.allowSslClientHeader = allowSslClientHeader;
    }

    public void filter(ContainerRequestContext requestContext) {
        X509Certificate[] clientCertChain = CertUtils.extractCert((ServletRequest)this.httpServletRequest, (boolean)this.allowSslClientHeader);
        if (clientCertChain == null || clientCertChain.length < 1) {
            throw new VitamSecurityException("Request do not contain any X509Certificate ");
        }
        if (requestContext.getUriInfo().getPath().endsWith("/status")) {
            return;
        }
        int tenantId = Integer.parseInt(this.httpServletRequest.getHeader("X-Tenant-Id"));
        String contractId = this.httpServletRequest.getHeader("X-Access-Contract-Id");
        if (contractId != null) {
            contractId = contractId.split(",")[0];
        }
        String accessContract = contractId;
        X509Certificate cert = clientCertChain[0];
        try (InternalSecurityClient internalSecurityClient = this.internalSecurityClientFactory.getClient();){
            Optional result = internalSecurityClient.findIdentity(cert.getEncoded());
            IdentityModel identityModel = (IdentityModel)result.orElseThrow(() -> new VitamSecurityException("Certificate revoked or not found in database."));
            ContextModel contextModel = this.getContext(identityModel);
            String uri = requestContext.getUriInfo().getPath();
            if (null == uri) {
                uri = "";
            }
            if (contextModel.isEnablecontrol() != null && contextModel.isEnablecontrol().booleanValue() && !uri.endsWith("/status") && !uri.endsWith("/tenants")) {
                if (uri.contains(ACCESS_EXTERNAL)) {
                    this.verifyAccessContract(tenantId, accessContract, contextModel);
                } else if (uri.contains(INGEST_EXTERNAL)) {
                    this.verifyIngestContract(tenantId, contextModel);
                } else {
                    this.verifyTenant(tenantId, contextModel);
                }
            }
            VitamThreadUtils.getVitamSession().setContextId(contextModel.getIdentifier());
            VitamThreadUtils.getVitamSession().setSecurityProfileIdentifier(contextModel.getSecurityProfileIdentifier());
        }
        catch (VitamClientInternalException | InternalSecurityException | VitamSecurityException | CertificateEncodingException e) {
            LOGGER.error("Security Error :", e);
            VitamError vitamError = this.generateVitamError((Exception)e);
            requestContext.abortWith(Response.status((int)vitamError.getHttpCode()).entity((Object)vitamError).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    private VitamError generateVitamError(Exception e) {
        VitamError vitamError = new VitamError(VitamCodeHelper.getCode((VitamCode)VitamCode.INTERNAL_SECURITY_UNAUTHORIZED));
        String description = e.getMessage();
        if (Strings.isNullOrEmpty((String)description)) {
            description = StringUtils.getClassName((Object)e);
        }
        vitamError.setContext(ServerIdentity.getInstance().getJsonIdentity()).setMessage(VitamCode.INTERNAL_SECURITY_UNAUTHORIZED.getMessage()).setDescription(description).setState(VitamCode.INTERNAL_SECURITY_UNAUTHORIZED.name()).setHttpCode(VitamCode.INTERNAL_SECURITY_UNAUTHORIZED.getStatus().getStatusCode());
        return vitamError;
    }

    private void verifyAccessContract(int tenantId, String accessContract, ContextModel contextModel) {
        boolean accessContractVerified = false;
        if (contextModel.getPermissions() != null && !contextModel.getPermissions().isEmpty()) {
            accessContractVerified = contextModel.getPermissions().stream().filter((? super T pm) -> pm.getTenant() == tenantId).filter((? super T pm) -> pm.getAccessContract() != null).anyMatch(pm -> pm.getAccessContract().contains(accessContract));
        }
        if (!accessContractVerified) {
            throw new VitamSecurityException("Access contract " + accessContract + " not found in the context for the tenant id :" + tenantId);
        }
    }

    private void verifyIngestContract(int tenantId, ContextModel contextModel) {
        boolean ingestContractVerified = false;
        if (contextModel.getPermissions() != null && !contextModel.getPermissions().isEmpty()) {
            ingestContractVerified = contextModel.getPermissions().stream().filter((? super T pm) -> pm.getTenant() == tenantId).filter((? super T pm) -> pm.getIngestContract() != null).anyMatch(pm -> !pm.getIngestContract().isEmpty());
        }
        if (!ingestContractVerified) {
            throw new VitamSecurityException("Ingest contract not found in the context for the tenant id :" + tenantId);
        }
    }

    private void verifyTenant(int tenantId, ContextModel contextModel) {
        boolean tenantVerified = false;
        if (contextModel.getPermissions() != null && !contextModel.getPermissions().isEmpty()) {
            tenantVerified = contextModel.getPermissions().stream().anyMatch(pm -> pm.getTenant() == tenantId);
        }
        if (!tenantVerified) {
            throw new VitamSecurityException("Tenant " + tenantId + " not found in the context");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ContextModel getContext(IdentityModel identityModel) {
        String contextId = identityModel.getContextId();
        try (AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();){
            RequestResponse contextResponse = adminManagementClient.findContextById(contextId);
            if (!contextResponse.isOk()) throw new VitamSecurityException("The context " + contextId + "  not found in database");
            List results = ((RequestResponseOK)contextResponse).getResults();
            if (results.isEmpty()) {
                throw new VitamSecurityException("The context " + contextId + "  not found in database");
            }
            ContextModel context = (ContextModel)Iterables.getFirst((Iterable)results, null);
            if (!ContextStatus.ACTIVE.equals((Object)context.getStatus())) {
                throw new VitamSecurityException("The context " + contextId + "  is not activated");
            }
            ContextModel contextModel = context;
            return contextModel;
        }
        catch (InvalidParseOperationException | AdminManagementClientServerException | ReferentialNotFoundException e) {
            throw new VitamSecurityException(e);
        }
    }

    public void destroy() {
    }
}

