/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.BaseXx;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.StringUtils;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.security.internal.client.InternalSecurityClient;
import fr.gouv.vitam.security.internal.client.InternalSecurityClientFactory;
import fr.gouv.vitam.security.internal.common.exception.InternalSecurityException;
import fr.gouv.vitam.security.internal.common.exception.PersonalCertificateException;
import fr.gouv.vitam.security.internal.common.model.IsPersonalCertificateRequiredModel;
import fr.gouv.vitam.security.internal.common.service.ParsedCertificate;
import fr.gouv.vitam.security.internal.exception.VitamSecurityException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;

public class EndpointPersonalCertificateAuthorizationFilter
implements ContainerRequestFilter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EndpointPersonalCertificateAuthorizationFilter.class);
    private final String permission;
    private InternalSecurityClient internalSecurityClient;

    public EndpointPersonalCertificateAuthorizationFilter(String permission) {
        this.permission = permission;
        this.internalSecurityClient = InternalSecurityClientFactory.getInstance().getClient();
    }

    @VisibleForTesting
    public EndpointPersonalCertificateAuthorizationFilter(String permission, InternalSecurityClient internalSecurityClient) {
        this.permission = permission;
        this.internalSecurityClient = internalSecurityClient;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            boolean isPersonalCertificateRequired;
            byte[] certificate = this.extractPersonalCertificate(requestContext);
            if (certificate != null) {
                VitamThreadUtils.getVitamSession().setPersonalCertificate(ParsedCertificate.parseCertificate((byte[])certificate).getCertificateHash());
            }
            if (!(isPersonalCertificateRequired = this.getIsPersonalCertificateRequired())) {
                LOGGER.debug("Personal certificate check skipped for permission {0}", (Object)this.permission);
                return;
            }
            LOGGER.debug("Personal certificate check required for permission {0}", (Object)this.permission);
            this.internalSecurityClient.checkPersonalCertificate(certificate, this.permission);
        }
        catch (VitamClientInternalException | InternalSecurityException | PersonalCertificateException | VitamSecurityException e) {
            LOGGER.error("An error occured during authorization filter check", e);
            VitamError vitamError = this.generateVitamError((Exception)e);
            requestContext.abortWith(Response.status((int)vitamError.getHttpCode()).entity((Object)vitamError).type(MediaType.APPLICATION_JSON_TYPE).build());
            return;
        }
    }

    private byte[] extractPersonalCertificate(ContainerRequestContext requestContext) {
        String base64Certificate = requestContext.getHeaderString("X-Personal-Certificate");
        return base64Certificate != null ? BaseXx.getFromBase64((String)base64Certificate) : null;
    }

    private boolean getIsPersonalCertificateRequired() throws VitamClientInternalException, InternalSecurityException {
        IsPersonalCertificateRequiredModel isPersonalCertificateRequired = this.internalSecurityClient.isPersonalCertificateRequiredByPermission(this.permission);
        switch (isPersonalCertificateRequired.getResponse()) {
            case REQUIRED_PERSONAL_CERTIFICATE: {
                return true;
            }
            case IGNORED_PERSONAL_CERTIFICATE: {
                return false;
            }
            case ERROR_UNKNOWN_PERMISSION: {
                throw new IllegalStateException("Unknown permission " + this.permission + ". Please add permission in security-internal personal certificate permission configuration.");
            }
        }
        throw new IllegalStateException("Unexpected response " + String.valueOf(isPersonalCertificateRequired));
    }

    private VitamError generateVitamError(Exception e) {
        VitamError vitamError = new VitamError(VitamCodeHelper.getCode((VitamCode)VitamCode.INTERNAL_SECURITY_UNAUTHORIZED));
        String description = e.getMessage();
        if (Strings.isNullOrEmpty((String)description)) {
            description = StringUtils.getClassName((Object)e);
        }
        vitamError.setContext(ServerIdentity.getInstance().getJsonIdentity()).setMessage(VitamCode.INTERNAL_SECURITY_UNAUTHORIZED.getMessage()).setDescription(description).setState(VitamCode.INTERNAL_SECURITY_UNAUTHORIZED.name()).setHttpCode(VitamCode.INTERNAL_SECURITY_UNAUTHORIZED.getStatus().getStatusCode());
        return vitamError;
    }

    public String getPermission() {
        return this.permission;
    }
}

