/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.filter;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.rest.VitamAuthentication;
import fr.gouv.vitam.common.server.application.configuration.DefaultVitamApplicationConfiguration;
import fr.gouv.vitam.security.internal.filter.EndpointAuthenticationFilter;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;

@PreMatching
@Priority(value=3050)
public class BasicAuthenticationFilter
implements DynamicFeature {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BasicAuthenticationFilter.class);
    private DefaultVitamApplicationConfiguration configuration;

    public BasicAuthenticationFilter(DefaultVitamApplicationConfiguration configuration) {
        this.configuration = configuration;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        VitamAuthentication authentication = resourceInfo.getResourceMethod().getAnnotation(VitamAuthentication.class);
        if (authentication == null) {
            LOGGER.debug(String.format("Ignore @%s non annotated method %s for the class %s", VitamAuthentication.class.getName(), resourceInfo.getResourceMethod().getName(), resourceInfo.getResourceClass().getName()));
            return;
        }
        LOGGER.debug(String.format("Registering VitamAuthentication filters with '%s' authentication level for %s annotated method %s.%s", authentication.authentLevel(), VitamAuthentication.class.getName(), resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        featureContext.register((Object)new EndpointAuthenticationFilter(authentication.authentLevel(), this.configuration), 2010);
    }
}

