/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.filter;

import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.VitamSession;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;

@PreMatching
@Priority(value=990)
public class AdminRequestIdFilter
implements ContainerRequestFilter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminRequestIdFilter.class);

    public void filter(ContainerRequestContext requestContext) {
        String xrequestIdInHeader = (String)requestContext.getHeaders().getFirst((Object)"X-Request-Id");
        if (xrequestIdInHeader != null) {
            LOGGER.error("RequestId found in admin API");
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).build());
            return;
        }
        VitamSession vitamSession = VitamThreadUtils.getVitamSession();
        vitamSession.setRequestId(GUIDFactory.newGUID());
    }
}

