/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogInfoModel;
import fr.gouv.vitam.common.client.CustomVitamHttpStatusCode;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.model.storage.ObjectEntryReader;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.storage.driver.model.StorageLogBackupResult;
import fr.gouv.vitam.storage.driver.model.StorageLogTraceabilityResult;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageIllegalOperationClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import fr.gouv.vitam.storage.engine.common.model.request.BulkObjectAvailabilityRequest;
import fr.gouv.vitam.storage.engine.common.model.request.BulkObjectStoreRequest;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.storage.engine.common.model.request.OfferLogRequest;
import fr.gouv.vitam.storage.engine.common.model.response.BatchObjectInformationResponse;
import fr.gouv.vitam.storage.engine.common.model.response.BulkObjectAvailabilityResponse;
import fr.gouv.vitam.storage.engine.common.model.response.BulkObjectStoreResponse;
import fr.gouv.vitam.storage.engine.common.model.response.StoredInfoResult;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;

class StorageClientRest
extends DefaultClient
implements StorageClient {
    private static final String OBJECT_DESCRIPTION_MUST_HAVE_A_VALID_VALUE = "Object's description must have a valid value";
    private static final String OBJECT_DESCRIPTION_GUID_MUST_HAVE_A_VALID_VALUE = "Object's description container's GUID must have a valid value";
    private static final String OBJECT_DESCRIPTION_URI_MUST_HAVE_A_VALID_VALUE = "Object's description workspace's URI must have a valid value";
    private static final String GUID_MUST_HAVE_A_VALID_VALUE = "GUID must have a valid value";
    private static final String REQUIRED_ACCESS_REQUEST_ID = "Access Request id is required";
    private static final String REQUIRED_ACCESS_REQUEST_IDS = "Access Request ids are required";
    private static final String REQUIRED_REQUEST = "Request is required";
    private static final String STRATEGY_ID_MUST_HAVE_A_VALID_VALUE = "Strategy id must have a valid value";
    private static final String TYPE_OF_STORAGE_OBJECT_MUST_HAVE_A_VALID_VALUE = "Type of storage object must have a valid value";
    private static final String ORDER_OF_STORAGE_OBJECT_MUST_HAVE_A_VALID_VALUE = "Order of storage object must have a valid value";
    private static final String STORAGE_ACCESSLOG_BACKUP_URI = "/storage/backup/accesslog";
    private static final String STORAGE_LOG_BACKUP_URI = "/storage/backup";
    private static final String STORAGE_LOG_TRACEABILITY_URI = "/storage/traceability";
    private static final String STRATEGIES_URI = "/strategies";
    private static final String COPY = "/copy/";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StorageClientRest.class);
    private static final String INTERNAL_SERVER_ERROR = "Internal Server Error:";
    private static final GenericType<List<String>> LIST_STRING_TYPE = new GenericType<List<String>>(){};

    StorageClientRest(StorageClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    @Override
    public JsonNode getStorageInformation(String strategyId) throws StorageNotFoundClientException, StorageServerClientException {
        JsonNode jsonNode;
        block8: {
            Integer tenantId = ParameterHelper.getTenantParameter();
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/").withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withJsonAccept();
            Response response = this.make(request);
            try {
                jsonNode = (JsonNode)this.handleCommonResponseStatus(response).readEntity(JsonNode.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | StorageAlreadyExistsClientException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, (Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public List<String> getOffers(String strategyId) throws StorageNotFoundClientException, StorageServerClientException {
        List list;
        block8: {
            Integer tenantId = ParameterHelper.getTenantParameter();
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/offers").withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                list = (List)this.handleCommonResponseStatus(response).readEntity(LIST_STRING_TYPE);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | StorageAlreadyExistsClientException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, (Throwable)e);
                }
            }
            response.close();
        }
        return list;
    }

    @Override
    public StoredInfoResult storeFileFromWorkspace(String strategyId, DataCategory type, String guid, ObjectDescription description) throws StorageAlreadyExistsClientException, StorageNotFoundClientException, StorageServerClientException {
        StoredInfoResult storedInfoResult;
        block9: {
            Integer tenantId = ParameterHelper.getTenantParameter();
            ParametersChecker.checkParameter((String)TYPE_OF_STORAGE_OBJECT_MUST_HAVE_A_VALID_VALUE, (Object[])new Object[]{type});
            ParametersChecker.checkParameter((String)GUID_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{guid});
            ParametersChecker.checkParameter((String)OBJECT_DESCRIPTION_MUST_HAVE_A_VALID_VALUE, (Object[])new Object[]{description});
            if (description != null) {
                ParametersChecker.checkParameter((String)OBJECT_DESCRIPTION_GUID_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{description.getWorkspaceContainerGUID()});
                ParametersChecker.checkParameter((String)OBJECT_DESCRIPTION_URI_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{description.getWorkspaceObjectURI()});
            }
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/" + type.getCollectionName() + "/" + guid).withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withBody((Object)description).withJson();
            Response response = this.make(request);
            try {
                storedInfoResult = (StoredInfoResult)this.handleCommonResponseStatus(response).readEntity(StoredInfoResult.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, e);
                }
            }
            response.close();
        }
        return storedInfoResult;
    }

    @Override
    public BulkObjectStoreResponse bulkStoreFilesFromWorkspace(String strategyId, BulkObjectStoreRequest bulkObjectStoreRequest) throws StorageAlreadyExistsClientException, StorageNotFoundClientException, StorageServerClientException {
        BulkObjectStoreResponse bulkObjectStoreResponse;
        block9: {
            Integer tenantId = ParameterHelper.getTenantParameter();
            ParametersChecker.checkParameter((String)"Expected valid request", (Object[])new Object[]{bulkObjectStoreRequest});
            ParametersChecker.checkParameter((String)"Invalid digest type", (Object[])new Object[]{bulkObjectStoreRequest.getType()});
            ParametersChecker.checkParameter((String)"Invalid workspace URIs", (Object[])new Object[]{bulkObjectStoreRequest.getWorkspaceObjectURIs()});
            ParametersChecker.checkParameter((String)"Invalid workspace URIs", (Object[])bulkObjectStoreRequest.getWorkspaceObjectURIs().toArray());
            ParametersChecker.checkParameter((String)"Invalid object ids", (Object[])new Object[]{bulkObjectStoreRequest.getObjectNames()});
            ParametersChecker.checkParameter((String)"Invalid object ids", (Object[])bulkObjectStoreRequest.getObjectNames().toArray());
            if (bulkObjectStoreRequest.getObjectNames().size() != bulkObjectStoreRequest.getWorkspaceObjectURIs().size()) {
                throw new IllegalArgumentException("Object uris count do not match object ids count");
            }
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/bulk/" + bulkObjectStoreRequest.getType().getCollectionName()).withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withBody((Object)bulkObjectStoreRequest).withJson();
            Response response = this.make(request);
            try {
                bulkObjectStoreResponse = (BulkObjectStoreResponse)this.handleCommonResponseStatus(response).readEntity(BulkObjectStoreResponse.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, e);
                }
            }
            response.close();
        }
        return bulkObjectStoreResponse;
    }

    @Override
    public Map<String, Boolean> exists(String strategyId, DataCategory type, String guid, List<String> offerIds) throws StorageServerClientException {
        HashMap<String, Boolean> hashMap;
        block10: {
            Integer tenantId = ParameterHelper.getTenantParameter();
            ParametersChecker.checkParameter((String)STRATEGY_ID_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{strategyId});
            ParametersChecker.checkParameter((String)TYPE_OF_STORAGE_OBJECT_MUST_HAVE_A_VALID_VALUE, (Object[])new Object[]{type});
            ParametersChecker.checkParameter((String)GUID_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{guid});
            VitamRequestBuilder request = VitamRequestBuilder.head().withPath("/" + type.name() + "/" + guid).withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withJsonAccept();
            for (String offerId : offerIds) {
                request.withHeader("X-Offer-Ids", (Object)offerId);
            }
            Response response = this.make(request);
            try {
                this.notContentResponseToBoolean(this.handleNoContentResponseStatus(response));
                HashMap<String, Boolean> result = new HashMap<String, Boolean>();
                for (String offerId : offerIds) {
                    result.put(offerId, response.getHeaders().containsKey((Object)offerId) && response.getHeaders().get((Object)offerId) != null ? BooleanUtils.toBoolean((String)response.getHeaderString(offerId)) : Boolean.FALSE);
                }
                hashMap = result;
                if (response == null) break block10;
            }
            catch (Throwable result) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            result.addSuppressed(throwable);
                        }
                    }
                    throw result;
                }
                catch (VitamClientInternalException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, e);
                }
            }
            response.close();
        }
        return hashMap;
    }

    @Override
    public JsonNode getInformation(String strategyId, DataCategory type, String guid, List<String> offerIds, boolean noCache) throws StorageServerClientException, StorageNotFoundClientException {
        String offerId2;
        block9: {
            Integer tenantId = ParameterHelper.getTenantParameter();
            ParametersChecker.checkParameter((String)GUID_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{guid});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/info/" + type.getCollectionName() + "/" + guid).withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withHeader("X-Offer-No-Cache", (Object)Boolean.toString(noCache)).withJsonAccept();
            for (String offerId2 : offerIds) {
                request.withHeader("X-Offer-Ids", (Object)offerId2);
            }
            Response response = this.make(request);
            try {
                this.check(response);
                offerId2 = (JsonNode)this.handleCommonResponseStatus(response).readEntity(JsonNode.class);
                if (response == null) break block9;
            }
            catch (Throwable offerId2) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            offerId2.addSuppressed(throwable);
                        }
                    }
                    throw offerId2;
                }
                catch (VitamClientInternalException | StorageAlreadyExistsClientException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, (Throwable)e);
                }
            }
            response.close();
        }
        return offerId2;
    }

    @Override
    public RequestResponse<BatchObjectInformationResponse> getBatchObjectInformation(String strategyId, DataCategory type, Collection<String> offerIds, Collection<String> objectIds) throws StorageServerClientException {
        String offerId2;
        block9: {
            ParametersChecker.checkParameter((String)GUID_MUST_HAVE_A_VALID_VALUE, (Object[])new Object[]{objectIds});
            ParametersChecker.checkParameter((String)GUID_MUST_HAVE_A_VALID_VALUE, (Object[])objectIds.toArray());
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/batch_info/" + type.getCollectionName()).withHeader("X-Tenant-Id", (Object)ParameterHelper.getTenantParameter()).withHeader("X-Strategy-Id", (Object)strategyId).withBody(objectIds).withJson();
            for (String offerId2 : offerIds) {
                request.withHeader("X-Offer-Ids", (Object)offerId2);
            }
            Response response = this.make(request);
            try {
                this.check(response);
                offerId2 = RequestResponse.parseFromResponse((Response)response, BatchObjectInformationResponse.class);
                if (response == null) break block9;
            }
            catch (Throwable offerId2) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            offerId2.addSuppressed(throwable);
                        }
                    }
                    throw offerId2;
                }
                catch (VitamClientInternalException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, e);
                }
            }
            response.close();
        }
        return offerId2;
    }

    @Override
    public boolean delete(String strategyId, DataCategory type, String guid) throws StorageServerClientException {
        return this.delete(strategyId, type, guid, new ArrayList<String>());
    }

    @Override
    public boolean delete(String strategyId, DataCategory type, String guid, List<String> offerIds) throws StorageServerClientException {
        boolean bl;
        block9: {
            Integer tenantId = ParameterHelper.getTenantParameter();
            ParametersChecker.checkParameter((String)TYPE_OF_STORAGE_OBJECT_MUST_HAVE_A_VALID_VALUE, (Object[])new Object[]{type});
            ParametersChecker.checkParameter((String)GUID_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{guid});
            VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("/delete/" + guid).withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withHeader("X-Data-Category", (Object)type.name()).withJsonAccept();
            if (offerIds != null && !offerIds.isEmpty()) {
                offerIds.forEach(id -> request.withHeader("X-Offer-Ids", id));
            }
            Response response = this.make(request);
            try {
                bl = this.notContentResponseToBoolean(this.handleNoContentResponseStatus(response));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, e);
                }
            }
            response.close();
        }
        return bl;
    }

    private boolean notContentResponseToBoolean(Response.Status status) throws StorageServerClientException {
        return switch (status) {
            case Response.Status.NO_CONTENT -> true;
            case Response.Status.NOT_FOUND -> false;
            default -> {
                String log = VitamCodeHelper.getCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR) + " : " + status.getReasonPhrase();
                throw new StorageServerClientException(log);
            }
        };
    }

    private Response.Status handleNoContentResponseStatus(Response response) throws StorageServerClientException {
        ParametersChecker.checkParameter((String)"Response", (Object[])new Object[]{response});
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        switch (status) {
            case NO_CONTENT: 
            case NOT_FOUND: 
            case PRECONDITION_FAILED: {
                return status;
            }
        }
        String log = VitamCodeHelper.getCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR) + " : " + status.getReasonPhrase();
        throw new StorageServerClientException(log);
    }

    private Response handleCommonResponseStatus(Response response) throws StorageNotFoundClientException, StorageServerClientException, StorageAlreadyExistsClientException {
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        if (status == null) {
            throw new StorageServerClientException(VitamCodeHelper.getCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR) + " : Unknown status code " + response.getStatus());
        }
        switch (status) {
            case OK: 
            case CREATED: {
                return response;
            }
            case CONFLICT: {
                throw new StorageAlreadyExistsClientException(VitamCodeHelper.getCode((VitamCode)VitamCode.STORAGE_CLIENT_ALREADY_EXISTS) + " : " + status.getReasonPhrase());
            }
            case NOT_FOUND: {
                throw new StorageNotFoundClientException(VitamCodeHelper.getCode((VitamCode)VitamCode.STORAGE_NOT_FOUND) + " : " + status.getReasonPhrase());
            }
            case PRECONDITION_FAILED: {
                throw new StorageServerClientException(VitamCodeHelper.getCode((VitamCode)VitamCode.STORAGE_BAD_REQUEST) + " : " + status.getReasonPhrase());
            }
        }
        String log = VitamCodeHelper.getCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR) + " : " + status.getReasonPhrase();
        throw new StorageServerClientException(log);
    }

    @Override
    public Response getContainerAsync(String strategyId, String objectName, DataCategory type, AccessLogInfoModel logInfo) throws StorageServerClientException, StorageNotFoundException, StorageUnavailableDataFromAsyncOfferClientException {
        return this.getContainerAsync(strategyId, null, objectName, type, logInfo);
    }

    private void checkCustomResponseStatusForUnavailableDataFromAsyncOffer(Response response) throws StorageUnavailableDataFromAsyncOfferClientException, StorageServerClientException {
        CustomVitamHttpStatusCode customStatusCode = CustomVitamHttpStatusCode.fromStatusCode((int)response.getStatus());
        if (customStatusCode == null) {
            return;
        }
        if (customStatusCode == CustomVitamHttpStatusCode.UNAVAILABLE_DATA_FROM_ASYNC_OFFER) {
            throw new StorageUnavailableDataFromAsyncOfferClientException("Access to async offer requires valid access request");
        }
        throw new StorageServerClientException(customStatusCode.toString());
    }

    @Override
    public Response getContainerAsync(String strategyId, String offerId, String objectName, DataCategory type, AccessLogInfoModel logInfo) throws StorageServerClientException, StorageNotFoundException, StorageUnavailableDataFromAsyncOfferClientException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        ParametersChecker.checkParameter((String)GUID_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{objectName});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath(type.getCollectionName() + "/" + objectName).withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withHeaderIgnoreNull("X-Offer", (Object)offerId).withBody((Object)logInfo).withContentType(MediaType.APPLICATION_JSON_TYPE).withAccept(MediaType.APPLICATION_OCTET_STREAM_TYPE);
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(request);
            this.checkCustomResponseStatusForUnavailableDataFromAsyncOffer(response);
            Response result = this.handleCommonResponseStatus(response);
            doNotCloseResponse = true;
            Response response2 = result;
            return response2;
        }
        catch (VitamClientInternalException | StorageAlreadyExistsClientException e) {
            String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
            throw new StorageServerClientException(errorMessage, (Throwable)e);
        }
        catch (StorageNotFoundClientException e) {
            throw new StorageNotFoundException((Throwable)((Object)e));
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public CloseableIterator<ObjectEntry> listContainer(String strategyId, String offerId, DataCategory type) throws StorageServerClientException, StorageNotFoundClientException {
        ObjectEntryReader objectEntryReader;
        block8: {
            ParametersChecker.checkParameter((String)"Type cannot be null", (Object[])new Object[]{type});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/" + type.name()).withHeader("X-Strategy-Id", (Object)strategyId).withHeaderIgnoreNull("X-Offer", (Object)offerId).withHeader("X-Tenant-Id", (Object)ParameterHelper.getTenantParameter());
            Response response = this.make(request);
            try {
                this.handleCommonResponseStatus(response);
                objectEntryReader = new ObjectEntryReader((InputStream)response.readEntity(InputStream.class));
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | StorageAlreadyExistsClientException e) {
                    throw new StorageServerClientException(INTERNAL_SERVER_ERROR, (Throwable)e);
                }
            }
            response.close();
        }
        return objectEntryReader;
    }

    @Override
    public RequestResponseOK<StorageLogBackupResult> storageAccessLogBackup(List<Integer> tenants) throws StorageServerClientException, InvalidParseOperationException {
        RequestResponseOK requestResponseOK;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(STORAGE_ACCESSLOG_BACKUP_URI).withHeader("X-Tenant-Id", (Object)ParameterHelper.getTenantParameter()).withBody((Object)JsonHandler.toJsonNode(tenants)).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                RequestResponse result = RequestResponse.parseFromResponse((Response)response, StorageLogBackupResult.class);
                requestResponseOK = (RequestResponseOK)result;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageServerClientException(INTERNAL_SERVER_ERROR, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponseOK<StorageLogBackupResult> storageLogBackup(List<Integer> tenants) throws StorageServerClientException, InvalidParseOperationException {
        RequestResponseOK requestResponseOK;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(STORAGE_LOG_BACKUP_URI).withHeader("X-Tenant-Id", (Object)ParameterHelper.getTenantParameter()).withBody((Object)JsonHandler.toJsonNode(tenants)).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                RequestResponse result = RequestResponse.parseFromResponse((Response)response, StorageLogBackupResult.class);
                requestResponseOK = (RequestResponseOK)result;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageServerClientException(INTERNAL_SERVER_ERROR, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponseOK<StorageLogTraceabilityResult> storageLogTraceability(List<Integer> tenants) throws StorageServerClientException, InvalidParseOperationException {
        RequestResponseOK requestResponseOK;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(STORAGE_LOG_TRACEABILITY_URI).withHeader("X-Tenant-Id", (Object)ParameterHelper.getTenantParameter()).withBody((Object)JsonHandler.toJsonNode(tenants)).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                RequestResponse result = RequestResponse.parseFromResponse((Response)response, StorageLogTraceabilityResult.class);
                requestResponseOK = (RequestResponseOK)result;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageServerClientException(INTERNAL_SERVER_ERROR, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    public RequestResponseOK<JsonNode> copyObjectFromOfferToOffer(String objectId, DataCategory category, String source, String destination, String strategyId) throws StorageServerClientException, InvalidParseOperationException, StorageUnavailableDataFromAsyncOfferClientException {
        RequestResponseOK requestResponseOK;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(COPY + objectId).withHeader("X-Tenant-Id", (Object)ParameterHelper.getTenantParameter()).withHeader("X-CONTENT-DESTINATION", (Object)destination).withHeader("X-CONTENT-SOURCE", (Object)source).withHeader("X-Tenant-Id", (Object)ParameterHelper.getTenantParameter()).withHeader("X-Strategy-Id", (Object)VitamConfiguration.getDefaultStrategy()).withHeader("X-Data-Category", (Object)category.name()).withJsonAccept();
            Response response = this.make(request);
            try {
                this.checkCustomResponseStatusForUnavailableDataFromAsyncOffer(response);
                this.check(response);
                requestResponseOK = RequestResponse.parseRequestResponseOk((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageServerClientException(INTERNAL_SERVER_ERROR, e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    public RequestResponseOK<JsonNode> create(String strategyId, String objectId, DataCategory category, InputStream inputStream, Long inputStreamSize, List<String> offerIds) throws StorageServerClientException, InvalidParseOperationException {
        RequestResponseOK requestResponseOK;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/create/" + objectId).withHeader("X-Tenant-Id", (Object)ParameterHelper.getTenantParameter()).withHeader("X-Strategy-Id", (Object)strategyId).withHeader("X-Content-Length", (Object)inputStreamSize).withHeader("X-Data-Category", (Object)category.name()).withBody((Object)inputStream).withJsonAccept().withOctetContentType();
            for (String offerId : offerIds) {
                request.withHeader("X-Offer-Ids", (Object)offerId);
            }
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponseOK = RequestResponse.parseRequestResponseOk((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new StorageServerClientException("Internal Server Error", e);
                }
            }
            response.close();
        }
        return requestResponseOK;
    }

    @Override
    public RequestResponse<OfferLog> getOfferLogs(String strategyId, String offerId, DataCategory type, Long offset, int limit, Order order) throws StorageServerClientException {
        RequestResponse requestResponse;
        block8: {
            Integer tenantId = ParameterHelper.getTenantParameter();
            ParametersChecker.checkParameter((String)TYPE_OF_STORAGE_OBJECT_MUST_HAVE_A_VALID_VALUE, (Object[])new Object[]{type});
            ParametersChecker.checkParameter((String)ORDER_OF_STORAGE_OBJECT_MUST_HAVE_A_VALID_VALUE, (Object[])new Object[]{order});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/" + type.name() + "/logs").withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withHeaderIgnoreNull("X-Offer", (Object)offerId).withBody((Object)new OfferLogRequest(offset, limit, order)).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, OfferLog.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<StorageStrategy> getStorageStrategies() throws StorageServerClientException {
        RequestResponse requestResponse;
        block8: {
            Integer tenantId = ParameterHelper.getTenantParameter();
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(STRATEGIES_URI).withHeader("X-Tenant-Id", (Object)tenantId).withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, StorageStrategy.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<String> createAccessRequestIfRequired(String strategyId, String offerId, DataCategory dataCategory, List<String> objectNames) throws StorageServerClientException {
        ParametersChecker.checkParameter((String)STRATEGY_ID_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{strategyId});
        ParametersChecker.checkParameter((String)TYPE_OF_STORAGE_OBJECT_MUST_HAVE_A_VALID_VALUE, (Object[])new Object[]{dataCategory});
        ParametersChecker.checkParameter((String)GUID_MUST_HAVE_A_VALID_VALUE, (Object[])new Object[]{objectNames});
        ParametersChecker.checkParameter((String)GUID_MUST_HAVE_A_VALID_VALUE, (String[])((String[])objectNames.toArray(String[]::new)));
        Integer tenantId = ParameterHelper.getTenantParameter();
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/access-request/" + dataCategory.name()).withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withHeaderIgnoreNull("X-Offer", (Object)offerId).withJson().withBody(objectNames);
        try (Response response = this.make(request);){
            this.check(response);
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                LOGGER.debug("No access request required");
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            RequestResponseOK accessRequestCreationResponse222 = (RequestResponseOK)RequestResponse.parseFromResponse((Response)response, String.class);
            String accessRequestId = (String)accessRequestCreationResponse222.getFirstResult();
            if (accessRequestId == null) {
                throw new StorageServerClientException("Null accessRequestId");
            }
            LOGGER.debug("Access request created: {}", (Object)accessRequestId);
            Optional<String> optional = Optional.of(accessRequestId);
            return optional;
        }
        catch (VitamClientInternalException e) {
            String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
            throw new StorageServerClientException(errorMessage, e);
        }
    }

    @Override
    public Map<String, AccessRequestStatus> checkAccessRequestStatuses(String strategyId, String offerId, List<String> accessRequestIds, boolean adminCrossTenantAccessRequestAllowed) throws StorageServerClientException, StorageIllegalOperationClientException {
        Map map;
        block8: {
            ParametersChecker.checkParameter((String)STRATEGY_ID_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{strategyId});
            ParametersChecker.checkParameter((String)REQUIRED_ACCESS_REQUEST_IDS, (Object[])new Object[]{accessRequestIds});
            ParametersChecker.checkParameter((String)REQUIRED_ACCESS_REQUEST_IDS, (String[])((String[])accessRequestIds.toArray(String[]::new)));
            Integer tenantId = ParameterHelper.getTenantParameter();
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/access-request/statuses").withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withHeaderIgnoreNull("X-Offer", (Object)offerId).withHeader("X-Admin-Cross-Tenant-Access-Request-Allowed", (Object)Boolean.toString(adminCrossTenantAccessRequestAllowed)).withJson().withBody(accessRequestIds);
            Response response = this.make(request);
            try {
                this.checkIllegalOperation(response);
                this.check(response);
                RequestResponseOK accessRequestCreationResponse = (RequestResponseOK)JsonHandler.getFromInputStreamAsTypeReference((InputStream)((InputStream)response.readEntity(InputStream.class)), (TypeReference)new TypeReference<RequestResponseOK<Map<String, AccessRequestStatus>>>(this){});
                Map accessRequestStatuses = (Map)accessRequestCreationResponse.getFirstResult();
                LOGGER.debug("Access request statuses: {}", (Object)accessRequestStatuses);
                map = accessRequestStatuses;
                if (response == null) break block8;
            }
            catch (Throwable accessRequestCreationResponse) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            accessRequestCreationResponse.addSuppressed(throwable);
                        }
                    }
                    throw accessRequestCreationResponse;
                }
                catch (InvalidFormatException | InvalidParseOperationException | VitamClientInternalException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, e);
                }
            }
            response.close();
        }
        return map;
    }

    @Override
    public void removeAccessRequest(String strategyId, String offerId, String accessRequestId, boolean adminCrossTenantAccessRequestAllowed) throws StorageServerClientException, StorageIllegalOperationClientException {
        ParametersChecker.checkParameter((String)STRATEGY_ID_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{strategyId});
        ParametersChecker.checkParameter((String)REQUIRED_ACCESS_REQUEST_ID, (String[])new String[]{accessRequestId});
        Integer tenantId = ParameterHelper.getTenantParameter();
        VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("/access-request/" + accessRequestId).withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withHeaderIgnoreNull("X-Offer", (Object)offerId).withHeader("X-Admin-Cross-Tenant-Access-Request-Allowed", (Object)Boolean.toString(adminCrossTenantAccessRequestAllowed)).withJson();
        try (Response response = this.make(request);){
            this.checkIllegalOperation(response);
            this.check(response);
            LOGGER.debug("Access request deleted successfully");
        }
        catch (VitamClientInternalException e) {
            String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
            throw new StorageServerClientException(errorMessage, e);
        }
    }

    @Override
    public BulkObjectAvailabilityResponse checkBulkObjectAvailability(String strategyId, String offerId, BulkObjectAvailabilityRequest bulkObjectAvailabilityRequest) throws StorageServerClientException {
        BulkObjectAvailabilityResponse bulkObjectAvailabilityResponse;
        block10: {
            ParametersChecker.checkParameter((String)STRATEGY_ID_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{strategyId});
            ParametersChecker.checkParameter((String)REQUIRED_REQUEST, (Object[])new Object[]{bulkObjectAvailabilityRequest});
            ParametersChecker.checkParameter((String)TYPE_OF_STORAGE_OBJECT_MUST_HAVE_A_VALID_VALUE, (Object[])new Object[]{bulkObjectAvailabilityRequest.getType()});
            ParametersChecker.checkParameter((String)GUID_MUST_HAVE_A_VALID_VALUE, (Object[])new Object[]{bulkObjectAvailabilityRequest.getObjectNames()});
            ParametersChecker.checkParameter((String)GUID_MUST_HAVE_A_VALID_VALUE, (String[])((String[])bulkObjectAvailabilityRequest.getObjectNames().toArray(String[]::new)));
            Integer tenantId = ParameterHelper.getTenantParameter();
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/object-availability-check/" + bulkObjectAvailabilityRequest.getType().name()).withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withHeaderIgnoreNull("X-Offer", (Object)offerId).withJson().withBody((Object)bulkObjectAvailabilityRequest.getObjectNames());
            Response response = this.make(request);
            try {
                this.check(response);
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    throw new VitamClientInternalException(String.format("Unexpected status code: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase()));
                }
                RequestResponseOK requestResponseOK = (RequestResponseOK)RequestResponse.parseFromResponse((Response)response, BulkObjectAvailabilityResponse.class);
                BulkObjectAvailabilityResponse objectAvailabilityResponse = (BulkObjectAvailabilityResponse)requestResponseOK.getFirstResult();
                LOGGER.debug("Object availability response: {}", (Object)objectAvailabilityResponse);
                if (objectAvailabilityResponse == null) {
                    throw new StorageServerClientException("Null objectAvailabilityResponse");
                }
                bulkObjectAvailabilityResponse = objectAvailabilityResponse;
                if (response == null) break block10;
            }
            catch (Throwable requestResponseOK) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            requestResponseOK.addSuppressed(throwable);
                        }
                    }
                    throw requestResponseOK;
                }
                catch (VitamClientInternalException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, e);
                }
            }
            response.close();
        }
        return bulkObjectAvailabilityResponse;
    }

    @Override
    public String getReferentOffer(String strategyId) throws StorageNotFoundClientException, StorageServerClientException {
        String string;
        block9: {
            Integer tenantId = ParameterHelper.getTenantParameter();
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/referentOffer").withHeader("X-Tenant-Id", (Object)tenantId).withHeader("X-Strategy-Id", (Object)strategyId).withJsonAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                RequestResponse referentOfferForStrategyResponse = RequestResponse.parseFromResponse((Response)response, String.class);
                if (!referentOfferForStrategyResponse.isOk()) {
                    throw new StorageException("Exception while retrieving referent Offer for strategy " + strategyId);
                }
                string = (String)((RequestResponseOK)referentOfferForStrategyResponse).getFirstResult();
                if (response == null) break block9;
            }
            catch (Throwable referentOfferForStrategyResponse) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            referentOfferForStrategyResponse.addSuppressed(throwable);
                        }
                    }
                    throw referentOfferForStrategyResponse;
                }
                catch (VitamClientInternalException | StorageException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, e);
                }
            }
            response.close();
        }
        return string;
    }

    @Override
    public Response launchOfferLogCompaction(VitamContext vitamContext, String offerId) throws StorageServerClientException {
        Response response;
        block8: {
            VitamRequestBuilder requestBuilder = VitamRequestBuilder.post().withPath("/compaction").withHeader("X-Tenant-Id", (Object)vitamContext.getTenantId()).withJson().withBody((Object)offerId);
            Response response2 = this.make(requestBuilder);
            try {
                this.check(response2);
                response = response2;
                if (response2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    String errorMessage = VitamCodeHelper.getMessageFromVitamCode((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR);
                    throw new StorageServerClientException(errorMessage, e);
                }
            }
            response2.close();
        }
        return response;
    }

    private void check(Response response) throws VitamClientInternalException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        throw new VitamClientInternalException(String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase()));
    }

    private void checkIllegalOperation(Response response) throws StorageIllegalOperationClientException {
        if (response.getStatus() == Response.Status.NOT_ACCEPTABLE.getStatusCode()) {
            throw new StorageIllegalOperationClientException(String.format("Illegal operation on storage engine, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase()));
        }
    }
}

