/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.translators.mongodb;

import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import java.lang.reflect.Constructor;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.EncoderContext;

public class VitamDocumentCodec<T extends Document>
implements CollectibleCodec<T> {
    private final DocumentCodec documentCodec;
    private final Class<T> clasz;
    private final Constructor<T> constructor;

    public VitamDocumentCodec(Class<T> clazz) {
        try {
            this.documentCodec = new DocumentCodec();
            this.clasz = clazz;
            this.constructor = clazz.getConstructor(Document.class);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        this.documentCodec.encode(writer, value, encoderContext);
    }

    public T generateIdIfAbsentFromDocument(T document) {
        if (!this.documentHasId(document)) {
            GUID uuid = GUIDFactory.newGUID();
            document.put("_id", (Object)uuid.toString());
        }
        return document;
    }

    public boolean documentHasId(T document) {
        return this.documentCodec.documentHasId(document);
    }

    public BsonValue getDocumentId(T document) {
        return this.documentCodec.getDocumentId(document);
    }

    public Class<T> getEncoderClass() {
        return this.clasz;
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        try {
            Document document = this.documentCodec.decode(reader, decoderContext);
            return (T)((Document)this.constructor.newInstance(document));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

