/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.translators.mongodb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.AbstractParser;
import fr.gouv.vitam.common.database.translators.mongodb.RequestToMongodb;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.conversions.Bson;

public class SelectToMongodb
extends RequestToMongodb {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SelectToMongodb.class);
    private static final String UNSUPPORTED_PROJECTION = "Unsupported DSL projection node: '%s'";
    private static final String SLICE_KEYWORD = "$slice";
    private static final int REQUIRED_SLICE_ARRAY_SIZE = 2;

    public SelectToMongodb(AbstractParser<?> selectParser) {
        super(selectParser);
    }

    public Bson getFinalOrderBy() {
        JsonNode orderby = this.requestParser.getRequest().getFilter().get(BuilderToken.SELECTFILTER.ORDERBY.exactToken());
        if (orderby == null || orderby.size() == 0 || !orderby.fields().hasNext()) {
            return null;
        }
        ArrayList<Bson> sorts = new ArrayList<Bson>(orderby.size());
        Iterator iterator = orderby.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (((JsonNode)entry.getValue()).asInt() > 0) {
                sorts.add(Sorts.ascending((String[])new String[]{(String)entry.getKey()}));
                continue;
            }
            sorts.add(Sorts.descending((String[])new String[]{(String)entry.getKey()}));
        }
        return Sorts.orderBy(sorts);
    }

    public Select getSingleSelect() {
        return (Select)this.requestParser.getRequest();
    }

    public boolean idWasInProjection() {
        if (this.requestParser.getRequest().getAllProjection()) {
            return true;
        }
        JsonNode node = this.requestParser.getRequest().getProjection().get(BuilderToken.PROJECTION.FIELDS.exactToken());
        if (!node.fieldNames().hasNext()) {
            return true;
        }
        JsonNode value = node.get("_id");
        if (value != null && value instanceof NumericNode) {
            return value.asInt() > 0;
        }
        return !this.requestParser.getRequest().getProjection().elements().hasNext();
    }

    public boolean isScoreIncluded() {
        if (this.requestParser.getRequest().getAllProjection()) {
            return true;
        }
        JsonNode node = this.requestParser.getRequest().getProjection().get(BuilderToken.PROJECTION.FIELDS.exactToken());
        JsonNode score = node.get("_score");
        return score == null || score.asInt() > 0;
    }

    public Bson getFinalProjection() throws InvalidParseOperationException {
        if (this.requestParser.getRequest().getAllProjection()) {
            return null;
        }
        JsonNode node = this.requestParser.getRequest().getProjection().get(BuilderToken.PROJECTION.FIELDS.exactToken());
        ArrayList<String> incl = new ArrayList<String>();
        ArrayList<String> excl = new ArrayList<String>();
        HashMap<String, ObjectNode> sliceProjections = new HashMap<String, ObjectNode>();
        Iterator iterator = node.fields();
        boolean idFound = false;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            JsonNode value = (JsonNode)entry.getValue();
            if (value instanceof NumericNode) {
                if (value.asInt() > 0) {
                    if (((String)entry.getKey()).equals("_id")) {
                        idFound = true;
                    }
                    incl.add((String)entry.getKey());
                    continue;
                }
                if (((String)entry.getKey()).equals("_id")) continue;
                excl.add((String)entry.getKey());
                continue;
            }
            if (value instanceof ObjectNode && value.has(SLICE_KEYWORD)) {
                sliceProjections.put((String)entry.getKey(), (ObjectNode)value);
                continue;
            }
            throw new InvalidParseOperationException(String.format(UNSUPPORTED_PROJECTION, JsonHandler.writeAsString((Object)value)));
        }
        if (incl.isEmpty() && excl.isEmpty() && sliceProjections.isEmpty()) {
            return null;
        }
        if (!idFound) {
            incl.add("_id");
        }
        return this.computeBsonProjection(incl, excl, sliceProjections);
    }

    private Bson computeBsonProjection(List<String> incl, List<String> excl, Map<String, ObjectNode> sliceProjections) throws InvalidParseOperationException {
        this.tempFixProjectionPathCollision(incl);
        this.tempFixProjectionPathCollision(excl);
        ArrayList<Bson> projections = new ArrayList<Bson>();
        if (!incl.isEmpty()) {
            projections.add(Projections.include(incl));
            incl.clear();
        }
        if (!excl.isEmpty()) {
            projections.add(Projections.exclude(excl));
            excl.clear();
        }
        if (!sliceProjections.isEmpty()) {
            for (Map.Entry<String, ObjectNode> sliceEntry : sliceProjections.entrySet()) {
                String fieldName = sliceEntry.getKey();
                ObjectNode sliceNode = sliceEntry.getValue();
                this.checkSliceValue(sliceNode);
                JsonNode sliceValueNode = sliceNode.get(SLICE_KEYWORD);
                if (sliceValueNode instanceof ArrayNode) {
                    projections.add(Projections.slice((String)fieldName, (int)sliceValueNode.get(0).asInt(), (int)sliceValueNode.get(1).asInt()));
                    continue;
                }
                projections.add(Projections.slice((String)fieldName, (int)sliceValueNode.asInt()));
            }
            sliceProjections.clear();
        }
        return Projections.fields(projections);
    }

    private void tempFixProjectionPathCollision(List<String> incl) {
        ArrayList<String> allKeys = new ArrayList<String>(incl);
        allKeys.sort(Comparator.naturalOrder());
        for (int i = 0; i < allKeys.size(); ++i) {
            String key = (String)allKeys.get(i);
            for (int j = i + 1; j < allKeys.size(); ++j) {
                String nextKey = (String)allKeys.get(j);
                if (key.length() > nextKey.length() || !nextKey.startsWith(key)) continue;
                if (nextKey.length() == key.length()) {
                    LOGGER.warn("INVALID PROJECTION. IGNORING DUPLICATE KEY '" + key + "'. THIS WILL BE NO MORE SUPPORTED IS FUTURE RELEASES.");
                    incl.remove(nextKey);
                    continue;
                }
                if (nextKey.charAt(key.length()) != '.') continue;
                LOGGER.warn("INVALID PROJECTION. IGNORING KEY PATH COLLISION '" + key + "' VS '" + nextKey + "'. THIS WILL BE NO MORE SUPPORTED IS FUTURE RELEASES.");
                incl.remove(nextKey);
            }
        }
    }

    private void checkSliceValue(ObjectNode sliceNode) throws InvalidParseOperationException {
        ArrayNode sliceValueArray;
        JsonNode sliceValueNode = sliceNode.get(SLICE_KEYWORD);
        if (sliceValueNode instanceof ArrayNode ? !this.isLegalSliceArray(sliceValueArray = (ArrayNode)sliceValueNode) : !(sliceValueNode instanceof NumericNode)) {
            throw new InvalidParseOperationException(String.format(UNSUPPORTED_PROJECTION, JsonHandler.writeAsString((Object)sliceNode)));
        }
    }

    private boolean isLegalSliceArray(ArrayNode sliceValueArray) {
        if (sliceValueArray == null || sliceValueArray.size() != 2) {
            return false;
        }
        for (JsonNode jsonNode : sliceValueArray) {
            if (jsonNode instanceof NumericNode) continue;
            return false;
        }
        return true;
    }
}

