/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.translators.elasticsearch;

import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.collections.DynamicParserTokens;
import fr.gouv.vitam.common.database.parser.request.AbstractParser;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.translators.RequestToAbstract;
import fr.gouv.vitam.common.database.translators.elasticsearch.QueryToElasticsearch;
import fr.gouv.vitam.common.database.translators.elasticsearch.SelectToElasticsearch;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import java.util.List;
import java.util.Set;

public abstract class RequestToElasticsearch
extends RequestToAbstract {
    public RequestToElasticsearch(AbstractParser<?> requestParser) {
        super(requestParser);
    }

    public static RequestToElasticsearch getRequestToElasticsearch(AbstractParser<?> requestParser) throws VitamException {
        if (requestParser instanceof SelectParserMultiple || requestParser instanceof SelectParserSingle) {
            return new SelectToElasticsearch(requestParser);
        }
        throw new VitamException("Only Select Request is allowed on Indexation");
    }

    public co.elastic.clients.elasticsearch._types.query_dsl.Query getInitialRoots(String field) {
        Set roots = this.requestParser.getRequest().getRoots();
        return QueryToElasticsearch.getRoots(field, roots);
    }

    public co.elastic.clients.elasticsearch._types.query_dsl.Query getRequest(co.elastic.clients.elasticsearch._types.query_dsl.Query roots, co.elastic.clients.elasticsearch._types.query_dsl.Query query) {
        return QueryToElasticsearch.getFullCommand(query, roots);
    }

    public co.elastic.clients.elasticsearch._types.query_dsl.Query getNthQueries(int nth, VarNameAdapter adapter, DynamicParserTokens parserTokens) throws IllegalAccessError, InvalidParseOperationException {
        List list = this.requestParser.getRequest().getQueries();
        if (nth >= list.size()) {
            throw new IllegalAccessError("This Query has not enough item to get the position: " + nth);
        }
        Query query = (Query)list.get(nth);
        return QueryToElasticsearch.getCommand(query, adapter, parserTokens);
    }
}

