/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.translators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.AbstractRequest;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.parser.request.AbstractParser;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import java.util.List;

public class RequestToAbstract {
    protected AbstractParser<?> requestParser;

    public RequestToAbstract(AbstractParser<?> requestParser) {
        this.requestParser = requestParser;
    }

    public AbstractParser<?> getRequestParser() {
        return this.requestParser;
    }

    public boolean hasFullTextQuery() {
        return this.requestParser.hasFullTextQuery();
    }

    public boolean hintCache() {
        return this.requestParser.hintCache();
    }

    public boolean hintNoTimeout() {
        return this.requestParser.hintNoTimeout();
    }

    public BuilderToken.FILTERARGS model() {
        return this.requestParser.model();
    }

    public int getLastDepth() {
        return this.requestParser.getLastDepth();
    }

    public AbstractRequest getRequest() {
        return this.requestParser.getRequest();
    }

    public int getNbQueries() {
        return this.requestParser.getRequest().getNbQueries();
    }

    public boolean isMultiple() {
        JsonNode mult;
        ObjectNode filter = this.requestParser.getRequest().getFilter();
        if (filter != null && (mult = filter.get(BuilderToken.MULTIFILTER.MULT.exactToken())) != null) {
            return mult.asBoolean();
        }
        return false;
    }

    public ArrayNode getHints() {
        return (ArrayNode)this.requestParser.getRequest().getFilter().get(BuilderToken.SELECTFILTER.HINT.exactToken());
    }

    public int getFinalLimit() {
        JsonNode node = this.requestParser.getRequest().getFilter().get(BuilderToken.SELECTFILTER.LIMIT.exactToken());
        if (node != null) {
            return node.asInt();
        }
        return 10000;
    }

    public int getFinalOffset() {
        JsonNode node = this.requestParser.getRequest().getFilter().get(BuilderToken.SELECTFILTER.OFFSET.exactToken());
        if (node != null) {
            return node.asInt();
        }
        return 0;
    }

    public String getUsage() {
        JsonNode node = ((SelectParserMultiple)this.requestParser).getRequest().getProjection().get(BuilderToken.PROJECTION.USAGE.exactToken());
        if (node != null) {
            return node.asText();
        }
        return null;
    }

    public final Query getNthQuery(int nth) {
        List list = this.requestParser.getRequest().getQueries();
        if (nth >= list.size()) {
            throw new IllegalAccessError("This Query has not enough item to get the position: " + nth);
        }
        return (Query)list.get(nth);
    }
}

