/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server.elasticsearch;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.api.impl.VitamElasticsearchRepository;
import fr.gouv.vitam.common.database.api.impl.VitamMongoRepository;
import fr.gouv.vitam.common.database.index.model.ReindexationKO;
import fr.gouv.vitam.common.database.index.model.ReindexationOK;
import fr.gouv.vitam.common.database.index.model.ReindexationResult;
import fr.gouv.vitam.common.database.index.model.SwitchIndexResult;
import fr.gouv.vitam.common.database.parameter.IndexParameters;
import fr.gouv.vitam.common.database.parameter.SwitchIndexParameters;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchAccess;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexSettings;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchUtil;
import fr.gouv.vitam.common.database.server.elasticsearch.model.ElasticsearchCollections;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.bson.Document;

public class IndexationHelper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IndexationHelper.class);
    private static final IndexationHelper instance = new IndexationHelper();

    public static IndexationHelper getInstance() {
        return instance;
    }

    public ReindexationOK reindex(MongoCollection<Document> collection, ElasticsearchAccess esClient, ElasticsearchIndexAlias indexAlias, ElasticsearchIndexSettings indexSettings, ElasticsearchCollections elasticsearchCollection, List<Integer> tenantIds, String tenantGroupName, String elasticsearchConfigurationFilePath) throws DatabaseException {
        try (MongoCursor cursor = null;){
            long numberOfDocumentsToIndex;
            VitamMongoRepository vitamMongoRepository = new VitamMongoRepository(collection);
            if (CollectionUtils.isNotEmpty(tenantIds)) {
                LOGGER.warn("Reindexation started on index {} in tenants {}", (Object)indexAlias.getName(), tenantIds);
                cursor = vitamMongoRepository.findDocuments(Filters.in((String)"_tenant", tenantIds), VitamConfiguration.getMaxElasticsearchBulk()).iterator();
                numberOfDocumentsToIndex = vitamMongoRepository.count(Filters.in((String)"_tenant", tenantIds));
            } else {
                LOGGER.warn("Reindexation started on index {} in all tenants", (Object)indexAlias.getName());
                cursor = vitamMongoRepository.findDocuments(VitamConfiguration.getMaxElasticsearchBulk()).iterator();
                numberOfDocumentsToIndex = vitamMongoRepository.count();
            }
            ElasticsearchIndexAlias newIndexWithoutAlias = esClient.createIndexWithoutAlias(indexAlias, indexSettings, elasticsearchConfigurationFilePath);
            VitamElasticsearchRepository vitamElasticsearchRepository = new VitamElasticsearchRepository(esClient.getClient(), tenant -> newIndexWithoutAlias);
            LOGGER.warn("number of documents to index = {}", (Object)numberOfDocumentsToIndex);
            long numberOfDocumentsIndexed = 0L;
            UnmodifiableIterator bulkDocumentIterator = Iterators.partition((Iterator)cursor, (int)VitamConfiguration.getMaxElasticsearchBulk());
            while (bulkDocumentIterator.hasNext()) {
                List documents = (List)bulkDocumentIterator.next();
                if (elasticsearchCollection == ElasticsearchCollections.OPERATION) {
                    vitamElasticsearchRepository.save(ElasticsearchCollections.OPERATION, documents);
                } else {
                    vitamElasticsearchRepository.save(documents);
                }
                LOGGER.warn("Reindexation in progress {}%", (Object)(0.01 * (double)((int)((float)(numberOfDocumentsIndexed += (long)documents.size()) / (float)numberOfDocumentsToIndex * 10000.0f))));
                LOGGER.warn("number of indexed documents = {}\t number of remaining documents = {}", (Object)numberOfDocumentsIndexed, (Object)(numberOfDocumentsToIndex - numberOfDocumentsIndexed));
            }
            LOGGER.warn("Reindexation ended successfully");
            ReindexationOK reindexationOK = new ReindexationOK(indexAlias.getName(), newIndexWithoutAlias.getName(), tenantIds, tenantGroupName);
            return reindexationOK;
        }
    }

    public SwitchIndexResult switchIndex(ElasticsearchIndexAlias indexAlias, ElasticsearchIndexAlias newIndex, ElasticsearchAccess esClient) throws DatabaseException {
        try {
            if (!indexAlias.isValidAliasOfIndex(newIndex)) {
                throw new DatabaseException("Illegal index name '" + String.valueOf(newIndex) + "' for alias '" + indexAlias.getName() + "'");
            }
            esClient.switchIndex(indexAlias, newIndex);
            return new SwitchIndexResult().setAlias(indexAlias.getName()).setIndexName(newIndex.getName()).setStatusCode(StatusCode.OK);
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException((Exception)e);
        }
    }

    public ReindexationResult getFullKOResult(IndexParameters indexParameters, String message) {
        ReindexationResult result = new ReindexationResult();
        result.setIndexKO(Collections.singletonList(new ReindexationKO(indexParameters.getTenants(), null, message)));
        result.setCollectionName(indexParameters.getCollectionName());
        return result;
    }

    public SwitchIndexResult getKOResult(SwitchIndexParameters switchIndexParameters, String message) {
        return new SwitchIndexResult().setAlias(switchIndexParameters.getAlias()).setIndexName(switchIndexParameters.getIndexName()).setStatusCode(StatusCode.KO).setMessage(message);
    }
}

