/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server.elasticsearch;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import java.time.LocalDateTime;
import java.util.regex.Pattern;

public class ElasticsearchIndexAlias {
    private static final Pattern ES_INDEX_OR_ALIAS_NAME_PATTERN = Pattern.compile("^[a-z0-9_]+$");
    private final String name;

    public static ElasticsearchIndexAlias ofCrossTenantCollection(String collectionName) {
        ParametersChecker.checkParameter((String)"Missing collection name", (String[])new String[]{collectionName});
        return new ElasticsearchIndexAlias(collectionName.toLowerCase());
    }

    public static ElasticsearchIndexAlias ofMultiTenantCollection(String collectionName, int tenantId) {
        ParametersChecker.checkParameter((String)"Missing collection name", (String[])new String[]{collectionName});
        return new ElasticsearchIndexAlias(collectionName.toLowerCase() + "_" + tenantId);
    }

    public static ElasticsearchIndexAlias ofMultiTenantCollection(String collectionName, String tenantGroupName) {
        ParametersChecker.checkParameter((String)"Missing collection name", (String[])new String[]{collectionName});
        ParametersChecker.checkParameter((String)"Missing tenant group name", (String[])new String[]{tenantGroupName});
        return new ElasticsearchIndexAlias(collectionName.toLowerCase() + "_" + tenantGroupName);
    }

    public static ElasticsearchIndexAlias ofFullIndexName(String fullIndexName) {
        ParametersChecker.checkParameter((String)"Missing collection name", (String[])new String[]{fullIndexName});
        return new ElasticsearchIndexAlias(fullIndexName);
    }

    private ElasticsearchIndexAlias(String name) {
        if (!ES_INDEX_OR_ALIAS_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalStateException("Invalid alias name '" + name + "'");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValidAliasOfIndex(ElasticsearchIndexAlias indexName) {
        ParametersChecker.checkParameter((String)"Missing index name", (Object[])new Object[]{indexName});
        return indexName.getName().startsWith(this.name + "_");
    }

    public ElasticsearchIndexAlias createUniqueIndexName() {
        String currentDate = LocalDateUtil.getFormattedDateForEsIndexes((LocalDateTime)LocalDateUtil.now());
        return ElasticsearchIndexAlias.ofFullIndexName(this.name + "_" + currentDate);
    }

    public String toString() {
        return "ElasticsearchIndexAlias{name='" + this.name + "'}";
    }
}

