/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.OpType;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.ShardFailure;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.cluster.HealthRequest;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.ClearScrollRequest;
import co.elastic.clients.elasticsearch.core.ClearScrollResponse;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.ScrollRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.bulk.DeleteOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.elasticsearch.core.search.TrackHits;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexResponse;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexResponse;
import co.elastic.clients.elasticsearch.indices.ExistsAliasRequest;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.GetAliasRequest;
import co.elastic.clients.elasticsearch.indices.GetAliasResponse;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.RefreshRequest;
import co.elastic.clients.elasticsearch.indices.RefreshResponse;
import co.elastic.clients.elasticsearch.indices.UpdateAliasesRequest;
import co.elastic.clients.elasticsearch.indices.UpdateAliasesResponse;
import co.elastic.clients.elasticsearch.indices.update_aliases.Action;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.instrumentation.Instrumentation;
import co.elastic.clients.transport.instrumentation.NoopInstrumentation;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import co.elastic.clients.util.ObjectBuilder;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexSettings;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchNode;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchUtil;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamFatalRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.server.application.configuration.DatabaseConnection;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpHost;
import org.bson.Document;
import org.elasticsearch.client.RestClient;

public class ElasticsearchAccess
implements DatabaseConnection {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ElasticsearchAccess.class);
    public static final int DEFAULT_SCROLL_TIMEOUT = 60000;
    public static final int DEFAULT_LIMIT_SCROLL = 100;
    public static final String SCROLL_ACTIVATE_KEYWORD = "START";
    private final AtomicReference<ElasticsearchClient> esClient = new AtomicReference();
    protected final String clusterName;
    protected final List<ElasticsearchNode> nodes;

    public ElasticsearchAccess(String clusterName, List<ElasticsearchNode> nodes) throws VitamException {
        ParametersChecker.checkParameter((String)"clusterName, elasticsearch nodes list are a mandatory parameters", (Object[])new Object[]{clusterName, nodes});
        if (nodes.isEmpty()) {
            throw new VitamException("elasticsearch nodes list is empty");
        }
        this.clusterName = clusterName;
        this.nodes = nodes;
    }

    public final GetAliasResponse getAlias(ElasticsearchIndexAlias indexAlias) throws IOException, ElasticsearchException {
        GetAliasRequest request = new GetAliasRequest.Builder().name(indexAlias.getName(), new String[0]).expandWildcards(List.of(ExpandWildcard.Open)).allowNoIndices(Boolean.valueOf(false)).build();
        return this.getClient().indices().getAlias(request);
    }

    public final ElasticsearchIndexAlias createIndexWithoutAlias(ElasticsearchIndexAlias indexAlias, ElasticsearchIndexSettings indexSettings, String elasticsearchConfigurationFile) throws DatabaseException {
        ElasticsearchIndexAlias newIndexName = indexAlias.createUniqueIndexName();
        this.createIndexWithOptionalAlias(null, newIndexName.getName(), indexSettings.loadMapping(), indexSettings.getShards(), indexSettings.getReplicas(), elasticsearchConfigurationFile);
        return newIndexName;
    }

    private void createIndexWithOptionalAlias(String aliasName, String indexName, String mapping, Integer shards, Integer replicas, String elasticsearchConfigurationFile) throws DatabaseException {
        try {
            CreateIndexRequest.Builder requestBuilder = new CreateIndexRequest.Builder().index(indexName).settings(this.createIndexSettings(shards, replicas, elasticsearchConfigurationFile)).mappings(((TypeMapping.Builder)new TypeMapping.Builder().withJson((Reader)new StringReader(mapping))).build());
            if (aliasName != null) {
                requestBuilder.aliases(Map.of(aliasName, new Alias.Builder().build()));
            }
            requestBuilder.timeout(ElasticsearchUtil.timeOfMilliseconds(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds()));
            requestBuilder.masterTimeout(ElasticsearchUtil.timeOfMilliseconds(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds()));
            CreateIndexResponse createIndexResponse = this.getClient().indices().create(requestBuilder.build());
            if (!createIndexResponse.acknowledged() || !createIndexResponse.shardsAcknowledged()) {
                throw new DatabaseException("Could not create index " + indexName + ". acknowledged: " + createIndexResponse.acknowledged() + ", shardsAcknowledged: " + createIndexResponse.shardsAcknowledged());
            }
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException("Could not create index " + indexName, (Exception)e);
        }
    }

    public final boolean existsAlias(ElasticsearchIndexAlias indexAlias) throws DatabaseException {
        try {
            ExistsAliasRequest existsAliasRequest = new ExistsAliasRequest.Builder().name(indexAlias.getName(), new String[0]).expandWildcards(List.of(ExpandWildcard.Open)).allowNoIndices(Boolean.valueOf(false)).build();
            return this.getClient().indices().existsAlias(existsAliasRequest).value();
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException("Could not check alias existence " + indexAlias.getName(), (Exception)e);
        }
    }

    public final boolean existsIndex(ElasticsearchIndexAlias index) throws DatabaseException {
        try {
            ExistsRequest existsRequest = new ExistsRequest.Builder().index(index.getName(), new String[0]).expandWildcards(List.of(ExpandWildcard.Open)).allowNoIndices(Boolean.valueOf(false)).build();
            return this.getClient().indices().exists(existsRequest).value();
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException("Could not check index existence " + index.getName(), (Exception)e);
        }
    }

    public final void refreshIndex(ElasticsearchIndexAlias indexAlias) throws DatabaseException {
        RefreshResponse refreshResponse;
        LOGGER.debug("refreshIndex: " + indexAlias.getName());
        RefreshRequest request = new RefreshRequest.Builder().index(indexAlias.getName(), new String[0]).expandWildcards(List.of(ExpandWildcard.Open)).allowNoIndices(Boolean.valueOf(false)).build();
        try {
            refreshResponse = this.getClient().indices().refresh(request);
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException("Could not refresh index ", (Exception)e);
        }
        LOGGER.debug("Refresh request executed with {} successful shards", (Object)refreshResponse.shards().successful().intValue());
        int failedShards = refreshResponse.shards().failed().intValue();
        if (failedShards > 0) {
            throw new DatabaseException(refreshResponse.shards().failures().stream().map(ShardFailure::toString).collect(Collectors.joining("; ")));
        }
    }

    @VisibleForTesting
    protected void purgeIndexForTesting(ElasticsearchIndexAlias indexAlias, Integer tenantId) throws DatabaseException {
        Query query = ElasticsearchUtil.termQuery("_tenant", tenantId);
        this.purgeIndexForTesting(indexAlias, query);
    }

    @VisibleForTesting
    public final void purgeIndexForTesting(ElasticsearchIndexAlias indexAlias) throws DatabaseException {
        this.purgeIndexForTesting(indexAlias, ElasticsearchUtil.matchAll());
    }

    private void purgeIndexForTesting(ElasticsearchIndexAlias indexAlias, Query query) throws DatabaseException {
        try {
            if (this.existsAlias(indexAlias)) {
                DeleteByQueryRequest request = new DeleteByQueryRequest.Builder().index(indexAlias.getName(), new String[0]).conflicts(Conflicts.Proceed).query(query).scrollSize(Long.valueOf(VitamConfiguration.getMaxElasticsearchBulk())).scroll(ElasticsearchUtil.timeOfMilliseconds(VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds())).timeout(ElasticsearchUtil.timeOfMilliseconds(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds())).refresh(Boolean.valueOf(true)).build();
                DeleteByQueryResponse bulkResponse = this.getClient().deleteByQuery(request);
                LOGGER.debug("Purge alias (" + indexAlias.getName() + ") : " + bulkResponse.toString());
                List searchFailures = bulkResponse.failures();
                if (CollectionUtils.isNotEmpty((Collection)searchFailures)) {
                    throw new DatabaseException("ES purge errors : in search phase > " + String.valueOf(searchFailures));
                }
            }
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException((Exception)e);
        }
    }

    public final <T> void indexEntry(ElasticsearchIndexAlias indexAlias, String id, VitamDocument<T> vitamDocument) throws DatabaseException {
        IndexResponse indexResponse = this.indexDocument(indexAlias, id, vitamDocument);
        if (indexResponse.result() != Result.Created && indexResponse.result() != Result.Updated) {
            throw new DatabaseException(String.format("Could not index document on ES. Id=%s, aliasName=%s, response=%s", id, indexAlias.getName(), indexResponse));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexEntries(ElasticsearchIndexAlias indexAlias, Collection<? extends Document> documents, boolean withRefreshIndex) throws DatabaseException {
        UnmodifiableIterator idIterator = Iterators.partition(documents.iterator(), (int)VitamConfiguration.getMaxElasticsearchBulk());
        while (idIterator.hasNext()) {
            List docs = (List)idIterator.next();
            ArrayList docsAndIds = new ArrayList(docs.size());
            BulkRequest.Builder bulkRequestBuilder = new BulkRequest.Builder();
            try {
                docs.forEach(document -> {
                    String id = (String)document.remove((Object)"_id");
                    docsAndIds.add(ImmutablePair.of((Object)document, (Object)id));
                    bulkRequestBuilder.operations(o -> o.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(indexAlias.getName())).id(id)).document(document)));
                });
                try {
                    bulkRequestBuilder.refresh(withRefreshIndex ? Refresh.True : Refresh.False);
                    BulkResponse bulkResponse = this.getClient().bulk(bulkRequestBuilder.build());
                    LOGGER.debug("Written document {}", (Object)bulkResponse.items().size());
                    if (!bulkResponse.errors()) continue;
                    LOGGER.error("Bulk Request failure with error: " + ElasticsearchUtil.buildFailureMessage(bulkResponse));
                    throw new DatabaseException("Bulk Request failure");
                }
                catch (ElasticsearchException | IOException e) {
                    throw ElasticsearchUtil.toDatabaseException((Exception)e);
                }
            }
            finally {
                for (Pair docsAndId : docsAndIds) {
                    ((Document)docsAndId.getLeft()).put("_id", docsAndId.getRight());
                }
            }
        }
    }

    public <T> void updateEntry(ElasticsearchIndexAlias indexAlias, String id, VitamDocument<T> vitamDocument) throws DatabaseException {
        IndexResponse indexResponse = this.indexDocument(indexAlias, id, vitamDocument);
        if (indexResponse.result() != Result.Updated) {
            throw new DatabaseException(String.format("Could not update document on ES. Id=%s, aliasName=%s, response=%s", id, indexAlias.getName(), indexResponse));
        }
    }

    private <T> IndexResponse indexDocument(ElasticsearchIndexAlias indexAlias, String id, VitamDocument<T> vitamDocument) throws DatabaseException {
        IndexRequest request = new IndexRequest.Builder().index(indexAlias.getName()).id(id).document(vitamDocument).refresh(Refresh.True).timeout(ElasticsearchUtil.timeOfMilliseconds(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds())).opType(OpType.Index).build();
        vitamDocument.remove("_id");
        vitamDocument.remove("_score");
        try {
            IndexResponse indexResponse = this.getClient().index(request);
            return indexResponse;
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException((Exception)e);
        }
        finally {
            vitamDocument.put("_id", id);
        }
    }

    public final ResponseBody<ObjectNode> search(ElasticsearchIndexAlias indexAlias, Query query, String[] esProjection, List<SortOptions> sorts, int offset, Integer limit, Map<String, Aggregation> facets) throws DatabaseException, BadRequestException {
        return this.search(indexAlias, query, esProjection, sorts, offset, limit, facets, null, null, false);
    }

    public final ResponseBody<ObjectNode> searchCrossIndices(Set<ElasticsearchIndexAlias> indexAliases, Query query, String[] esProjection, List<SortOptions> sorts, int offset, Integer limit, Map<String, Aggregation> facets, String scrollId, Integer scrollTimeout, boolean trackTotalHits) throws DatabaseException, BadRequestException {
        SearchResponse response;
        SearchRequest.Builder searchRequest = new SearchRequest.Builder().index(indexAliases.stream().map(ElasticsearchIndexAlias::getName).collect(Collectors.toList())).query(query).size(VitamConfiguration.getElasticSearchScrollLimit()).sort(ListUtils.emptyIfNull(sorts)).source(s -> s.filter(f -> f.includes(esProjection == null ? Collections.emptyList() : Arrays.asList(esProjection)))).searchType(SearchType.DfsQueryThenFetch);
        if (trackTotalHits) {
            searchRequest.trackTotalHits(TrackHits.of(t -> t.enabled(Boolean.valueOf(true))));
        }
        if (scrollId != null && !scrollId.isEmpty()) {
            int limitES = limit != null && limit > 0 ? limit : 100;
            int scrollTimeoutES = scrollTimeout != null && scrollTimeout > 0 ? scrollTimeout : 60000;
            searchRequest.scroll(ElasticsearchUtil.timeOfMilliseconds(scrollTimeoutES));
            searchRequest.size(Integer.valueOf(limitES));
            try {
                if (scrollId.equals(SCROLL_ACTIVATE_KEYWORD)) {
                    response = this.getClient().search(searchRequest.build(), ObjectNode.class);
                }
                ScrollRequest scrollRequest = ScrollRequest.of(s -> s.scrollId(scrollId).scroll(ElasticsearchUtil.timeOfMilliseconds(scrollTimeoutES)));
                response = this.getClient().scroll(scrollRequest, ObjectNode.class);
            }
            catch (ElasticsearchException | IOException e) {
                throw ElasticsearchUtil.toDatabaseException((Exception)e);
            }
        } else {
            if (offset != -1) {
                searchRequest.from(Integer.valueOf(offset));
            }
            if (limit != -1) {
                searchRequest.size(limit);
            }
            if (facets != null && !facets.isEmpty()) {
                for (Map.Entry<String, Aggregation> facet : facets.entrySet()) {
                    searchRequest.aggregations(facet.getKey(), facet.getValue());
                }
            }
            searchRequest.query(query);
            LOGGER.debug("ESReq: {}", (Object)searchRequest);
            try {
                response = this.getClient().search(searchRequest.build(), ObjectNode.class);
            }
            catch (ElasticsearchException e) {
                if (e.status() == Response.Status.BAD_REQUEST.getStatusCode()) {
                    throw new BadRequestException((Throwable)ElasticsearchUtil.toDatabaseException((Exception)((Object)e)));
                }
                throw ElasticsearchUtil.toDatabaseException((Exception)((Object)e));
            }
            catch (IOException e) {
                throw ElasticsearchUtil.toDatabaseException(e);
            }
        }
        if (response.timedOut() || Boolean.TRUE.equals(response.terminatedEarly())) {
            LOGGER.error("Request didn't terminate properly " + String.valueOf(response));
            throw new DatabaseException("Error " + String.valueOf(response) + " from : " + String.valueOf(searchRequest) + ":" + String.valueOf(query));
        }
        return response;
    }

    public final ResponseBody<ObjectNode> search(ElasticsearchIndexAlias indexAlias, Query query, String[] esProjection, List<SortOptions> sorts, int offset, Integer limit, Map<String, Aggregation> facets, String scrollId, Integer scrollTimeout, boolean trackTotalHits) throws DatabaseException, BadRequestException {
        return this.searchCrossIndices(Set.of(indexAlias), query, esProjection, sorts, offset, limit, facets, scrollId, scrollTimeout, trackTotalHits);
    }

    public void clearScroll(String scrollId) throws DatabaseException {
        ClearScrollRequest request = ClearScrollRequest.of(s -> s.scrollId(scrollId, new String[0]));
        try {
            ClearScrollResponse response = this.getClient().clearScroll(request);
            boolean success = response.succeeded();
            int released = response.numFreed();
            LOGGER.debug("clear scroll " + scrollId + " > success :" + success + ", released: " + released);
            if (!success) {
                throw new DatabaseException("Clear scroll" + scrollId + " ko");
            }
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException((Exception)e);
        }
    }

    private ElasticsearchClient createClient() {
        HttpHost[] hosts = new HttpHost[this.nodes.size()];
        for (int i = 0; i < this.nodes.size(); ++i) {
            ElasticsearchNode elasticsearchNode = this.nodes.get(i);
            hosts[i] = new HttpHost(elasticsearchNode.getHostName(), elasticsearchNode.getHttpPort(), "http");
        }
        RestClient httpClient = RestClient.builder((HttpHost[])hosts).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectionRequestTimeout(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()).setConnectTimeout(VitamConfiguration.getConnectTimeout().intValue()).setSocketTimeout(VitamConfiguration.getReadTimeout().intValue())).build();
        RestClientTransport transport = new RestClientTransport(httpClient, (JsonpMapper)new JacksonJsonpMapper(), null, (Instrumentation)NoopInstrumentation.INSTANCE);
        return new ElasticsearchClient((ElasticsearchTransport)transport);
    }

    public void close() {
        try {
            ((ElasticsearchTransport)this.getClient()._transport()).close();
        }
        catch (ElasticsearchException | IOException e) {
            throw new VitamFatalRuntimeException(e);
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElasticsearchClient getClient() {
        ElasticsearchClient client = this.esClient.get();
        if (null == client) {
            ElasticsearchAccess elasticsearchAccess = this;
            synchronized (elasticsearchAccess) {
                if (null == this.esClient.get()) {
                    client = this.createClient();
                    this.esClient.set(client);
                }
            }
        }
        return client;
    }

    public List<ElasticsearchNode> getNodes() {
        return this.nodes;
    }

    public boolean checkConnection() {
        try {
            ElasticsearchClient clientCheck = this.createClient();
            return !clientCheck.cluster().health(new HealthRequest.Builder().build()).timedOut();
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
            return false;
        }
    }

    public String getInfo() {
        return this.clusterName;
    }

    public final void createIndexAndAliasIfAliasNotExists(ElasticsearchIndexAlias indexAlias, ElasticsearchIndexSettings indexSettings, String elasticsearchConfigurationFile) throws DatabaseException {
        LOGGER.debug("createIndexAndAliasIfAliasNotExists: {}", (Object)indexAlias.getName());
        if (this.existsAlias(indexAlias)) {
            return;
        }
        ElasticsearchIndexAlias indexName = indexAlias.createUniqueIndexName();
        this.createIndexWithOptionalAlias(indexAlias.getName(), indexName.getName(), indexSettings.loadMapping(), indexSettings.getShards(), indexSettings.getReplicas(), elasticsearchConfigurationFile);
    }

    public final void switchIndex(ElasticsearchIndexAlias indexAlias, ElasticsearchIndexAlias indexNameToSwitchTo) throws DatabaseException, IOException, ElasticsearchException {
        if (!this.existsAlias(indexAlias)) {
            throw new DatabaseException(String.format("Alias does not exist : %s", indexAlias.getName()));
        }
        if (!this.existsIndex(indexNameToSwitchTo)) {
            throw new DatabaseException(String.format("New index does not exist : %s", indexNameToSwitchTo.getName()));
        }
        GetAliasResponse actualIndex = this.getAlias(indexAlias);
        Map aliases = actualIndex.result();
        if (aliases.isEmpty()) {
            throw new DatabaseException("No previous index found");
        }
        String oldIndexName = (String)aliases.keySet().iterator().next();
        LOGGER.debug("Alias (" + indexAlias.getName() + ") map to index (" + oldIndexName + ")");
        Action addNewIndexAliasAction = Action.of(b -> b.add(idx -> idx.index(indexNameToSwitchTo.getName()).alias(indexAlias.getName())));
        Action deleteOldIndexAliasAction = Action.of(b -> b.remove(idx -> idx.index(oldIndexName).alias(indexAlias.getName())));
        UpdateAliasesRequest request = new UpdateAliasesRequest.Builder().actions(addNewIndexAliasAction, new Action[]{deleteOldIndexAliasAction}).timeout(ElasticsearchUtil.timeOfMilliseconds(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds())).masterTimeout(ElasticsearchUtil.timeOfMilliseconds(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds())).build();
        UpdateAliasesResponse response = this.getClient().indices().updateAliases(request);
        if (!response.acknowledged()) {
            LOGGER.error("Cannot switch index" + String.valueOf(response));
            throw new DatabaseException("Could not switch alias index " + indexAlias.getName() + " from " + oldIndexName + " to " + String.valueOf(indexNameToSwitchTo));
        }
    }

    @VisibleForTesting
    public final void deleteIndexByAliasForTesting(ElasticsearchIndexAlias indexAlias) throws DatabaseException {
        GetAliasResponse aliasResponse;
        try {
            aliasResponse = this.getAlias(indexAlias);
        }
        catch (ElasticsearchException e) {
            if (e.status() != 404) {
                throw ElasticsearchUtil.toDatabaseException((Exception)((Object)e));
            }
            return;
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
        for (Map.Entry entry : aliasResponse.result().entrySet()) {
            this.deleteIndexForTesting((String)entry.getKey());
        }
    }

    @VisibleForTesting
    public final void deleteIndexForTesting(ElasticsearchIndexAlias indexAlias) throws DatabaseException {
        this.deleteIndexForTesting(indexAlias.getName());
    }

    private void deleteIndexForTesting(String indexFullName) throws DatabaseException {
        DeleteIndexRequest request = new DeleteIndexRequest.Builder().index(indexFullName, new String[0]).timeout(ElasticsearchUtil.timeOfMilliseconds(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds())).masterTimeout(ElasticsearchUtil.timeOfMilliseconds(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds())).expandWildcards(List.of(ExpandWildcard.Open)).allowNoIndices(Boolean.valueOf(false)).build();
        try {
            DeleteIndexResponse deleteIndexResponse = this.getClient().indices().delete(request);
            if (!deleteIndexResponse.acknowledged()) {
                throw new DatabaseException("Error while deleting index " + indexFullName + ". Not acknowledged");
            }
        }
        catch (Exception exception) {
            if (exception instanceof ElasticsearchException && ((ElasticsearchException)((Object)exception)).status() == Response.Status.NOT_FOUND.getStatusCode()) {
                return;
            }
            throw new DatabaseException("Error while deleting index " + indexFullName, (Throwable)exception);
        }
    }

    public void delete(ElasticsearchIndexAlias indexAlias, List<String> ids) throws DatabaseException {
        UnmodifiableIterator idIterator = Iterators.partition(ids.iterator(), (int)VitamConfiguration.getMaxElasticsearchBulk());
        while (idIterator.hasNext()) {
            BulkResponse bulkResponse;
            BulkRequest.Builder bulkRequestBuilder = new BulkRequest.Builder();
            for (String id : (List)idIterator.next()) {
                bulkRequestBuilder.operations(op -> op.delete(idx -> (ObjectBuilder)((DeleteOperation.Builder)idx.index(indexAlias.getName())).id(id)));
            }
            bulkRequestBuilder.refresh(idIterator.hasNext() ? Refresh.False : Refresh.True);
            try {
                bulkResponse = this.getClient().bulk(bulkRequestBuilder.build());
            }
            catch (ElasticsearchException | IOException e) {
                throw ElasticsearchUtil.toDatabaseException("Bulk delete exception", (Exception)e);
            }
            if (!bulkResponse.errors()) continue;
            throw new DatabaseException("ES delete in error: " + ElasticsearchUtil.buildFailureMessage(bulkResponse));
        }
    }

    private IndexSettings createIndexSettings(int shards, int replicas, String elasticsearchConfigurationFile) throws IOException {
        return ((IndexSettings.Builder)new IndexSettings.Builder().withJson(this.getElasticSearchSettingAsInputStream(elasticsearchConfigurationFile))).numberOfShards(String.valueOf(shards)).numberOfReplicas(String.valueOf(replicas)).build();
    }

    private InputStream getElasticSearchSettingAsInputStream(String elasticsearchConfigurationFilePath) throws FileNotFoundException {
        try {
            Path elasticSearchConfigPath = Paths.get(elasticsearchConfigurationFilePath, new String[0]);
            SanityChecker.checkJsonFile((File)elasticSearchConfigPath.toFile());
            return Files.newInputStream(elasticSearchConfigPath, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Elastic search File not found with path " + elasticsearchConfigurationFilePath);
            throw new FileNotFoundException(e.getMessage());
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Invalid Elastic search settings file ");
            throw new IllegalStateException(e.getMessage());
        }
    }
}

