/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;

public class OplogReader {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(OplogReader.class);
    public static final String OPERATION_TYPE = "op";
    public static final String COLLECTION_NAME = "ns";
    public static final String OPERATION_TIME = "ts";
    public static final String FIELD_TIME = "Time";
    public static final String FIELD_INCREMENT = "Inc";
    public static final String FIELD_O_2 = "o2";
    public static final String FIELD_O = "o";
    public static final String FIELD_ID = "_id";
    public static final String INSERT_OPERATION = "i";
    public static final String UPDATE_OPERATION = "u";
    public static final String DELETE_OPERATION = "d";
    public static final String PATH = "path";
    private static final String LOCALDB = "local";
    private static final String OPLOG = "oplog.rs";
    public static final String NATURAL = "$natural";
    private final MongoClient mongoClient;
    private final Integer dataMaxSize;

    public OplogReader(MongoClient mongoClient, Integer dataMaxSize) {
        this.mongoClient = mongoClient;
        this.dataMaxSize = dataMaxSize;
    }

    public Map<String, Document> readDocumentsFromOplogByShardAndCollections(List<String> collectionsToReadOplog, BsonTimestamp maxTimeStamp) {
        Map<String, Document> recentlyTouchedDocuments = this.readOplog(collectionsToReadOplog, maxTimeStamp);
        this.mongoClient.close();
        return recentlyTouchedDocuments;
    }

    private Map<String, Document> readOplog(List<String> collectionsToReadOplog, BsonTimestamp maxTimeStamp) {
        LOGGER.info("Start reading Oplog");
        HashMap<String, Document> touchedDocumentsByRecentTime = new HashMap<String, Document>();
        ArrayList<Document> opLogList = new ArrayList<Document>();
        ArrayList<Bson> bsonsFilters = new ArrayList<Bson>();
        bsonsFilters.add(Filters.in((String)OPERATION_TYPE, Arrays.asList(INSERT_OPERATION, UPDATE_OPERATION, DELETE_OPERATION)));
        bsonsFilters.add(Filters.in((String)COLLECTION_NAME, collectionsToReadOplog));
        if (maxTimeStamp != null) {
            bsonsFilters.add(Filters.gt((String)OPERATION_TIME, (Object)maxTimeStamp));
        }
        Document sort = new Document(NATURAL, (Object)1);
        Bson filter = Filters.and(bsonsFilters);
        MongoCollection oplogCollection = this.mongoClient.getDatabase(LOCALDB).getCollection(OPLOG);
        MongoCursor cursor = oplogCollection.find(filter).sort((Bson)sort).limit(this.dataMaxSize.intValue()).iterator();
        while (cursor.hasNext()) {
            OplogReader.populateOplogList(opLogList, (Document)cursor.next());
        }
        touchedDocumentsByRecentTime.putAll(opLogList.stream().collect(Collectors.toMap(OplogReader::extractFieldId, elmt -> elmt)));
        return touchedDocumentsByRecentTime;
    }

    private static void populateOplogList(List<Document> opLogList, Document document) {
        Optional<Document> isAlreadyScannedDoc = opLogList.stream().filter(elmt -> OplogReader.extractFieldId(elmt).equals(OplogReader.extractFieldId(document))).findFirst();
        if (isAlreadyScannedDoc.isPresent()) {
            if (OplogReader.extractFieldTimeStamp(document).compareTo(OplogReader.extractFieldTimeStamp(isAlreadyScannedDoc.get())) > 0) {
                opLogList.remove(isAlreadyScannedDoc.get());
                opLogList.add(document);
            }
        } else {
            opLogList.add(document);
        }
    }

    private static String extractFieldId(Document elmt) {
        if (elmt.get((Object)OPERATION_TYPE).equals(UPDATE_OPERATION)) {
            return ((Document)elmt.get((Object)FIELD_O_2)).get((Object)FIELD_ID).toString();
        }
        return ((Document)elmt.get((Object)FIELD_O)).get((Object)FIELD_ID).toString();
    }

    private static BsonTimestamp extractFieldTimeStamp(Document elmt) {
        return (BsonTimestamp)elmt.get((Object)OPERATION_TIME);
    }
}

