/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.collections.DynamicParserTokens;
import fr.gouv.vitam.common.database.parser.request.AbstractParser;
import fr.gouv.vitam.common.database.parser.request.GlobalDatasParser;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.database.parser.request.single.UpdateParserSingle;
import fr.gouv.vitam.common.database.server.RuleUpdateErrorCode;
import fr.gouv.vitam.common.database.server.RuleUpdateException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.DurationData;
import fr.gouv.vitam.common.model.QueryPattern;
import fr.gouv.vitam.common.model.administration.RuleType;
import fr.gouv.vitam.common.model.massupdate.ManagementMetadataAction;
import fr.gouv.vitam.common.model.massupdate.RuleAction;
import fr.gouv.vitam.common.model.massupdate.RuleActions;
import fr.gouv.vitam.common.model.massupdate.RuleCategoryAction;
import fr.gouv.vitam.common.model.massupdate.RuleCategoryActionDeletion;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MongoDbInMemory {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MongoDbInMemory.class);
    private static final String RULES_KEY = "Rules";
    private static final String MANAGEMENT_KEY = "_mgt";
    private static final String FINAL_ACTION_KEY = "FinalAction";
    private static final String INHERITANCE = "Inheritance";
    private static final String PREVENT_INHERITANCE = "PreventInheritance";
    private static final String PREVENT_RULES_ID = "PreventRulesId";
    private static final String ACTION_ARGUMENT = "]Action argument (";
    private static final String EXPECTED_VALUE = ") expected value array for field ";
    private static final String COULD_NOT_CONVERTED = ") cannot be converted as number for field ";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final SerializerProvider EMPTY_SERIALIZER_FOR_OBJECT_NODE = null;
    private final JsonNode originalDocument;
    private final DynamicParserTokens parserTokens;
    private JsonNode updatedDocument;
    private final Set<String> updatedFields;

    public MongoDbInMemory(JsonNode originalDocument, DynamicParserTokens parserTokens) {
        this.originalDocument = originalDocument;
        this.parserTokens = parserTokens;
        this.updatedDocument = originalDocument.deepCopy();
        this.updatedFields = new HashSet<String>();
    }

    public JsonNode getUpdateJson(JsonNode request, boolean isMultiple, VarNameAdapter varNameAdapter) throws InvalidParseOperationException {
        AbstractParser parser = isMultiple ? new UpdateParserMultiple(varNameAdapter) : new UpdateParserSingle(varNameAdapter);
        parser.parse(request);
        return this.getUpdateJson(parser);
    }

    public JsonNode getUpdateJson(AbstractParser<?> requestParser) throws InvalidParseOperationException {
        List actions = requestParser.getRequest().getActions();
        if (actions == null || actions.isEmpty()) {
            LOGGER.info("No action on request");
            return this.updatedDocument;
        }
        for (Action action : actions) {
            BuilderToken.UPDATEACTION req = action.getUPDATEACTION();
            JsonNode content = action.getCurrentAction().get(req.exactToken());
            switch (req) {
                case ADD: {
                    this.add(req, content);
                    break;
                }
                case INC: {
                    this.inc(req, content);
                    break;
                }
                case MIN: {
                    this.min(req, content);
                    break;
                }
                case MAX: {
                    this.max(req, content);
                    break;
                }
                case POP: {
                    this.pop(req, content);
                    break;
                }
                case PULL: {
                    this.pull(req, content);
                    break;
                }
                case PUSH: {
                    this.push(req, content);
                    break;
                }
                case RENAME: {
                    this.rename(req, content);
                    break;
                }
                case SET: {
                    this.set(content);
                    break;
                }
                case UNSET: {
                    this.unset(content);
                    break;
                }
                case SETREGEX: {
                    this.setRegex(content);
                    break;
                }
            }
        }
        return this.updatedDocument;
    }

    public JsonNode getUpdateJsonForRule(RuleActions ruleActions, Map<String, DurationData> bindRuleToDuration) throws InvalidParseOperationException, RuleUpdateException {
        if (ruleActions != null) {
            ObjectNode initialMgt = (ObjectNode)this.getOrCreateEmptyNodeByName(this.updatedDocument, MANAGEMENT_KEY, false);
            this.applyAddRuleAction(ruleActions.getAdd(), initialMgt, bindRuleToDuration);
            this.applyUpdateRuleAction(ruleActions.getUpdate(), initialMgt, bindRuleToDuration);
            this.applyDeleteRuleAction(ruleActions.getDelete(), initialMgt);
            this.updateArchiveUnitProfile(ruleActions);
            JsonHandler.setNodeInPath((ObjectNode)((ObjectNode)this.updatedDocument), (String)MANAGEMENT_KEY, (JsonNode)initialMgt, (boolean)true);
        }
        return this.updatedDocument;
    }

    private void applyAddRuleAction(List<Map<String, RuleCategoryAction>> ruleActions, ObjectNode initialMgt, Map<String, DurationData> bindRuleToDuration) throws RuleUpdateException, InvalidParseOperationException {
        if (ruleActions == null || ruleActions.isEmpty()) {
            return;
        }
        for (Map<String, RuleCategoryAction> item : ruleActions) {
            for (Map.Entry<String, RuleCategoryAction> entry : item.entrySet()) {
                String category = entry.getKey();
                RuleCategoryAction ruleCategoryAction = entry.getValue();
                ObjectNode initialRuleCategory = (ObjectNode)this.getOrCreateEmptyNodeByName((JsonNode)initialMgt, category, false);
                this.handleFinalAction(initialRuleCategory, ruleCategoryAction, category);
                this.handleClassificationProperties(initialRuleCategory, ruleCategoryAction, category);
                this.handleInheritanceProperties(initialRuleCategory, ruleCategoryAction);
                this.handleAddPreventRulesProperties(initialRuleCategory, ruleCategoryAction);
                if (!ruleCategoryAction.getRules().isEmpty()) {
                    ArrayNode initialRules = (ArrayNode)this.getOrCreateEmptyNodeByName((JsonNode)initialRuleCategory, RULES_KEY, true);
                    for (RuleAction ruleAction : ruleCategoryAction.getRules()) {
                        if (this.hasRuleDefined(ruleAction.getRule(), initialRules)) continue;
                        JsonNode newRule = this.getJsonNodeFromRuleAction(category, ruleAction, bindRuleToDuration);
                        initialRules.add(newRule);
                    }
                    initialRuleCategory.set(RULES_KEY, (JsonNode)initialRules);
                }
                initialMgt.set(category, (JsonNode)initialRuleCategory);
            }
        }
    }

    private boolean hasRuleDefined(String ruleId, ArrayNode rules) {
        for (JsonNode rule : rules) {
            if (!ruleId.equals(rule.get("Rule").textValue())) continue;
            return true;
        }
        return false;
    }

    private void applyUpdateRuleAction(List<Map<String, RuleCategoryAction>> ruleActions, ObjectNode initialMgt, Map<String, DurationData> bindRuleToDuration) throws RuleUpdateException {
        if (ruleActions == null || ruleActions.isEmpty()) {
            return;
        }
        for (Map<String, RuleCategoryAction> item : ruleActions) {
            for (Map.Entry<String, RuleCategoryAction> entry : item.entrySet()) {
                String category = entry.getKey();
                RuleCategoryAction ruleCategoryAction = entry.getValue();
                ObjectNode initialRuleCategory = (ObjectNode)this.getOrCreateEmptyNodeByName((JsonNode)initialMgt, category, false);
                this.handleFinalAction(initialRuleCategory, ruleCategoryAction, category);
                this.handleClassificationProperties(initialRuleCategory, ruleCategoryAction, category);
                this.handleInheritanceProperties(initialRuleCategory, ruleCategoryAction);
                if (!ruleCategoryAction.getRules().isEmpty()) {
                    Map rulesToUpdate = ruleCategoryAction.getRules().stream().collect(Collectors.toMap(RuleAction::getOldRule, Function.identity()));
                    ArrayNode initialRules = (ArrayNode)this.getOrCreateEmptyNodeByName((JsonNode)initialRuleCategory, RULES_KEY, true);
                    for (JsonNode initialRule : initialRules) {
                        ObjectNode node = (ObjectNode)initialRule;
                        String actualRule = node.get("Rule").asText();
                        if (!rulesToUpdate.containsKey(actualRule)) continue;
                        this.updateJsonNodeUsingRuleAction(category, node, (RuleAction)rulesToUpdate.get(actualRule), bindRuleToDuration);
                    }
                    initialRuleCategory.set(RULES_KEY, (JsonNode)initialRules);
                }
                initialMgt.set(category, (JsonNode)initialRuleCategory);
            }
        }
    }

    private void applyDeleteRuleAction(List<Map<String, RuleCategoryActionDeletion>> ruleActions, ObjectNode initialMgt) {
        ruleActions.stream().flatMap(categoryItems -> categoryItems.entrySet().stream()).forEach(categoryItem -> this.deletionRule(initialMgt, (String)categoryItem.getKey(), (RuleCategoryActionDeletion)categoryItem.getValue()));
    }

    private void deletionRule(ObjectNode initialMgt, String categoryName, RuleCategoryActionDeletion category) {
        JsonNode inheritanceAsJsonNode;
        AtomicBoolean updatedInheritance = new AtomicBoolean(false);
        ObjectNode initialRuleCategory = (ObjectNode)this.getOrCreateEmptyNodeByName((JsonNode)initialMgt, categoryName, false);
        ObjectNode inheritance = (ObjectNode)initialRuleCategory.get(INHERITANCE);
        if (initialMgt.isEmpty(EMPTY_SERIALIZER_FOR_OBJECT_NODE)) {
            return;
        }
        if (Objects.isNull(category) || category.isEmpty()) {
            initialMgt.remove(categoryName);
            return;
        }
        JsonNode categoryAsJsonNode = initialMgt.path(categoryName);
        if (categoryAsJsonNode.isMissingNode() || categoryAsJsonNode.isNull() || !categoryAsJsonNode.isObject()) {
            return;
        }
        ObjectNode initialCategory = (ObjectNode)categoryAsJsonNode;
        if (Objects.nonNull(category.getRules())) {
            category.getRules().ifPresent(rules -> {
                List rulesToDelete = rules.stream().map(RuleAction::getRule).collect(Collectors.toList());
                ArrayNode initialRules = (ArrayNode)this.getOrCreateEmptyNodeByName((JsonNode)initialCategory, RULES_KEY, true);
                ArrayNode filteredRules = JsonHandler.createArrayNode();
                initialRules.forEach(node -> {
                    if (!rulesToDelete.contains(node.get("Rule").asText())) {
                        filteredRules.add(node);
                    }
                });
                initialCategory.set(RULES_KEY, (JsonNode)filteredRules);
            });
        }
        if (inheritance == null) {
            inheritance = JsonHandler.createObjectNode();
        }
        if (category.getPreventInheritance() != null) {
            updatedInheritance.set(true);
            inheritance.put(PREVENT_INHERITANCE, (Boolean)category.getPreventInheritance().get());
        }
        if (CollectionUtils.isNotEmpty((Collection)category.getPreventRulesIdToRemove())) {
            if (CollectionUtils.isNotEmpty((Collection)category.getPreventRulesId())) {
                LOGGER.error("Invalid request. Cannot set both PreventRulesIdToRemove & PreventRulesId. " + JsonHandler.unprettyPrint((Object)category));
                throw new IllegalStateException("Invalid request. Cannot set both PreventRulesIdToRemove & PreventRulesId.");
            }
            ArrayList preventRulesToDelete = new ArrayList(category.getPreventRulesIdToRemove());
            ArrayNode initialRules = (ArrayNode)this.getOrCreateEmptyNodeByName((JsonNode)inheritance, PREVENT_RULES_ID, true);
            ArrayNode filteredRules = JsonHandler.createArrayNode();
            initialRules.forEach(node -> {
                if (!preventRulesToDelete.contains(node.textValue())) {
                    filteredRules.add(node);
                }
            });
            inheritance.set(PREVENT_RULES_ID, (JsonNode)filteredRules);
        }
        if (updatedInheritance.get()) {
            initialRuleCategory.set(INHERITANCE, (JsonNode)inheritance);
        }
        if (Objects.nonNull(category.getRules()) && category.getRules().isEmpty()) {
            initialCategory.remove("Rule");
        }
        if (Objects.nonNull(category.getFinalAction())) {
            initialCategory.remove(FINAL_ACTION_KEY);
        }
        if (Objects.nonNull(category.getClassificationAudience())) {
            initialCategory.remove("ClassificationAudience");
        }
        if (Objects.nonNull(category.getClassificationReassessingDate())) {
            initialCategory.remove("ClassificationReassessingDate");
        }
        if (Objects.nonNull(category.getNeedReassessingAuthorization())) {
            initialCategory.remove("NeedReassessingAuthorization");
        }
        if ((inheritanceAsJsonNode = initialCategory.path(INHERITANCE)).isMissingNode() || inheritanceAsJsonNode.isNull() || !inheritanceAsJsonNode.isObject()) {
            return;
        }
        ObjectNode initialInheritance = (ObjectNode)inheritanceAsJsonNode;
        if (Objects.nonNull(category.getPreventInheritance())) {
            initialInheritance.remove(PREVENT_INHERITANCE);
        }
        if (Objects.nonNull(category.getPreventRulesId()) && CollectionUtils.isEmpty((Collection)category.getPreventRulesIdToRemove())) {
            initialInheritance.remove(PREVENT_RULES_ID);
        }
        if (initialInheritance.isEmpty(EMPTY_SERIALIZER_FOR_OBJECT_NODE)) {
            initialCategory.remove(INHERITANCE);
        }
        if (initialCategory.isEmpty(EMPTY_SERIALIZER_FOR_OBJECT_NODE)) {
            initialMgt.remove(categoryName);
        }
    }

    private JsonNode getOrCreateEmptyNodeByName(JsonNode parent, String fieldName, boolean acceptArray) {
        return parent.hasNonNull(fieldName) ? parent.get(fieldName) : (acceptArray ? JsonHandler.createArrayNode() : JsonHandler.createObjectNode());
    }

    private Boolean shouldDeleteAUP(RuleActions ruleActions) {
        ManagementMetadataAction deleteActions = ruleActions.getDeleteMetadata();
        return deleteActions != null && deleteActions.getArchiveUnitProfile() != null;
    }

    private void updateArchiveUnitProfile(RuleActions ruleActions) {
        if (this.shouldDeleteAUP(ruleActions).booleanValue()) {
            ((ObjectNode)this.updatedDocument).remove("ArchiveUnitProfile");
            return;
        }
        ManagementMetadataAction newMetadata = ruleActions.getAddOrUpdateMetadata();
        if (newMetadata != null && StringUtils.isNotBlank((CharSequence)newMetadata.getArchiveUnitProfile())) {
            ((ObjectNode)this.updatedDocument).put("ArchiveUnitProfile", newMetadata.getArchiveUnitProfile());
        }
    }

    private void handleFinalAction(ObjectNode initialRuleCategory, RuleCategoryAction ruleCategoryAction, String category) {
        String finalAction;
        if (("AppraisalRule".equals(category) || "StorageRule".equals(category)) && (finalAction = ruleCategoryAction.getFinalAction()) != null) {
            initialRuleCategory.put(FINAL_ACTION_KEY, finalAction);
        }
    }

    private void handleClassificationProperties(ObjectNode initialRuleCategory, RuleCategoryAction ruleCategoryAction, String category) {
        Boolean needReassessingAuthorization;
        String classificationAudience;
        String classificationReassessingDate;
        String classificationOwner;
        if (!"ClassificationRule".equals(category)) {
            return;
        }
        String classificationLevel = ruleCategoryAction.getClassificationLevel();
        if (classificationLevel != null) {
            initialRuleCategory.put("ClassificationLevel", classificationLevel);
        }
        if ((classificationOwner = ruleCategoryAction.getClassificationOwner()) != null) {
            initialRuleCategory.put("ClassificationOwner", classificationOwner);
        }
        if ((classificationReassessingDate = ruleCategoryAction.getClassificationReassessingDate()) != null) {
            initialRuleCategory.put("ClassificationReassessingDate", classificationReassessingDate);
        }
        if ((classificationAudience = ruleCategoryAction.getClassificationAudience()) != null) {
            initialRuleCategory.put("ClassificationAudience", classificationAudience);
        }
        if ((needReassessingAuthorization = ruleCategoryAction.getNeedReassessingAuthorization()) != null) {
            initialRuleCategory.put("NeedReassessingAuthorization", needReassessingAuthorization);
        }
    }

    private void handleAddPreventRulesProperties(ObjectNode initialRuleCategory, RuleCategoryAction ruleCategoryAction) throws InvalidParseOperationException {
        if (CollectionUtils.isEmpty((Collection)ruleCategoryAction.getPreventRulesIdToAdd())) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)ruleCategoryAction.getPreventRulesId())) {
            LOGGER.error("Invalid request. Cannot set both PreventRulesIdToAdd & PreventRulesId. " + JsonHandler.unprettyPrint((Object)ruleCategoryAction));
            throw new IllegalStateException("Invalid request. Cannot set both PreventRulesIdToAdd & PreventRulesId.");
        }
        ObjectNode inheritance = (ObjectNode)initialRuleCategory.get(INHERITANCE);
        if (inheritance == null) {
            inheritance = JsonHandler.createObjectNode();
        }
        Set preventRuleIds = ruleCategoryAction.getPreventRulesIdToAdd();
        JsonNode initialRules = this.getOrCreateEmptyNodeByName((JsonNode)inheritance, PREVENT_RULES_ID, true);
        preventRuleIds.addAll((Collection)JsonHandler.getFromJsonNode((JsonNode)initialRules, (TypeReference)new TypeReference<List<String>>(this){}));
        inheritance.set(PREVENT_RULES_ID, (JsonNode)this.preventRulesToNode(preventRuleIds));
        initialRuleCategory.set(INHERITANCE, (JsonNode)inheritance);
    }

    private void handleInheritanceProperties(ObjectNode initialRuleCategory, RuleCategoryAction ruleCategoryAction) {
        Set preventRuleIds;
        Boolean preventInheritance;
        boolean updatedInheritance = false;
        ObjectNode inheritance = (ObjectNode)initialRuleCategory.get(INHERITANCE);
        if (inheritance == null) {
            inheritance = JsonHandler.createObjectNode();
        }
        if ((preventInheritance = ruleCategoryAction.getPreventInheritance()) != null) {
            updatedInheritance = true;
            inheritance.put(PREVENT_INHERITANCE, preventInheritance);
        }
        if ((preventRuleIds = ruleCategoryAction.getPreventRulesId()) != null && CollectionUtils.isEmpty((Collection)ruleCategoryAction.getPreventRulesIdToAdd())) {
            updatedInheritance = true;
            inheritance.set(PREVENT_RULES_ID, (JsonNode)this.preventRulesToNode(preventRuleIds));
        }
        if (updatedInheritance) {
            initialRuleCategory.set(INHERITANCE, (JsonNode)inheritance);
        }
    }

    private ArrayNode preventRulesToNode(Set<String> preventRuleIdsToAdd) {
        try {
            return (ArrayNode)JsonHandler.toJsonNode(preventRuleIdsToAdd);
        }
        catch (InvalidParseOperationException e) {
            throw new VitamRuntimeException("Cannot transform preventRulesId.", (Throwable)e);
        }
    }

    private JsonNode getJsonNodeFromRuleAction(String category, RuleAction ruleAction, Map<String, DurationData> bindRuleToDuration) throws RuleUpdateException {
        ObjectNode newRule = JsonHandler.createObjectNode();
        String ruleId = ruleAction.getRule();
        newRule.put("Rule", ruleId);
        this.applyAttributeUpdates(newRule, ruleAction);
        this.computeEndDate(newRule, category, bindRuleToDuration);
        return newRule;
    }

    private void updateJsonNodeUsingRuleAction(String category, ObjectNode unitRule, RuleAction ruleAction, Map<String, DurationData> bindRuleToDuration) throws RuleUpdateException {
        if (ruleAction.getRule() != null) {
            unitRule.put("Rule", ruleAction.getRule());
        }
        this.applyAttributeUpdates(unitRule, ruleAction);
        this.computeEndDate(unitRule, category, bindRuleToDuration);
    }

    private void applyAttributeUpdates(ObjectNode unitRule, RuleAction ruleAction) {
        if (ruleAction.getStartDate() != null) {
            unitRule.put("StartDate", ruleAction.getStartDate());
        }
        if (Boolean.TRUE.equals(ruleAction.getDeleteStartDate())) {
            unitRule.remove("StartDate");
        }
        if (ruleAction.getHoldEndDate() != null) {
            unitRule.put("HoldEndDate", ruleAction.getHoldEndDate());
        }
        if (Boolean.TRUE.equals(ruleAction.getDeleteHoldEndDate())) {
            unitRule.remove("HoldEndDate");
        }
        if (ruleAction.getHoldOwner() != null) {
            unitRule.put("HoldOwner", ruleAction.getHoldOwner());
        }
        if (Boolean.TRUE.equals(ruleAction.getDeleteHoldOwner())) {
            unitRule.remove("HoldOwner");
        }
        if (ruleAction.getHoldReason() != null) {
            unitRule.put("HoldReason", ruleAction.getHoldReason());
        }
        if (Boolean.TRUE.equals(ruleAction.getDeleteHoldReason())) {
            unitRule.remove("HoldReason");
        }
        if (ruleAction.getHoldReassessingDate() != null) {
            unitRule.put("HoldReassessingDate", ruleAction.getHoldReassessingDate());
        }
        if (Boolean.TRUE.equals(ruleAction.getDeleteHoldReassessingDate())) {
            unitRule.remove("HoldReassessingDate");
        }
        if (ruleAction.getPreventRearrangement() != null) {
            unitRule.put("PreventRearrangement", ruleAction.getPreventRearrangement());
        }
        if (Boolean.TRUE.equals(ruleAction.getDeletePreventRearrangement())) {
            unitRule.remove("PreventRearrangement");
        }
    }

    private void ensureStartDateIsBeforeHoldEndDate(ObjectNode unitRule) throws RuleUpdateException {
        if (unitRule.has("StartDate") && unitRule.has("HoldEndDate")) {
            String startDate = unitRule.get("StartDate").asText();
            String holdEndDate = unitRule.get("HoldEndDate").asText();
            LocalDate localStartDate = LocalDate.parse(startDate, DATE_TIME_FORMATTER);
            LocalDate localHoldEndDate = LocalDate.parse(holdEndDate, DATE_TIME_FORMATTER);
            if (localHoldEndDate.isBefore(localStartDate)) {
                throw new RuleUpdateException(RuleUpdateErrorCode.HOLD_END_DATE_BEFORE_START_DATE, "HoldEndDate (" + holdEndDate + ") cannot be before StartDate (" + startDate + ")");
            }
        }
    }

    private void ensureNoHoldEndDateSet(ObjectNode unitRule) throws RuleUpdateException {
        if (unitRule.has("HoldEndDate")) {
            throw new RuleUpdateException(RuleUpdateErrorCode.HOLD_END_DATE_ONLY_ALLOWED_FOR_HOLD_RULE_WITH_UNDEFINED_DURATION, String.format("HoldEndDate (%s) cannot be defined for rule %s", unitRule.get("HoldEndDate").asText(), unitRule.get("Rule").asText()));
        }
    }

    private void computeEndDate(ObjectNode unitRule, String ruleCategory, Map<String, DurationData> bindRuleToDuration) throws RuleUpdateException {
        boolean isHoldRuleWithUndefinedDuration;
        String ruleId = unitRule.get("Rule").asText();
        boolean bl = isHoldRuleWithUndefinedDuration = RuleType.HoldRule.isNameEquals(ruleCategory) && bindRuleToDuration.containsKey(ruleId) && bindRuleToDuration.get(ruleId).getDurationUnit() == null;
        if (isHoldRuleWithUndefinedDuration) {
            if (unitRule.has("HoldEndDate")) {
                String holdEndDate = unitRule.get("HoldEndDate").asText();
                unitRule.put("EndDate", holdEndDate);
            } else {
                unitRule.remove("EndDate");
            }
            this.ensureStartDateIsBeforeHoldEndDate(unitRule);
            return;
        }
        this.ensureNoHoldEndDateSet(unitRule);
        unitRule.remove("EndDate");
        DurationData durationData = bindRuleToDuration.get(ruleId);
        if (durationData == null || unitRule.path("StartDate").isNull() || unitRule.path("StartDate").isMissingNode()) {
            return;
        }
        String startDateString = unitRule.get("StartDate").textValue();
        if (startDateString == null) {
            return;
        }
        LocalDate startDate = LocalDateUtil.getLocalDateFromSimpleFormattedDate((String)startDateString);
        Integer duration = durationData.getDurationValue();
        ChronoUnit temporalUnit = durationData.getDurationUnit();
        LocalDate endDate = startDate.plus(duration.intValue(), temporalUnit);
        unitRule.put("EndDate", LocalDateUtil.getFormattedSimpleDate((LocalDate)endDate));
    }

    @VisibleForTesting
    public void resetUpdatedAU() {
        this.updatedDocument = this.originalDocument.deepCopy();
        this.updatedFields.clear();
    }

    private void inc(BuilderToken.UPDATEACTION req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        String fieldName = (String)element.getKey();
        Number nodeValue = this.getNumberValue(req.name(), fieldName);
        JsonNode actionValue = (JsonNode)element.getValue();
        if (!actionValue.isNumber()) {
            throw new InvalidParseOperationException("[ INC]Action argument (" + String.valueOf(actionValue) + COULD_NOT_CONVERTED + fieldName);
        }
        String[] fieldNamePath = fieldName.split("[.]");
        String lastNodeName = fieldNamePath[fieldNamePath.length - 1];
        ObjectNode parentNode = (ObjectNode)JsonHandler.getParentNodeByPath((JsonNode)this.updatedDocument, (String)fieldName, (boolean)false);
        if (parentNode != null) {
            if (nodeValue.getClass().equals(Integer.class)) {
                parentNode.put(lastNodeName, ((JsonNode)element.getValue()).intValue() + nodeValue.intValue());
            } else if (nodeValue.getClass().equals(Long.class)) {
                parentNode.put(lastNodeName, ((JsonNode)element.getValue()).longValue() + nodeValue.longValue());
            } else if (nodeValue.getClass().equals(Float.class)) {
                parentNode.put(lastNodeName, ((JsonNode)element.getValue()).floatValue() + nodeValue.floatValue());
            } else if (nodeValue.getClass().equals(Double.class)) {
                parentNode.put(lastNodeName, ((JsonNode)element.getValue()).doubleValue() + nodeValue.doubleValue());
            } else if (nodeValue.getClass().equals(BigDecimal.class)) {
                parentNode.put(lastNodeName, ((JsonNode)element.getValue()).decimalValue().add(BigDecimal.valueOf(nodeValue.doubleValue())));
            } else if (nodeValue.getClass().equals(BigInteger.class)) {
                parentNode.put(lastNodeName, ((JsonNode)element.getValue()).bigIntegerValue().add(BigInteger.valueOf(nodeValue.intValue())));
            }
        }
        this.updatedFields.add(fieldName);
    }

    private void unset(JsonNode content) {
        Iterator iterator = content.elements();
        while (iterator.hasNext()) {
            JsonNode element = (JsonNode)iterator.next();
            String fieldName = element.asText();
            JsonNode node = JsonHandler.getParentNodeByPath((JsonNode)this.updatedDocument, (String)fieldName, (boolean)false);
            if (node == null) continue;
            String[] fieldNamePath = fieldName.split("[.]");
            String lastNodeName = fieldNamePath[fieldNamePath.length - 1];
            ((ObjectNode)node).remove(lastNodeName);
            this.updatedFields.add(fieldName);
        }
    }

    private void set(JsonNode content) throws InvalidParseOperationException {
        Iterator iterator = content.fields();
        while (iterator.hasNext()) {
            Map.Entry element = (Map.Entry)iterator.next();
            String fieldName = (String)element.getKey();
            if (this.parserTokens.isAnArray(fieldName)) {
                ArrayNode arrayNode = GlobalDatasParser.getArray((JsonNode)element.getValue());
                JsonHandler.setNodeInPath((ObjectNode)((ObjectNode)this.updatedDocument), (String)fieldName, (JsonNode)arrayNode, (boolean)true);
            } else {
                JsonHandler.setNodeInPath((ObjectNode)((ObjectNode)this.updatedDocument), (String)fieldName, (JsonNode)((JsonNode)element.getValue()), (boolean)true);
            }
            this.updatedFields.add(fieldName);
        }
    }

    private void setRegex(JsonNode content) throws InvalidParseOperationException {
        QueryPattern queryPattern = (QueryPattern)JsonHandler.getFromJsonNodeLowerCamelCase((JsonNode)content, QueryPattern.class);
        String fieldName = queryPattern.getTarget();
        ObjectNode parentObjectNode = (ObjectNode)JsonHandler.getParentNodeByPath((JsonNode)this.updatedDocument, (String)fieldName, (boolean)false);
        String lastFieldName = JsonHandler.getLastFieldName((String)fieldName);
        if (parentObjectNode == null || !parentObjectNode.has(lastFieldName)) {
            return;
        }
        JsonNode jsonNode = parentObjectNode.get(lastFieldName);
        Pattern pattern = Pattern.compile(queryPattern.getControlPattern());
        if (jsonNode.isTextual()) {
            String newString;
            String stringToSearch = jsonNode.asText();
            if (!stringToSearch.equals(newString = this.replaceAll(pattern, stringToSearch, queryPattern.getUpdatePattern()))) {
                parentObjectNode.put(lastFieldName, newString);
                this.updatedFields.add(fieldName);
            }
        } else if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (int i = 0; i < arrayNode.size(); ++i) {
                String newString;
                String stringToSearch;
                JsonNode item = arrayNode.get(i);
                if (!item.isTextual() || (stringToSearch = item.asText()).equals(newString = this.replaceAll(pattern, stringToSearch, queryPattern.getUpdatePattern()))) continue;
                arrayNode.set(i, (JsonNode)new TextNode(newString));
                this.updatedFields.add(fieldName);
            }
        }
    }

    private String replaceAll(Pattern pattern, String stringToSearch, String replacement) {
        return pattern.matcher(stringToSearch).replaceAll(replacement);
    }

    private void min(BuilderToken.UPDATEACTION req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        String fieldName = (String)element.getKey();
        Number nodeValue = this.getNumberValue(req.name(), fieldName);
        JsonNode actionValue = (JsonNode)element.getValue();
        if (!actionValue.isNumber()) {
            throw new InvalidParseOperationException("[ MIN]Action argument (" + String.valueOf(actionValue) + COULD_NOT_CONVERTED + fieldName);
        }
        String[] fieldNamePath = fieldName.split("[.]");
        String lastNodeName = fieldNamePath[fieldNamePath.length - 1];
        ObjectNode parentNode = (ObjectNode)JsonHandler.getParentNodeByPath((JsonNode)this.updatedDocument, (String)fieldName, (boolean)false);
        if (parentNode != null) {
            if (nodeValue.getClass().equals(Integer.class)) {
                parentNode.put(lastNodeName, Math.min(((JsonNode)element.getValue()).intValue(), nodeValue.intValue()));
            } else if (nodeValue.getClass().equals(Long.class)) {
                parentNode.put(lastNodeName, Math.min(((JsonNode)element.getValue()).longValue(), nodeValue.longValue()));
            } else if (nodeValue.getClass().equals(Float.class)) {
                parentNode.put(lastNodeName, Math.min(((JsonNode)element.getValue()).floatValue(), nodeValue.floatValue()));
            } else if (nodeValue.getClass().equals(Double.class)) {
                parentNode.put(lastNodeName, Math.min(((JsonNode)element.getValue()).doubleValue(), nodeValue.doubleValue()));
            } else if (nodeValue.getClass().equals(BigDecimal.class)) {
                parentNode.put(lastNodeName, ((JsonNode)element.getValue()).decimalValue().min(BigDecimal.valueOf(nodeValue.doubleValue())));
            } else if (nodeValue.getClass().equals(BigInteger.class)) {
                parentNode.put(lastNodeName, ((JsonNode)element.getValue()).bigIntegerValue().min(BigInteger.valueOf(nodeValue.intValue())));
            }
        }
        this.updatedFields.add(fieldName);
    }

    private void max(BuilderToken.UPDATEACTION req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        String fieldName = (String)element.getKey();
        Number nodeValue = this.getNumberValue(req.name(), fieldName);
        JsonNode actionValue = (JsonNode)element.getValue();
        if (!actionValue.isNumber()) {
            throw new InvalidParseOperationException("[ MAX]Action argument (" + String.valueOf(actionValue) + COULD_NOT_CONVERTED + fieldName);
        }
        String[] fieldNamePath = fieldName.split("[.]");
        String lastNodeName = fieldNamePath[fieldNamePath.length - 1];
        ObjectNode parentNode = (ObjectNode)JsonHandler.getParentNodeByPath((JsonNode)this.updatedDocument, (String)fieldName, (boolean)false);
        if (parentNode != null) {
            if (nodeValue.getClass().equals(Integer.class)) {
                parentNode.put(lastNodeName, Math.max(((JsonNode)element.getValue()).intValue(), nodeValue.intValue()));
            } else if (nodeValue.getClass().equals(Long.class)) {
                parentNode.put(lastNodeName, Math.max(((JsonNode)element.getValue()).longValue(), nodeValue.longValue()));
            } else if (nodeValue.getClass().equals(Float.class)) {
                parentNode.put(lastNodeName, Math.max(((JsonNode)element.getValue()).floatValue(), nodeValue.floatValue()));
            } else if (nodeValue.getClass().equals(Double.class)) {
                parentNode.put(lastNodeName, Math.max(((JsonNode)element.getValue()).doubleValue(), nodeValue.doubleValue()));
            } else if (nodeValue.getClass().equals(BigDecimal.class)) {
                parentNode.put(lastNodeName, ((JsonNode)element.getValue()).decimalValue().max(BigDecimal.valueOf(nodeValue.doubleValue())));
            } else if (nodeValue.getClass().equals(BigInteger.class)) {
                parentNode.put(lastNodeName, ((JsonNode)element.getValue()).bigIntegerValue().max(BigInteger.valueOf(nodeValue.intValue())));
            }
        }
        this.updatedFields.add(fieldName);
    }

    private void rename(BuilderToken.UPDATEACTION req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        String fieldName = (String)element.getKey();
        JsonNode value = JsonHandler.getNodeByPath((JsonNode)this.updatedDocument, (String)fieldName, (boolean)false);
        if (value == null) {
            throw new InvalidParseOperationException("[RENAME]Can't rename field " + fieldName + " because it doesn't exist");
        }
        JsonNode parent = JsonHandler.getParentNodeByPath((JsonNode)this.updatedDocument, (String)fieldName, (boolean)false);
        String[] fieldNamePath = fieldName.split("[.]");
        String lastNodeName = fieldNamePath[fieldNamePath.length - 1];
        if (parent != null) {
            ((ObjectNode)parent).remove(lastNodeName);
        }
        String newFieldName = ((JsonNode)element.getValue()).asText();
        JsonHandler.setNodeInPath((ObjectNode)((ObjectNode)this.updatedDocument), (String)newFieldName, (JsonNode)value, (boolean)true);
        this.updatedFields.add(fieldName);
        this.updatedFields.add(newFieldName);
    }

    private void push(BuilderToken.UPDATEACTION req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        String fieldName = (String)element.getKey();
        if (!(element.getValue() instanceof ArrayNode)) {
            throw new InvalidParseOperationException("[ PUSH]Action argument (" + String.valueOf(element.getValue()) + EXPECTED_VALUE + fieldName);
        }
        ArrayNode array = (ArrayNode)element.getValue();
        ArrayNode node = (ArrayNode)this.getArrayValue(req.name(), fieldName);
        Iterator iterator = array.elements();
        while (iterator.hasNext()) {
            node.add((JsonNode)iterator.next());
        }
        this.updatedFields.add(fieldName);
    }

    private void pull(BuilderToken.UPDATEACTION req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        String fieldName = (String)element.getKey();
        if (!(element.getValue() instanceof ArrayNode)) {
            throw new InvalidParseOperationException("[ PULL]Action argument (" + String.valueOf(element.getValue()) + EXPECTED_VALUE + fieldName);
        }
        ArrayNode array = (ArrayNode)element.getValue();
        ArrayNode node = (ArrayNode)this.getArrayValue(req.name(), fieldName);
        ArrayList<Integer> indexesToRemove = new ArrayList<Integer>();
        Iterator iterator = array.elements();
        while (iterator.hasNext()) {
            JsonNode pullValue = (JsonNode)iterator.next();
            Iterator originIt = node.elements();
            int index = 0;
            while (originIt.hasNext()) {
                if (((JsonNode)originIt.next()).asText().equals(pullValue.asText())) {
                    indexesToRemove.add(index);
                }
                ++index;
            }
        }
        Collections.sort(indexesToRemove);
        for (int i = indexesToRemove.size() - 1; i >= 0; --i) {
            node.remove(((Integer)indexesToRemove.get(i)).intValue());
        }
        if (!indexesToRemove.isEmpty()) {
            this.updatedFields.add(fieldName);
        }
    }

    private void add(BuilderToken.UPDATEACTION req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        String fieldName = (String)element.getKey();
        if (!(element.getValue() instanceof ArrayNode)) {
            throw new InvalidParseOperationException("[ ADD]Action argument (" + String.valueOf(element.getValue()) + EXPECTED_VALUE + fieldName);
        }
        ArrayNode array = (ArrayNode)element.getValue();
        ArrayNode node = (ArrayNode)this.getArrayValue(req.name(), fieldName);
        Iterator iterator = array.elements();
        while (iterator.hasNext()) {
            JsonNode newNode = (JsonNode)iterator.next();
            Iterator originIt = node.elements();
            boolean mustAdd = true;
            while (originIt.hasNext()) {
                if (!((JsonNode)originIt.next()).asText().equals(newNode.asText())) continue;
                mustAdd = false;
            }
            if (!mustAdd) continue;
            node.add(newNode);
            this.updatedFields.add(fieldName);
        }
    }

    private void pop(BuilderToken.UPDATEACTION req, JsonNode content) throws InvalidParseOperationException {
        Map.Entry element = JsonHandler.checkUnicity((String)req.exactToken(), (JsonNode)content);
        String fieldName = (String)element.getKey();
        ArrayNode node = (ArrayNode)this.getArrayValue(req.name(), fieldName);
        JsonNode actionValue = (JsonNode)element.getValue();
        if (!actionValue.isNumber()) {
            throw new InvalidParseOperationException("[" + req.name() + ACTION_ARGUMENT + String.valueOf(actionValue) + COULD_NOT_CONVERTED + fieldName);
        }
        int numberOfPop = Math.abs(actionValue.asInt());
        if (numberOfPop == 0) {
            return;
        }
        if (numberOfPop > node.size()) {
            throw new InvalidParseOperationException("Cannot pop " + numberOfPop + "items from the field '" + fieldName + "' because it has less items");
        }
        if (actionValue.asInt() < 0) {
            for (int i = 0; i < numberOfPop; ++i) {
                node.remove(0);
            }
        } else {
            for (int i = 0; i < numberOfPop; ++i) {
                node.remove(node.size() - 1);
            }
        }
        this.updatedFields.add(fieldName);
    }

    private Number getNumberValue(String actionName, String fieldName) throws InvalidParseOperationException {
        JsonNode node = JsonHandler.getNodeByPath((JsonNode)this.updatedDocument, (String)fieldName, (boolean)false);
        if (node == null || !node.isNumber()) {
            String message = "This field '" + fieldName + "' is not a number, cannot do '" + actionName + "' action: " + String.valueOf(node) + " or unknow fieldName";
            LOGGER.error(message);
            throw new InvalidParseOperationException(message);
        }
        return node.numberValue();
    }

    private JsonNode getArrayValue(String actionName, String fieldName) throws InvalidParseOperationException {
        JsonNode node = JsonHandler.getNodeByPath((JsonNode)this.updatedDocument, (String)fieldName, (boolean)false);
        if (node == null || node instanceof NullNode) {
            LOGGER.info("Action '" + actionName + "' in item previously null '" + fieldName + "' or unknow");
            ObjectNode updatedDocumentAsObject = (ObjectNode)this.updatedDocument;
            updatedDocumentAsObject.set(fieldName, (JsonNode)JsonHandler.createArrayNode());
            return this.updatedDocument.get(fieldName);
        }
        if (!node.isArray()) {
            String message = "This field '" + fieldName + "' is not an array, cannot do '" + actionName + "' action";
            LOGGER.error(message);
            throw new InvalidParseOperationException(message);
        }
        return node;
    }

    public Set<String> getUpdatedFields() {
        return this.updatedFields;
    }
}

