/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request.single;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.single.Insert;
import fr.gouv.vitam.common.database.builder.request.single.RequestSingle;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameInsertAdapter;
import fr.gouv.vitam.common.database.parser.request.single.RequestParserSingle;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;

public class InsertParserSingle
extends RequestParserSingle {
    VarNameInsertAdapter insertAdapter;

    public InsertParserSingle(VarNameAdapter adapter) {
        super(adapter);
        this.insertAdapter = new VarNameInsertAdapter(adapter);
    }

    @Override
    protected RequestSingle getNewRequest() {
        return new Insert();
    }

    @Override
    public void parse(JsonNode request) throws InvalidParseOperationException {
        this.parseJson(request);
        this.internalParseInsert();
    }

    private void internalParseInsert() throws InvalidParseOperationException {
        this.dataParse(this.rootNode.get(BuilderToken.GLOBAL.DATA.exactToken()));
    }

    protected void dataParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            throw new InvalidParseOperationException("Parse in error for Insert: empty data");
        }
        GlobalDatas.sanityValueCheck((String)rootNode.toString());
        JsonNode newRootNode = this.insertAdapter.getFixedVarNameJsonNode(rootNode);
        try {
            ((Insert)this.request).setData(newRootNode);
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Insert: " + String.valueOf(rootNode), (Throwable)e);
        }
    }

    @Override
    public String toString() {
        return ((RequestSingle)this.request).toString();
    }

    @Override
    public Insert getRequest() {
        return (Insert)this.request;
    }
}

