/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request.multiple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.multiple.RequestMultiple;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.database.parser.query.action.UpdateActionParserHelper;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameUpdateAdapter;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import java.util.Iterator;
import java.util.Map;

public class UpdateParserMultiple
extends RequestParserMultiple {
    VarNameUpdateAdapter updateAdapter;

    public UpdateParserMultiple() {
        this.updateAdapter = new VarNameUpdateAdapter(this.adapter);
    }

    public UpdateParserMultiple(VarNameAdapter adapter) {
        super(adapter);
        this.updateAdapter = new VarNameUpdateAdapter(adapter);
    }

    @Override
    protected RequestMultiple getNewRequest() {
        return new UpdateMultiQuery();
    }

    @Override
    public void parse(JsonNode request) throws InvalidParseOperationException {
        this.parseJson(request);
        this.internalParseUpdate();
    }

    private void internalParseUpdate() throws InvalidParseOperationException {
        this.actionParse(this.rootNode.get(BuilderToken.GLOBAL.ACTION.exactToken()));
        this.thresholdParse(this.rootNode.get(BuilderToken.GLOBAL.THRESOLD.exactToken()));
    }

    protected void actionParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            return;
        }
        GlobalDatas.sanityParametersCheck((String)rootNode.toString(), (int)10000);
        try {
            for (JsonNode node : (ArrayNode)rootNode) {
                Iterator iterator = node.fields();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    Action updateAction = this.analyseOneAction((String)entry.getKey(), (JsonNode)entry.getValue());
                    ((UpdateMultiQuery)this.request).addActions(new Action[]{updateAction});
                }
                iterator = null;
            }
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Action: " + String.valueOf(rootNode), (Throwable)e);
        }
    }

    protected void thresholdParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            return;
        }
        try {
            ((UpdateMultiQuery)this.request).setThreshold(Long.valueOf(rootNode.asLong()));
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Action: " + String.valueOf(rootNode), (Throwable)e);
        }
    }

    protected void setregexParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            return;
        }
        try {
            ((UpdateMultiQuery)this.request).setThreshold(Long.valueOf(rootNode.asLong()));
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Action: " + String.valueOf(rootNode), (Throwable)e);
        }
    }

    protected static final BuilderToken.UPDATEACTION getUpdateActionId(String actionroot) throws InvalidParseOperationException {
        if (!actionroot.startsWith("$")) {
            throw new InvalidParseOperationException("Incorrect action $command: " + actionroot);
        }
        String command = actionroot.substring(1).toUpperCase();
        BuilderToken.UPDATEACTION action = null;
        try {
            action = BuilderToken.UPDATEACTION.valueOf((String)command);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParseOperationException("Invalid action command: " + command, (Throwable)e);
        }
        return action;
    }

    protected Action analyseOneAction(String refCommand, JsonNode command) throws InvalidParseOperationException {
        GlobalDatas.sanityValueCheck((String)command.toString());
        BuilderToken.UPDATEACTION action = UpdateParserMultiple.getUpdateActionId(refCommand);
        switch (action) {
            case ADD: {
                return UpdateActionParserHelper.add(command, this.updateAdapter);
            }
            case INC: {
                return UpdateActionParserHelper.inc(command, this.updateAdapter);
            }
            case MIN: {
                return UpdateActionParserHelper.min(command, this.updateAdapter);
            }
            case MAX: {
                return UpdateActionParserHelper.max(command, this.updateAdapter);
            }
            case POP: {
                return UpdateActionParserHelper.pop(command, this.updateAdapter);
            }
            case PULL: {
                return UpdateActionParserHelper.pull(command, this.updateAdapter);
            }
            case PUSH: {
                return UpdateActionParserHelper.push(command, this.updateAdapter);
            }
            case RENAME: {
                return UpdateActionParserHelper.rename(command, this.updateAdapter);
            }
            case SET: {
                return UpdateActionParserHelper.set(command, this.updateAdapter);
            }
            case UNSET: {
                return UpdateActionParserHelper.unset(command, this.updateAdapter);
            }
            case SETREGEX: {
                return UpdateActionParserHelper.setregex(command, this.updateAdapter);
            }
        }
        throw new InvalidParseOperationException("Invalid command: " + refCommand);
    }

    @Override
    public String toString() {
        return ((RequestMultiple)this.request).toString() + "\n\tLastLevel: " + this.lastDepth;
    }

    @Override
    public UpdateMultiQuery getRequest() {
        return (UpdateMultiQuery)this.request;
    }
}

