/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request.adapter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.Iterator;
import java.util.Map;

public class VarNameInsertAdapter
extends VarNameAdapter {
    VarNameAdapter adapter;

    public VarNameInsertAdapter(VarNameAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public boolean metadataAdapter() {
        return this.adapter.metadataAdapter();
    }

    @Override
    public String getVariableName(String name) throws InvalidParseOperationException {
        if (!this.adapter.metadataAdapter() && ParserTokens.PROJECTIONARGS.notAllowedOnSet(name)) {
            throw new InvalidParseOperationException("Name not allowed in Insert: " + name);
        }
        if (!this.metadataAdapter() && ParserTokens.PROJECTIONARGS.notAllowedOnSetExternal(name)) {
            throw new InvalidParseOperationException("Illegal variable name found: " + name);
        }
        return this.adapter.getVariableName(name);
    }

    public JsonNode getFixedVarNameJsonNode(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode instanceof ArrayNode) {
            ArrayNode object = JsonHandler.createArrayNode();
            Iterator fieldIterator = rootNode.elements();
            while (fieldIterator.hasNext()) {
                JsonNode node = this.getFixedVarNameJsonNode((JsonNode)fieldIterator.next());
                object.add(node);
            }
            return object;
        }
        if (rootNode.isObject()) {
            ObjectNode object = JsonHandler.createObjectNode();
            Iterator fieldIterator = rootNode.fields();
            while (fieldIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)fieldIterator.next();
                String name = (String)entry.getKey();
                String newname = this.getVariableName(name);
                if (newname != null) {
                    name = newname;
                }
                if (((JsonNode)entry.getValue()).isObject() || ((JsonNode)entry.getValue()).isArray()) {
                    object.set(name, this.getFixedVarNameJsonNode((JsonNode)entry.getValue()));
                    continue;
                }
                object.set(name, (JsonNode)entry.getValue());
            }
            return object;
        }
        return rootNode;
    }
}

