/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request.adapter;

import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;

public class SingleVarNameAdapter
extends VarNameAdapter {
    @Override
    public boolean metadataAdapter() {
        return true;
    }

    @Override
    public String getVariableName(String name) throws InvalidParseOperationException {
        if (name.charAt(0) == '#') {
            int pos = name.indexOf(46);
            String realname = pos > 1 ? name.substring(1, pos) : name.substring(1);
            try {
                ParserTokens.PROJECTIONARGS proj = ParserTokens.PROJECTIONARGS.parse(realname);
                switch (proj) {
                    case TENANT: {
                        return "_tenant";
                    }
                    case ID: {
                        return "_id";
                    }
                    case VERSION: {
                        return "_v";
                    }
                    case SEDAVERSION: {
                        return "_sedaVersion";
                    }
                    case IMPLEMENTATIONVERSION: {
                        return "_implementationVersion";
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new InvalidParseOperationException((Throwable)e);
            }
        }
        return null;
    }
}

