/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.AbstractRequest;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.parser.facet.FacetParserHelper;
import fr.gouv.vitam.common.database.parser.query.QueryParserHelper;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.Iterator;

public abstract class AbstractParser<E extends AbstractRequest> {
    protected VarNameAdapter adapter;
    protected String sourceRequest;
    protected E request;
    protected boolean hasFullTextQuery = false;
    protected boolean hasFullTextCurrentQuery = false;
    protected JsonNode rootNode;

    public String getSource() {
        return this.sourceRequest;
    }

    public JsonNode getRootNode() {
        return this.rootNode;
    }

    public E getRequest() {
        return this.request;
    }

    protected abstract E getNewRequest();

    public abstract void parse(JsonNode var1) throws InvalidParseOperationException;

    protected void parseJson(JsonNode jsonRequest) throws InvalidParseOperationException {
        this.rootNode = jsonRequest;
        this.sourceRequest = JsonHandler.unprettyPrint((Object)jsonRequest);
    }

    public final boolean hasFullTextQuery() {
        return this.hasFullTextQuery;
    }

    public VarNameAdapter getAdapter() {
        return this.adapter;
    }

    protected Query analyzeOneCommand(String refCommand, JsonNode command) throws InvalidParseOperationException, InvalidCreateOperationException {
        Query query = QueryParserHelper.query(refCommand, command, this.adapter);
        if (query != null) {
            this.hasFullTextCurrentQuery |= query.isFullText();
        }
        return query;
    }

    public abstract int getLastDepth();

    public abstract BuilderToken.FILTERARGS model();

    public abstract boolean hintNoTimeout();

    public abstract boolean hintCache();

    protected void parseOrderByFilter(JsonNode filterNode) throws InvalidParseOperationException {
        if (filterNode.has(BuilderToken.SELECTFILTER.ORDERBY.exactToken())) {
            ObjectNode node = (ObjectNode)filterNode.get(BuilderToken.SELECTFILTER.ORDERBY.exactToken());
            ObjectNode finalNode = node.deepCopy();
            Iterator names = node.fieldNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                String dbName = this.adapter.getVariableName(name);
                if (null == dbName) continue;
                JsonNode value = finalNode.remove(name);
                finalNode.set(dbName, value);
            }
            node.removeAll();
            node.setAll(finalNode);
        }
    }

    protected Facet analyzeOneFacet(JsonNode facet, BuilderToken.FACET facetCommand) throws InvalidCreateOperationException, InvalidParseOperationException {
        switch (facetCommand) {
            case TERMS: {
                return FacetParserHelper.terms(facet, this.adapter);
            }
            case DATE_RANGE: {
                return FacetParserHelper.dateRange(facet, this.adapter);
            }
            case FILTERS: {
                return FacetParserHelper.filters(facet, this.adapter);
            }
            case SUM: {
                return FacetParserHelper.sum(facet, this.adapter);
            }
            case CARDINALITY: {
                return FacetParserHelper.cardinality(facet, this.adapter);
            }
            case COUNT: {
                return FacetParserHelper.count(facet, this.adapter);
            }
        }
        throw new InvalidParseOperationException("Invalid parse: command not a facet " + facetCommand.exactToken());
    }
}

