/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.offset;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import org.bson.Document;
import org.bson.conversions.Bson;

public class OffsetRepository {
    public static final String COLLECTION_NAME = "Offset";
    private final MongoCollection<Document> offerCollection;

    @VisibleForTesting
    public OffsetRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.offerCollection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
    }

    public OffsetRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, COLLECTION_NAME);
    }

    public void createOrUpdateOffset(int tenant, String strategy, String collection, long offset) {
        Bson offsetFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_tenant", (Object)tenant), Filters.eq((String)"strategy", (Object)strategy), Filters.eq((String)"collection", (Object)collection)});
        Bson offsetUpdate = Updates.set((String)"offset", (Object)offset);
        UpdateOptions updateOptions = new UpdateOptions();
        updateOptions.upsert(true);
        this.offerCollection.updateOne(offsetFilter, offsetUpdate, updateOptions);
    }

    public long findOffsetBy(int tenant, String strategy, String collection) {
        Bson offsetFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_tenant", (Object)tenant), Filters.eq((String)"strategy", (Object)strategy), Filters.eq((String)"collection", (Object)collection)});
        Document first = (Document)this.offerCollection.find(offsetFilter).first();
        if (first == null) {
            return 0L;
        }
        return (Long)first.get((Object)"offset", Long.class);
    }
}

