/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.collections;

import fr.gouv.vitam.common.database.collections.VitamDescriptionType;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class VitamDescriptionResolver {
    private final Map<String, VitamDescriptionType> descriptionTypeByStaticName;
    private final Map<Pattern, VitamDescriptionType> descriptionTypeByNamePattern;
    private List<VitamDescriptionType> vitamDescriptionTypes;

    public VitamDescriptionResolver(List<VitamDescriptionType> vitamDescriptionTypes) {
        this.vitamDescriptionTypes = vitamDescriptionTypes;
        this.descriptionTypeByStaticName = vitamDescriptionTypes.stream().filter(vitamDescriptionType -> vitamDescriptionType.getPath() != null).collect(Collectors.toMap(VitamDescriptionType::getPath, v -> v));
        this.descriptionTypeByNamePattern = vitamDescriptionTypes.stream().filter(vitamDescriptionType -> vitamDescriptionType.getPath() == null).collect(Collectors.toMap(VitamDescriptionResolver::createPatternMatcher, v -> v));
    }

    private static Pattern createPatternMatcher(VitamDescriptionType vitamDescriptionType) {
        return Pattern.compile("^" + vitamDescriptionType.getPathRegex() + "$");
    }

    public VitamDescriptionType resolve(String name) {
        if (this.descriptionTypeByStaticName.containsKey(name)) {
            return this.descriptionTypeByStaticName.get(name);
        }
        for (Map.Entry<Pattern, VitamDescriptionType> entry : this.descriptionTypeByNamePattern.entrySet()) {
            if (!entry.getKey().matcher(name).matches()) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, VitamDescriptionType> getDescriptionTypeByStaticName() {
        return this.descriptionTypeByStaticName;
    }
}

