/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.api.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.api.VitamRepository;
import fr.gouv.vitam.common.database.api.VitamRepositoryStatus;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class VitamMongoRepository
implements VitamRepository {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamMongoRepository.class);
    private static final String NAME = "Name";
    private static final String ALL_PARAMS_REQUIRED = "All params are required";
    private final MongoCollection<Document> collection;

    public VitamMongoRepository(MongoCollection<Document> collection) {
        this.collection = collection;
    }

    @Override
    public void save(Document document) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{this.collection, document});
        try {
            this.collection.insertOne((Object)document);
        }
        catch (MongoException e) {
            LOGGER.error("Insert Document Exception: ", (Throwable)e);
            throw new DatabaseException((Throwable)e);
        }
    }

    @Override
    public VitamRepositoryStatus saveOrUpdate(Document document) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{this.collection, document});
        try {
            ReplaceOneModel replaceOneModel = new ReplaceOneModel(Filters.eq((String)"_id", (Object)document.get((Object)"_id")), (Object)document, new ReplaceOptions().upsert(true));
            UpdateResult result = this.collection.replaceOne(replaceOneModel.getFilter(), (Object)((Document)replaceOneModel.getReplacement()), replaceOneModel.getReplaceOptions());
            if (result.getModifiedCount() > 0L) {
                return VitamRepositoryStatus.UPDATED;
            }
            return VitamRepositoryStatus.CREATED;
        }
        catch (MongoException e) {
            LOGGER.error("Insert or Update Document Exception: ", (Throwable)e);
            throw new DatabaseException((Throwable)e);
        }
    }

    @Override
    public void save(List<Document> documents) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{this.collection, documents});
        List insertOneModels = documents.stream().map(InsertOneModel::new).collect(Collectors.toList());
        try {
            this.collection.bulkWrite(insertOneModels);
        }
        catch (MongoException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    @Override
    public void saveOrUpdate(List<Document> documents) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{this.collection, documents});
        List replaceOneModels = documents.stream().map(document -> new ReplaceOneModel(Filters.eq((String)"_id", (Object)document.get((Object)"_id")), document, new ReplaceOptions().upsert(true))).collect(Collectors.toList());
        try {
            this.collection.bulkWrite(replaceOneModels);
        }
        catch (MongoException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    @Override
    public void update(List<WriteModel<Document>> queries) throws DatabaseException {
        try {
            this.collection.bulkWrite(queries, new BulkWriteOptions().ordered(false));
        }
        catch (MongoException e) {
            LOGGER.error("Bulk update documents exception: ", (Throwable)e);
            throw new DatabaseException((Throwable)e);
        }
    }

    @Override
    public void remove(String id, Integer tenant) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (String[])new String[]{id});
        DeleteResult delete = this.collection.deleteOne((Bson)new BasicDBObject("_id", (Object)id));
        long count = delete.getDeletedCount();
        if (count == 0L) {
            LOGGER.error(String.format("Document %s is not deleted", id));
            throw new DatabaseException(String.format("Document %s is not deleted", id));
        }
    }

    @Override
    public long remove(Bson query) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{query});
        try {
            return this.collection.deleteMany(query).getDeletedCount();
        }
        catch (MongoException e) {
            LOGGER.error("Remove documents exception: ", (Throwable)e);
            throw new DatabaseException((Throwable)e);
        }
    }

    @Override
    public void removeByNameAndTenant(String name, Integer tenant) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{name, tenant});
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_tenant", (Object)tenant), Filters.eq((String)NAME, (Object)name)});
        DeleteResult delete = this.collection.deleteOne(query);
        long count = delete.getDeletedCount();
        if (count == 0L) {
            LOGGER.error(String.format("Error while removeByNameAndTenant> Name : %s and tenant: %s", name, tenant));
            throw new DatabaseException(String.format("Error while removeByNameAndTenant> Name : %s and tenant: %s", name, tenant));
        }
    }

    @Override
    public long purge(Integer tenant) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{tenant});
        try {
            DeleteResult response = this.collection.deleteMany((Bson)new BasicDBObject("_tenant", (Object)tenant));
            return response.getDeletedCount();
        }
        catch (MongoException e) {
            LOGGER.error(String.format("Error while delete documents for tenant %s", tenant), (Throwable)e);
            throw new DatabaseException(String.format("Error while delete documents for tenant %s", tenant), (Throwable)e);
        }
    }

    @Override
    public long purge() throws DatabaseException {
        try {
            DeleteResult response = this.collection.deleteMany((Bson)new BasicDBObject());
            return response.getDeletedCount();
        }
        catch (MongoException e) {
            LOGGER.error("Error while delete documents", (Throwable)e);
            throw new DatabaseException("Error while delete documents", (Throwable)e);
        }
    }

    @Override
    public Optional<Document> getByID(String id, Integer tenant) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (String[])new String[]{id});
        try {
            Document result = (Document)this.collection.find((Bson)new BasicDBObject("_id", (Object)id)).first();
            return Optional.ofNullable(result);
        }
        catch (MongoException e) {
            LOGGER.error(String.format("DatabaseException while getting document by id : %s", id), (Throwable)e);
            throw new DatabaseException(String.format("DatabaseException while getting document by id : %s", id), (Throwable)e);
        }
    }

    @Override
    public Optional<Document> findByIdentifierAndTenant(String identifier, Integer tenant) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{identifier, tenant});
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"Identifier", (Object)identifier), Filters.eq((String)"_tenant", (Object)tenant)});
        try {
            Document result = (Document)this.collection.find(query).first();
            return Optional.ofNullable(result);
        }
        catch (MongoException e) {
            LOGGER.error(String.format("Error while findByIdentifierAndTenant > identifier : %s and tenant: %s", identifier, tenant), (Throwable)e);
            throw new DatabaseException(String.format("Error while findByIdentifierAndTenant > identifier : %s and tenant: %s", identifier, tenant), (Throwable)e);
        }
    }

    @Override
    public Optional<Document> findByIdentifier(String identifier) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (String[])new String[]{identifier});
        try {
            Document result = (Document)this.collection.find(Filters.eq((String)"Identifier", (Object)identifier)).first();
            return Optional.ofNullable(result);
        }
        catch (MongoException e) {
            LOGGER.error(String.format("Error while findByIdentifierAndTenant > identifier : %s", identifier), (Throwable)e);
            throw new DatabaseException(String.format("Error while findByIdentifierAndTenant > identifier : %s", identifier), (Throwable)e);
        }
    }

    @Override
    public FindIterable<Document> findByFieldsDocuments(Map<String, String> fields, int mongoBatchSize, Integer tenant) {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{tenant});
        if (fields == null || fields.isEmpty()) {
            return this.findDocuments(mongoBatchSize, tenant);
        }
        BasicDBObject filter = new BasicDBObject();
        fields.forEach((arg_0, arg_1) -> ((BasicDBObject)filter).append(arg_0, arg_1));
        filter.put((Object)"_tenant", (Object)tenant);
        return this.collection.find((Bson)filter).batchSize(mongoBatchSize);
    }

    @Override
    public FindIterable<Document> findDocuments(Collection<String> ids, Bson projection) {
        ParametersChecker.checkParameter((String)"Id list is required ", (Object[])new Object[]{ids});
        if (null == projection) {
            return this.collection.find(Filters.in((String)"_id", ids));
        }
        return this.collection.find(Filters.in((String)"_id", ids)).projection(projection);
    }

    @Override
    public FindIterable<Document> findDocuments(int mongoBatchSize, Integer tenant) {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{tenant});
        return this.collection.find((Bson)new BasicDBObject("_tenant", (Object)tenant)).batchSize(mongoBatchSize);
    }

    @Override
    public FindIterable<Document> findDocuments(int mongoBatchSize) {
        return this.collection.find().batchSize(mongoBatchSize);
    }

    @Override
    public FindIterable<Document> findDocuments(Bson query, int mongoBatchSize) {
        return this.collection.find(query).batchSize(mongoBatchSize);
    }

    @Override
    public void delete(List<String> ids, int tenant) {
        this.collection.deleteMany(Filters.and((Bson[])new Bson[]{Filters.in((String)"_id", ids), Filters.eq((String)"_tenant", (Object)tenant)}));
    }

    @Override
    public long count() {
        return this.collection.countDocuments();
    }

    @Override
    public long count(Bson filter) {
        return this.collection.countDocuments(filter);
    }
}

