/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.api.impl;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.OpType;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.ShardFailure;
import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.WriteResponseBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.DeleteOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.SourceConfigParam;
import co.elastic.clients.util.ObjectBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.api.VitamRepositoryStatus;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAliasResolver;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchUtil;
import fr.gouv.vitam.common.database.server.elasticsearch.model.ElasticsearchCollections;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.bson.Document;

public class VitamElasticsearchRepository {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamElasticsearchRepository.class);
    public static final String IDENTIFIER = "Identifier";
    public static final String ID = "_id";
    private static final String ALL_PARAMS_REQUIRED = "All params are required";
    private static final String BULK_REQ_FAIL_WITH_ERROR = "Bulk Request failure with error: ";
    private static final String EV_DET_DATA = "evDetData";
    private static final String RIGHT_STATE_ID = "rightsStatementIdentifier";
    private static final String AG_ID_EXT = "agIdExt";
    private static final String EVENTS = "events";
    private final ElasticsearchClient client;
    private final ElasticsearchIndexAliasResolver elasticsearchIndexAliasResolver;

    public VitamElasticsearchRepository(ElasticsearchClient client, ElasticsearchIndexAliasResolver elasticsearchIndexAliasResolver) {
        this.client = client;
        this.elasticsearchIndexAliasResolver = elasticsearchIndexAliasResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VitamRepositoryStatus save(Document document) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{document});
        Document internalDocument = new Document((Map)document);
        Integer tenant = internalDocument.getInteger((Object)"_tenant");
        String id = (String)internalDocument.remove((Object)ID);
        Object score = internalDocument.remove((Object)"_score");
        try {
            IndexResponse indexResponse;
            String indexName = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
            IndexRequest request = IndexRequest.of(builder -> builder.index(indexName).id(id).document((Object)internalDocument).refresh(Refresh.True).timeout(ElasticsearchUtil.timeOfMilliseconds(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds())).opType(OpType.Index));
            try {
                indexResponse = this.client.index(request);
            }
            catch (ElasticsearchException | IOException e) {
                throw ElasticsearchUtil.toDatabaseException((Exception)e);
            }
            if (indexResponse.result() == Result.Created) {
                VitamRepositoryStatus vitamRepositoryStatus = VitamRepositoryStatus.CREATED;
                return vitamRepositoryStatus;
            }
            if (indexResponse.result() == Result.Updated) {
                VitamRepositoryStatus vitamRepositoryStatus = VitamRepositoryStatus.UPDATED;
                return vitamRepositoryStatus;
            }
            VitamRepositoryStatus vitamRepositoryStatus = this.handleFailures((WriteResponseBase)indexResponse);
            return vitamRepositoryStatus;
        }
        finally {
            internalDocument.put(ID, (Object)id);
            if (Objects.nonNull(score)) {
                internalDocument.put("_score", score);
            }
        }
    }

    private VitamRepositoryStatus handleFailures(WriteResponseBase response) throws DatabaseException {
        String error = null;
        ShardStatistics shardInfo = response.shards();
        if (!Objects.equals(shardInfo.total(), shardInfo.successful())) {
            error = String.format("Exception occurred : total shards %s, successful shards %s", shardInfo.total(), shardInfo.successful());
        }
        if (shardInfo.failed().intValue() > 0) {
            StringBuilder failures = new StringBuilder();
            for (ShardFailure failure : shardInfo.failures()) {
                String reason = failure.reason().reason();
                failures.append(reason).append(" ; ");
            }
            error = String.format("Exception occurred caused by : %s", failures);
        }
        if (null == error) {
            error = String.format("Insert Documents Exception caused by : %s", response.result().toString());
        }
        LOGGER.error(error);
        throw new DatabaseException(error);
    }

    public void save(List<Document> documents) throws DatabaseException {
        BulkResponse bulkResponse;
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{documents});
        if (documents.isEmpty()) {
            return;
        }
        BulkRequest.Builder bulkRequestBuilder = new BulkRequest.Builder();
        documents.forEach(document -> {
            Document internalDocument = new Document((Map)document);
            Integer tenant = internalDocument.getInteger((Object)"_tenant");
            String id = (String)internalDocument.remove((Object)ID);
            internalDocument.remove((Object)"_score");
            String aliasName = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
            bulkRequestBuilder.operations(o -> o.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(aliasName)).id(id)).document((Object)internalDocument)));
        });
        bulkRequestBuilder.refresh(Refresh.True);
        try {
            bulkResponse = this.client.bulk(bulkRequestBuilder.build());
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException((Exception)e);
        }
        if (bulkResponse.errors()) {
            LOGGER.error(BULK_REQ_FAIL_WITH_ERROR + ElasticsearchUtil.buildFailureMessage(bulkResponse));
            throw new DatabaseException("Bulk Request failure");
        }
    }

    public void save(ElasticsearchCollections elasticsearchCollections, List<Document> documents) throws DatabaseException {
        BulkResponse bulkResponse;
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{documents});
        if (documents.isEmpty()) {
            return;
        }
        BulkRequest.Builder bulkRequestBuilder = new BulkRequest.Builder();
        documents.forEach(document -> {
            Document internalDocument = new Document((Map)document);
            Integer tenant = internalDocument.getInteger((Object)"_tenant");
            String id = (String)internalDocument.remove((Object)ID);
            internalDocument.remove((Object)"_score");
            String aliasName = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
            if (ElasticsearchCollections.OPERATION == elasticsearchCollections) {
                this.transformDataForElastic(internalDocument);
            }
            bulkRequestBuilder.operations(o -> o.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(aliasName)).id(id)).document((Object)internalDocument)));
        });
        bulkRequestBuilder.refresh(Refresh.True);
        try {
            bulkResponse = this.client.bulk(bulkRequestBuilder.build());
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException((Exception)e);
        }
        if (bulkResponse.errors()) {
            LOGGER.error(BULK_REQ_FAIL_WITH_ERROR + ElasticsearchUtil.buildFailureMessage(bulkResponse));
            throw new DatabaseException("Bulk Request failure");
        }
    }

    private void transformDataForElastic(Document vitamDocument) {
        List eventDocuments;
        if (vitamDocument.get((Object)EV_DET_DATA) != null) {
            String evDetDataString = (String)vitamDocument.get((Object)EV_DET_DATA);
            LOGGER.debug(evDetDataString);
            try {
                JsonNode evDetData = JsonHandler.getFromString((String)evDetDataString);
                vitamDocument.remove((Object)EV_DET_DATA);
                vitamDocument.put(EV_DET_DATA, (Object)evDetData);
            }
            catch (InvalidParseOperationException e) {
                LOGGER.warn("EvDetData is not a json compatible field", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (vitamDocument.get((Object)AG_ID_EXT) != null) {
            String agidExt = (String)vitamDocument.get((Object)AG_ID_EXT);
            LOGGER.debug(agidExt);
            try {
                JsonNode agidExtNode = JsonHandler.getFromString((String)agidExt);
                vitamDocument.remove((Object)AG_ID_EXT);
                vitamDocument.put(AG_ID_EXT, (Object)agidExtNode);
            }
            catch (InvalidParseOperationException e) {
                LOGGER.warn("agidExtNode is not a json compatible field", (Throwable)e);
            }
        }
        if (vitamDocument.get((Object)RIGHT_STATE_ID) != null) {
            String rightsStatementIdentifier = (String)vitamDocument.get((Object)RIGHT_STATE_ID);
            LOGGER.debug(rightsStatementIdentifier);
            try {
                JsonNode rightsStatementIdentifierNode = JsonHandler.getFromString((String)rightsStatementIdentifier);
                vitamDocument.remove((Object)RIGHT_STATE_ID);
                vitamDocument.put(RIGHT_STATE_ID, (Object)rightsStatementIdentifierNode);
            }
            catch (InvalidParseOperationException e) {
                LOGGER.warn("rightsStatementIdentifier is not a json compatible field", (Throwable)e);
            }
        }
        if ((eventDocuments = (List)vitamDocument.get((Object)EVENTS)) != null) {
            for (Document eventDocument : eventDocuments) {
                Document eventEvDetDataDocument;
                if (eventDocument.getString((Object)EV_DET_DATA) != null) {
                    String eventEvDetDataString = eventDocument.getString((Object)EV_DET_DATA);
                    eventEvDetDataDocument = Document.parse((String)eventEvDetDataString);
                    eventDocument.remove((Object)EV_DET_DATA);
                    eventDocument.put(EV_DET_DATA, (Object)eventEvDetDataDocument);
                }
                if (eventDocument.getString((Object)RIGHT_STATE_ID) != null) {
                    String eventrightsStatementIdentifier = eventDocument.getString((Object)RIGHT_STATE_ID);
                    eventEvDetDataDocument = Document.parse((String)eventrightsStatementIdentifier);
                    eventDocument.remove((Object)RIGHT_STATE_ID);
                    eventDocument.put(RIGHT_STATE_ID, (Object)eventEvDetDataDocument);
                }
                if (eventDocument.getString((Object)AG_ID_EXT) == null) continue;
                String eventagIdExt = eventDocument.getString((Object)AG_ID_EXT);
                eventEvDetDataDocument = Document.parse((String)eventagIdExt);
                eventDocument.remove((Object)AG_ID_EXT);
                eventDocument.put(AG_ID_EXT, (Object)eventEvDetDataDocument);
            }
        }
        vitamDocument.remove((Object)EVENTS);
        vitamDocument.put(EVENTS, (Object)eventDocuments);
    }

    public void remove(String id, Integer tenant) throws DatabaseException {
        DeleteResponse deleteResponse;
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (String[])new String[]{id});
        String index = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
        DeleteRequest request = new DeleteRequest.Builder().index(index).id(id).timeout(ElasticsearchUtil.timeOfMilliseconds(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds())).refresh(Refresh.True).build();
        try {
            deleteResponse = this.client.delete(request);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (ElasticsearchException e) {
            if (e.status() == Response.Status.NOT_FOUND.getStatusCode()) {
                return;
            }
            throw ElasticsearchUtil.toDatabaseException((Exception)((Object)e));
        }
        Result result = deleteResponse.result();
        switch (result) {
            case Deleted: 
            case NotFound: {
                break;
            }
            default: {
                this.handleFailures((WriteResponseBase)deleteResponse);
            }
        }
    }

    public long purge(Integer tenant) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{tenant});
        String index = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
        Query qb = ElasticsearchUtil.termQuery("_tenant", tenant);
        return VitamElasticsearchRepository.handlePurge(this.client, index, qb);
    }

    private static long handlePurge(ElasticsearchClient client, String index, Query qb) throws DatabaseException {
        try {
            DeleteByQueryRequest request = new DeleteByQueryRequest.Builder().index(index, new String[0]).conflicts(Conflicts.Proceed).query(qb).scrollSize(Long.valueOf(VitamConfiguration.getMaxElasticsearchBulk())).scroll(ElasticsearchUtil.timeOfMilliseconds(VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds())).timeout(ElasticsearchUtil.timeOfMilliseconds(VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds())).refresh(Boolean.valueOf(true)).build();
            DeleteByQueryResponse response = client.deleteByQuery(request);
            LOGGER.debug("Purge details: {}", (Object)response);
            List searchFailures = response.failures();
            if (CollectionUtils.isNotEmpty((Collection)searchFailures)) {
                throw new DatabaseException("ES purge errors : in search phase");
            }
            return Objects.requireNonNull(response.deleted());
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException("Purge Exception", (Exception)e);
        }
    }

    public long purge() throws DatabaseException {
        String index = this.elasticsearchIndexAliasResolver.resolveIndexName(null).getName();
        Query qb = ElasticsearchUtil.matchAll();
        return VitamElasticsearchRepository.handlePurge(this.client, index, qb);
    }

    public Optional<Document> getByID(String id, Integer tenant) throws DatabaseException {
        GetResponse response;
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (String[])new String[]{id});
        String index = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
        GetRequest request = new GetRequest.Builder().index(index).id(id).source(SourceConfigParam.of(i -> i.fetch(Boolean.valueOf(true)))).build();
        try {
            response = this.client.get(request, Document.class);
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException((Exception)e);
        }
        if (response.found()) {
            return Optional.of(Objects.requireNonNull((Document)response.source()));
        }
        return Optional.empty();
    }

    public Optional<Document> getDocumentByIdCrossIndices(String id) throws DatabaseException {
        SearchResponse searchResponse;
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (String[])new String[]{id});
        SearchRequest searchRequest = new SearchRequest.Builder().query(ElasticsearchUtil.termQuery(ID, id)).from(Integer.valueOf(0)).size(Integer.valueOf(1)).build();
        try {
            searchResponse = this.client.search(searchRequest, Document.class);
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException((Exception)e);
        }
        Iterator iterator = searchResponse.hits().hits().iterator();
        if (iterator.hasNext()) {
            Hit hit = (Hit)iterator.next();
            return Optional.of(Objects.requireNonNull((Document)hit.source()));
        }
        return Optional.empty();
    }

    public Optional<Document> findByIdentifierAndTenant(String identifier, Integer tenant) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (Object[])new Object[]{tenant});
        String aliasName = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
        Query qb = ElasticsearchUtil.boolMust(ElasticsearchUtil.termQuery(IDENTIFIER, identifier), ElasticsearchUtil.termQuery("_tenant", tenant));
        return this.handleSearch(aliasName, qb);
    }

    private Optional<Document> handleSearch(String index, Query qb) throws DatabaseException {
        SearchResponse<Document> search = this.search(index, qb);
        Iterator iterator = search.hits().hits().iterator();
        if (iterator.hasNext()) {
            Hit hit = (Hit)iterator.next();
            return Optional.of(Objects.requireNonNull((Document)hit.source()));
        }
        return Optional.empty();
    }

    public SearchResponse<Document> search(String index, Query qb) throws DatabaseException {
        SearchRequest searchRequest = new SearchRequest.Builder().index(index, new String[0]).scroll(ElasticsearchUtil.timeOfMilliseconds(60000)).searchType(SearchType.DfsQueryThenFetch).query(qb).size(Integer.valueOf(10000)).sort(ElasticsearchUtil.getDocSorts(SortOrder.Asc), new SortOptions[0]).build();
        try {
            return this.client.search(searchRequest, Document.class);
        }
        catch (ElasticsearchException | IOException e) {
            throw ElasticsearchUtil.toDatabaseException("Search failed", (Exception)e);
        }
    }

    public Optional<Document> findByIdentifier(String identifier) throws DatabaseException {
        ParametersChecker.checkParameter((String)ALL_PARAMS_REQUIRED, (String[])new String[0]);
        String index = this.elasticsearchIndexAliasResolver.resolveIndexName(null).getName();
        return this.handleSearch(index, ElasticsearchUtil.termQuery(IDENTIFIER, identifier));
    }

    public void delete(List<String> ids, int tenant) throws DatabaseException {
        String index = this.elasticsearchIndexAliasResolver.resolveIndexName(tenant).getName();
        UnmodifiableIterator idIterator = Iterators.partition(ids.iterator(), (int)VitamConfiguration.getMaxElasticsearchBulk());
        while (idIterator.hasNext()) {
            BulkResponse bulkResponse;
            List documentIds = (List)idIterator.next();
            BulkRequest bulkRequest = new BulkRequest.Builder().operations(documentIds.stream().map(id -> BulkOperation.of(b -> b.delete(d -> (ObjectBuilder)((DeleteOperation.Builder)d.id(id)).index(index)))).collect(Collectors.toList())).refresh(idIterator.hasNext() ? Refresh.False : Refresh.True).build();
            try {
                bulkResponse = this.client.bulk(bulkRequest);
            }
            catch (ElasticsearchException | IOException e) {
                throw ElasticsearchUtil.toDatabaseException("Bulk delete exception", (Exception)e);
            }
            if (!bulkResponse.errors()) continue;
            LOGGER.error("ES delete in error: " + ElasticsearchUtil.buildFailureMessage(bulkResponse));
            throw new DatabaseException("An error occurred while bulk deleting documents");
        }
    }
}

