/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.client;

import fr.gouv.vitam.batch.report.client.BatchReportClient;
import fr.gouv.vitam.batch.report.client.BatchReportClientRest;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.SecureClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import java.io.File;
import java.io.IOException;

public class BatchReportClientFactory
extends VitamClientFactory<BatchReportClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BatchReportClientFactory.class);
    private static final String CONFIGURATION_FILENAME = "batch-report-client.conf";
    private static final String RESOURCE_PATH = "/batchreport/v1";
    private static final BatchReportClientFactory BATCH_REPORT_CLIENT_FACTORY = new BatchReportClientFactory();

    private BatchReportClientFactory() {
        super(BatchReportClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH);
    }

    public static BatchReportClientFactory getInstance() {
        return BatchReportClientFactory.getInstance(WorkFlowExecutionContext.VITAM);
    }

    public static BatchReportClientFactory getInstance(WorkFlowExecutionContext executionContext) {
        switch (executionContext) {
            default: {
                throw new MatchException(null, null);
            }
            case VITAM: 
            case COLLECT: 
        }
        return BATCH_REPORT_CLIENT_FACTORY;
    }

    public BatchReportClient getClient() {
        switch (this.getVitamClientType()) {
            default: {
                throw new MatchException(null, null);
            }
            case MOCK: {
                throw new IllegalArgumentException("Not implemented");
            }
            case PRODUCTION: 
        }
        return new BatchReportClientRest((VitamClientFactoryInterface<?>)this);
    }

    public static final ClientConfiguration changeConfigurationFile(String configurationPath) {
        ClientConfiguration configuration = null;
        try {
            configuration = (ClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), SecureClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)configurationPath, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)configurationPath);
        }
        return configuration;
    }

    public static final void changeMode(ClientConfiguration configuration) {
        BatchReportClientFactory.getInstance().initialisation(configuration, BatchReportClientFactory.getInstance().getResourcePath());
    }
}

