/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.common.model;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.processing.common.model.PauseRecover;
import fr.gouv.vitam.processing.common.model.ProcessStep;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessWorkflow {
    private static final String MANDATORY_PARAMETER = "Mandatory parameter";
    private String workflowId;
    private String operationId;
    private String contextId;
    private String applicationId;
    private String messageIdentifier;
    private String prodService;
    private WorkFlowExecutionContext executionContext;
    private List<ProcessStep> steps = new ArrayList<ProcessStep>();
    private String processDate = LocalDateUtil.nowFormatted();
    private LocalDateTime processCompletedDate;
    private LogbookTypeProcess logbookTypeProcess;
    private Integer tenantId;
    private StatusCode status = StatusCode.UNKNOWN;
    private ProcessState state = ProcessState.PAUSE;
    private StatusCode targetStatus;
    private volatile ProcessState targetState;
    private boolean forcedCancellation;
    private boolean stepByStep = false;
    private PauseRecover pauseRecover = PauseRecover.NO_RECOVER;
    private Map<String, String> parameters = new HashMap<String, String>();

    public ProcessWorkflow() {
    }

    @VisibleForTesting
    public ProcessWorkflow(LogbookTypeProcess logbookTypeProcess, StatusCode status, ProcessState state) {
        this.logbookTypeProcess = logbookTypeProcess;
        this.status = status;
        this.state = state;
    }

    public ProcessState getState() {
        return this.state;
    }

    public ProcessWorkflow setState(ProcessState state) {
        if (state != null) {
            this.state = state;
        }
        return this;
    }

    public ProcessState getTargetState() {
        return this.targetState;
    }

    public ProcessWorkflow setTargetState(ProcessState targetState) {
        this.targetState = targetState;
        return this;
    }

    public boolean isForcedCancellation() {
        return this.forcedCancellation;
    }

    public ProcessWorkflow setForcedCancellation(boolean forcedCancellation) {
        this.forcedCancellation = forcedCancellation;
        return this;
    }

    public List<ProcessStep> getSteps() {
        return this.steps;
    }

    public ProcessWorkflow setSteps(List<ProcessStep> steps) {
        this.steps = steps;
        return this;
    }

    public StatusCode getStatus() {
        return this.status;
    }

    public ProcessWorkflow setStatus(StatusCode status) {
        ParametersChecker.checkParameter((String)MANDATORY_PARAMETER, (Object[])new Object[]{status});
        this.status = this.status.compareTo((Enum)status) < 0 || this.status.equals((Object)StatusCode.FATAL) ? status : this.status;
        return this;
    }

    public StatusCode getTargetStatus() {
        return this.targetStatus;
    }

    public ProcessWorkflow setTargetStatus(StatusCode targetStatus) {
        this.targetStatus = targetStatus;
        return this;
    }

    public boolean isStepByStep() {
        return this.stepByStep;
    }

    public ProcessWorkflow setStepByStep(boolean stepByStep) {
        this.stepByStep = stepByStep;
        return this;
    }

    public String getProcessDate() {
        return this.processDate;
    }

    public ProcessWorkflow setProcessDate(String processDate) {
        this.processDate = processDate;
        return this;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public ProcessWorkflow setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public String getMessageIdentifier() {
        return this.messageIdentifier;
    }

    public ProcessWorkflow setMessageIdentifier(String messageIdentifier) {
        this.messageIdentifier = messageIdentifier;
        return this;
    }

    public String getProdService() {
        return this.prodService;
    }

    public ProcessWorkflow setProdService(String prodService) {
        this.prodService = prodService;
        return this;
    }

    public LogbookTypeProcess getLogbookTypeProcess() {
        return this.logbookTypeProcess;
    }

    public ProcessWorkflow setLogbookTypeProcess(LogbookTypeProcess logbookTypeProcess) {
        this.logbookTypeProcess = logbookTypeProcess;
        return this;
    }

    public Integer getTenantId() {
        return this.tenantId;
    }

    public ProcessWorkflow setTenantId(Integer tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public ProcessWorkflow setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    public String getContextId() {
        return this.contextId;
    }

    public ProcessWorkflow setContextId(String contextId) {
        this.contextId = contextId;
        return this;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public ProcessWorkflow setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public LocalDateTime getProcessCompletedDate() {
        return this.processCompletedDate;
    }

    public ProcessWorkflow setProcessCompletedDate(LocalDateTime processCompletedDate) {
        this.processCompletedDate = processCompletedDate;
        return this;
    }

    public PauseRecover getPauseRecover() {
        return this.pauseRecover;
    }

    public ProcessWorkflow setPauseRecover(PauseRecover pauseRecover) {
        this.pauseRecover = pauseRecover;
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public ProcessWorkflow setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public WorkFlowExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(WorkFlowExecutionContext executionContext) {
        this.executionContext = executionContext;
    }
}

