/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.common.parameter.VitamParameter;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import java.util.ArrayList;
import java.util.List;

public abstract class ActionHandler
implements VitamAutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ActionHandler.class);

    public void checkMandatoryParameters(WorkerParameters parameters) {
        ParametersChecker.checkNullOrEmptyParameters((VitamParameter)parameters);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
        throw new IllegalStateException("Not implemented.");
    }

    public void close() {
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        throw new IllegalStateException("Not implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        try {
            ArrayList<ItemStatus> aggregateItemStatus = new ArrayList<ItemStatus>();
            List<String> objectNameList = workerParameters.getObjectNameList();
            List<JsonNode> objectMetadataList = workerParameters.getObjectMetadataList();
            for (int i = 0; i < objectNameList.size(); ++i) {
                String objectId = objectNameList.get(i);
                JsonNode metadata = objectMetadataList != null && !objectMetadataList.isEmpty() ? objectMetadataList.get(i) : null;
                workerParameters.setObjectName(objectId);
                workerParameters.setObjectMetadata(metadata);
                handler.setCurrentObjectId(objectId);
                ItemStatus itemStatus = this.execute(workerParameters, handler);
                aggregateItemStatus.add(itemStatus);
            }
            ArrayList<ItemStatus> arrayList = aggregateItemStatus;
            return arrayList;
        }
        finally {
            handler.setCurrentObjectId(null);
        }
    }

    public static void updateDetailItemStatus(ItemStatus globalCompositeItemStatus, String value, String globalOutcomeDetailSubCode) {
        try {
            if (value != null) {
                ObjectNode evDetData = (ObjectNode)JsonHandler.getFromString((String)globalCompositeItemStatus.getEvDetailData());
                Object oldValue = "";
                if (evDetData.has("evDetTechData")) {
                    oldValue = evDetData.get("evDetTechData").textValue() + " \n";
                }
                evDetData.put("evDetTechData", (String)oldValue + value);
                globalCompositeItemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)evDetData));
                globalCompositeItemStatus.setMasterData(LogbookParameterName.eventDetailData.name(), (Object)JsonHandler.unprettyPrint((Object)evDetData));
            }
            if (null != globalOutcomeDetailSubCode) {
                globalCompositeItemStatus.setGlobalOutcomeDetailSubcode(globalOutcomeDetailSubCode);
            }
        }
        catch (InvalidParseOperationException e1) {
            LOGGER.error("Unexpected exception : evDetData invalid", (Throwable)e1);
            globalCompositeItemStatus.increment(StatusCode.FATAL);
        }
    }
}

