/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.distribution;

import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;

public class JsonLineWriter
implements AutoCloseable {
    private final Writer writer;
    private boolean isEmpty = true;
    private boolean isClosed = false;

    public JsonLineWriter(OutputStream outputStream) {
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public JsonLineWriter(OutputStream outputStream, boolean isEmpty) {
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.isEmpty = isEmpty;
    }

    public void addEntry(JsonLineModel line) throws IOException {
        if (!this.isEmpty) {
            this.writer.append("\n");
        }
        this.isEmpty = false;
        this.writer.append(JsonHandler.unprettyPrint((Object)line));
    }

    public void addEntry(Object line) throws IOException {
        if (!this.isEmpty) {
            this.writer.append("\n");
        }
        this.isEmpty = false;
        this.writer.append(JsonHandler.unprettyPrint((Object)line));
    }

    public void addEntries(List<?> lines) throws IOException {
        for (Object line : lines) {
            this.addEntry(line);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.isClosed = true;
    }
}

