/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.common.parameter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.processing.common.parameter.AbstractWorkerParameters;
import fr.gouv.vitam.processing.common.parameter.DefaultWorkerParameters;
import fr.gouv.vitam.processing.common.parameter.WorkerParametersFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class WorkerParametersDeserializer
extends JsonDeserializer<AbstractWorkerParameters> {
    public AbstractWorkerParameters deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        WorkFlowExecutionContext executionContext = null;
        Map<String, String> parameters = null;
        while (!parser.isClosed()) {
            String fieldName;
            JsonToken token = parser.nextToken();
            if (token != JsonToken.FIELD_NAME) continue;
            switch (fieldName = parser.currentName()) {
                case "executionContext": {
                    parser.nextToken();
                    executionContext = WorkFlowExecutionContext.valueOf((String)parser.getValueAsString());
                    break;
                }
                case "parameters": {
                    parameters = this.deserializeParameters(parser);
                }
            }
        }
        DefaultWorkerParameters result = WorkerParametersFactory.newWorkerParameters(executionContext);
        ((AbstractWorkerParameters)result).setMap(parameters);
        return result;
    }

    protected Map<String, String> deserializeParameters(JsonParser parser) throws IOException, JsonProcessingException {
        JsonToken token;
        HashMap<String, String> result = new HashMap<String, String>();
        while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
            switch (token) {
                case VALUE_STRING: {
                    result.put(parser.getCurrentName(), parser.getText());
                }
            }
        }
        return result;
    }
}

