/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.dsl.schema.DslSchema;
import fr.gouv.vitam.common.dsl.schema.ValidationException;
import fr.gouv.vitam.common.dsl.schema.Validator;
import fr.gouv.vitam.common.dsl.schema.meta.Schema;
import fr.gouv.vitam.common.dsl.schema.validator.DslValidator;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.IOException;
import java.io.InputStream;

public class SelectMultipleSchemaValidator
implements DslValidator {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SelectMultipleSchemaValidator.class);
    private static final String MANDATORY_DEPTH_MESSAGE = "DSL Graph validation : the query should contain a field $depth or $exactdepth (except on first query when no root is set)";
    private static final String FORBIDDEN_DEPTH_MESSAGE = "DSL Graph validation : the first query should not contain a field $depth or $exactdepth when no root is set";
    private final Schema schema;

    public SelectMultipleSchemaValidator() throws IOException {
        LOGGER.debug("Loading schema {} from {}", (Object)DslSchema.SELECT_MULTIPLE.name(), (Object)DslSchema.SELECT_MULTIPLE.getFilename());
        try (InputStream schemaSource = PropertiesUtils.getResourceAsStream((String)DslSchema.SELECT_MULTIPLE.getFilename());){
            this.schema = Schema.getSchema().loadTypes(schemaSource).build();
        }
    }

    @Override
    public void validate(JsonNode dsl) throws ValidationException {
        Validator.validate(this.schema, "DSL", dsl);
        this.validateGraph(dsl);
    }

    public static void validateStreamQuery(JsonNode queryJson) throws ValidationException {
        JsonNode offset = JsonHandler.getNodeByPath((JsonNode)queryJson, (String)(BuilderToken.GLOBAL.FILTER.exactToken() + "." + BuilderToken.SELECTFILTER.OFFSET.exactToken()), (boolean)false);
        if (offset != null) {
            throw new ValidationException(VitamCodeHelper.toVitamError((VitamCode)VitamCode.GLOBAL_INVALID_DSL, (String)("Cannot use " + BuilderToken.SELECTFILTER.OFFSET.exactToken() + " in this query")));
        }
        JsonNode limit = JsonHandler.getNodeByPath((JsonNode)queryJson, (String)(BuilderToken.GLOBAL.FILTER.exactToken() + "." + BuilderToken.SELECTFILTER.LIMIT.exactToken()), (boolean)false);
        if (limit != null) {
            throw new ValidationException(VitamCodeHelper.toVitamError((VitamCode)VitamCode.GLOBAL_INVALID_DSL, (String)("Cannot use " + BuilderToken.SELECTFILTER.LIMIT.exactToken() + " in this query")));
        }
        JsonNode facets = JsonHandler.getNodeByPath((JsonNode)queryJson, (String)BuilderToken.GLOBAL.FACETS.exactToken(), (boolean)false);
        if (facets != null && facets.elements().hasNext()) {
            throw new ValidationException(VitamCodeHelper.toVitamError((VitamCode)VitamCode.GLOBAL_INVALID_DSL, (String)("Cannot use " + BuilderToken.GLOBAL.FACETS.exactToken() + " in this query")));
        }
    }

    public static void checkAuthorizeTrackTotalHits(JsonNode queryJson, boolean configAuthorizeTrackTotalHits) throws ValidationException {
        JsonNode dslAuthorizeTrackTotalHits = JsonHandler.getNodeByPath((JsonNode)queryJson, (String)(BuilderToken.GLOBAL.FILTER.exactToken() + "." + BuilderToken.SELECTFILTER.TRACK_TOTAL_HITS.exactToken()), (boolean)false);
        if (dslAuthorizeTrackTotalHits != null && dslAuthorizeTrackTotalHits.asBoolean() && !configAuthorizeTrackTotalHits) {
            throw new ValidationException(VitamCodeHelper.toVitamError((VitamCode)VitamCode.UNAUTHORIZED_PARAMETER_DSL, (String)(BuilderToken.SELECTFILTER.TRACK_TOTAL_HITS.exactToken() + " is not authorized!")));
        }
    }

    private void validateGraph(JsonNode dsl) throws ValidationException {
        JsonNode queryNode;
        JsonNode roots;
        boolean hasRoot = false;
        if (dsl.has(BuilderToken.GLOBAL.ROOTS.exactToken()) && (roots = dsl.get(BuilderToken.GLOBAL.ROOTS.exactToken())).isArray() && ((ArrayNode)roots).size() > 0) {
            hasRoot = true;
        }
        if (dsl.has(BuilderToken.GLOBAL.QUERY.exactToken()) && (queryNode = dsl.get(BuilderToken.GLOBAL.QUERY.exactToken())).isArray()) {
            ArrayNode queries = (ArrayNode)queryNode;
            boolean firstQuery = true;
            for (JsonNode query : queries) {
                if (firstQuery && !hasRoot) {
                    if (query.has(BuilderToken.QUERYARGS.DEPTH.exactToken()) || query.has(BuilderToken.QUERYARGS.EXACTDEPTH.exactToken())) {
                        LOGGER.error(FORBIDDEN_DEPTH_MESSAGE);
                        throw new ValidationException(VitamCodeHelper.toVitamError((VitamCode)VitamCode.GLOBAL_INVALID_DSL, (String)FORBIDDEN_DEPTH_MESSAGE));
                    }
                } else if (!query.has(BuilderToken.QUERYARGS.DEPTH.exactToken()) && !query.has(BuilderToken.QUERYARGS.EXACTDEPTH.exactToken())) {
                    LOGGER.error(MANDATORY_DEPTH_MESSAGE);
                    throw new ValidationException(VitamCodeHelper.toVitamError((VitamCode)VitamCode.GLOBAL_INVALID_DSL, (String)MANDATORY_DEPTH_MESSAGE));
                }
                firstQuery = false;
            }
        }
    }
}

