/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema.meta;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.dsl.schema.ValidationErrorMessage;
import fr.gouv.vitam.common.dsl.schema.ValidationException;
import fr.gouv.vitam.common.dsl.schema.meta.Format;
import fr.gouv.vitam.common.dsl.schema.meta.Schema;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class ValidatorEngine {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ValidatorEngine.class);
    private Schema schema;
    private List<ValidationErrorMessage> errors;
    private List<Object> errorContext;

    public ValidatorEngine(Schema schema) {
        this.schema = schema;
    }

    public void validate(JsonNode document, String root) throws IllegalArgumentException, ValidationException {
        ParametersChecker.checkParameterDefault((String)"document", (Object[])new Object[]{document});
        Format rootType = this.schema.getType(root);
        if (rootType == null) {
            throw new IllegalArgumentException("Unknown Schema type: " + root);
        }
        this.errors = new ArrayList<ValidationErrorMessage>();
        this.errorContext = new ArrayList<Object>();
        this.validate(rootType, document, null);
        if (!this.errors.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (ValidationErrorMessage error : this.errors) {
                builder.append(error.toString());
                builder.append("\n");
            }
            throw new ValidationException(VitamCodeHelper.toVitamError((VitamCode)VitamCode.GLOBAL_INVALID_DSL, (String)builder.toString()));
        }
    }

    protected void validate(Format propertyFormat, JsonNode node, Consumer<String> fieldReport) {
        Consumer<String> localFieldReport;
        HashSet<String> fields;
        if (propertyFormat.getName() == null) {
            throw new IllegalStateException();
        }
        LOGGER.debug("DSL Parsing: " + String.valueOf(propertyFormat) + " --- on: " + String.valueOf(node));
        ParametersChecker.checkParameterDefault((String)"property", (Object[])new Object[]{propertyFormat});
        ParametersChecker.checkParameterDefault((String)"node", (Object[])new Object[]{node});
        if (fieldReport == null && node.isObject()) {
            fields = new HashSet();
            Iterator it = node.fieldNames();
            while (it.hasNext()) {
                fields.add((String)it.next());
            }
            localFieldReport = fields::remove;
        } else if (fieldReport == null) {
            fields = new HashSet<String>();
            localFieldReport = fields::remove;
        } else {
            localFieldReport = fieldReport;
            fields = null;
        }
        if (node.isArray() || node.isObject()) {
            this.checkSize(propertyFormat, node);
        }
        propertyFormat.validate(node, localFieldReport, this);
        if (fields != null) {
            for (String field : fields) {
                this.reportError(propertyFormat, node.get(field), ValidationErrorMessage.Code.INVALID_JSON_FIELD, field);
            }
        }
    }

    protected void pushContext(Object name) {
        this.errorContext.add(name);
    }

    protected void popContext() {
        this.errorContext.remove(this.errorContext.size() - 1);
    }

    protected void reportError(Format propertyFormat, JsonNode node, ValidationErrorMessage.Code code, String message) {
        ArrayList<Object> errorContextCopy = new ArrayList<Object>(this.errorContext);
        this.errors.add(new ValidationErrorMessage(node, propertyFormat, code, message, errorContextCopy));
    }

    private void checkSize(Format format, JsonNode node) {
        if (node.size() < format.getMin()) {
            this.reportError(format, node, ValidationErrorMessage.Code.ELEMENT_TOO_SHORT, node.size() + " < " + format.getMin());
        }
        if (node.size() > format.getMax()) {
            this.reportError(format, node, ValidationErrorMessage.Code.ELEMENT_TOO_LONG, node.size() + " > " + format.getMax());
        }
    }
}

