/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema.meta;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.dsl.schema.meta.Format;
import fr.gouv.vitam.common.dsl.schema.meta.Schema;
import fr.gouv.vitam.common.dsl.schema.meta.ValidatorEngine;
import java.util.List;
import java.util.function.Consumer;

public class UnionFormat
extends Format {
    private List<Format> types;

    @Override
    protected void resolve(Schema schema) {
        for (Format format : this.types) {
            format.setReportingType(this);
        }
    }

    public void setTypes(List<Format> types) {
        this.types = types;
    }

    @Override
    public void validate(JsonNode node, Consumer<String> fieldReport, ValidatorEngine validator) {
        for (Format format : this.types) {
            validator.validate(format, node, fieldReport);
        }
    }

    @Override
    public void walk(Consumer<Format> consumer) {
        consumer.accept(this);
        for (Format type : this.types) {
            type.walk(consumer);
        }
    }

    @Override
    public String debugInfo() {
        StringBuilder builder = new StringBuilder();
        boolean notFirst = false;
        for (Format item : this.types) {
            if (notFirst) {
                builder.append(" & ");
            }
            builder.append(item.debugInfo());
            notFirst = true;
        }
        return builder.toString();
    }
}

