/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema.meta;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.dsl.schema.ValidationErrorMessage;
import fr.gouv.vitam.common.dsl.schema.meta.Format;
import fr.gouv.vitam.common.dsl.schema.meta.JsonTypeName;
import fr.gouv.vitam.common.dsl.schema.meta.Schema;
import fr.gouv.vitam.common.dsl.schema.meta.ValidatorEngine;
import java.util.Map;
import java.util.function.Consumer;

public class TypeChoiceArrayFormat
extends Format {
    private Map<JsonTypeName, Format> itemChoices;

    @Override
    protected void resolve(Schema schema) {
        for (Format format : this.itemChoices.values()) {
            format.setReportingType(this);
        }
    }

    public void setItemchoices(Map<JsonTypeName, Format> itemChoices) {
        this.itemChoices = itemChoices;
    }

    @Override
    public void validate(JsonNode node, Consumer<String> fieldReport, ValidatorEngine validator) {
        if (!node.isArray()) {
            validator.reportError(this, node, ValidationErrorMessage.Code.WRONG_JSON_TYPE, node.getNodeType().name());
            return;
        }
        if (node.size() == 0) {
            return;
        }
        JsonTypeName typeName = JsonTypeName.fromJsonNodeType(node.get(0).getNodeType());
        Format choosen = this.itemChoices.get((Object)typeName);
        if (choosen == null) {
            validator.reportError(this, node, ValidationErrorMessage.Code.NO_VIABLE_ALTERNATIVE, typeName.toString());
        }
        for (JsonNode item : node) {
            validator.validate(choosen, item, null);
        }
    }

    @Override
    public void walk(Consumer<Format> consumer) {
        consumer.accept(this);
        for (Format format : this.itemChoices.values()) {
            format.walk(consumer);
        }
    }

    @Override
    public String debugInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        boolean notFirst = false;
        for (Map.Entry<JsonTypeName, Format> entry : this.itemChoices.entrySet()) {
            if (notFirst) {
                builder.append("}[]|{");
            }
            builder.append((Object)entry.getKey());
            builder.append("-> ");
            builder.append(entry.getValue().debugInfo());
            notFirst = true;
        }
        builder.append("}[]");
        return builder.toString();
    }
}

