/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema.meta;

import com.fasterxml.jackson.core.type.TypeReference;
import fr.gouv.vitam.common.dsl.schema.meta.Format;
import fr.gouv.vitam.common.dsl.schema.meta.Schema;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class SchemaBuilder {
    private static final TypeReference<Map<String, Format>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Format>>(){};
    private Map<String, Format> types = new HashMap<String, Format>();

    protected SchemaBuilder() {
    }

    public SchemaBuilder loadTypes(InputStream schemaStream) {
        try {
            Map loaded = (Map)JsonHandler.getFromInputStreamLowerCamelCase((InputStream)schemaStream, MAP_TYPE_REFERENCE);
            for (Map.Entry entry : loaded.entrySet()) {
                Format format = (Format)entry.getValue();
                String name = (String)entry.getKey();
                format.setName(name);
                Format oldType = this.types.put(name, format);
                if (oldType == null) continue;
                throw new IllegalArgumentException("Schema type " + name + " already loaded into schema");
            }
            return this;
        }
        catch (InvalidParseOperationException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    public Schema build() {
        return new Schema(this.types);
    }
}

