/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema.meta;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import fr.gouv.vitam.common.dsl.schema.ValidationErrorMessage;
import fr.gouv.vitam.common.dsl.schema.meta.Format;
import fr.gouv.vitam.common.dsl.schema.meta.PrimitiveAnalysis;
import fr.gouv.vitam.common.dsl.schema.meta.Schema;
import fr.gouv.vitam.common.dsl.schema.meta.ValidatorEngine;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.guid.GUIDReader;
import java.util.function.Consumer;

public class ReferenceFormat
extends Format {
    private String type;
    private Format referred;

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setMax(int max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMin(Integer min) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validate(JsonNode node, Consumer<String> fieldReport, ValidatorEngine validator) {
        if (this.referred != null) {
            this.validateNotPrimitive(node, fieldReport, validator);
        } else {
            switch (this.validatePrimitive(this.type, node, fieldReport)) {
                case PRIMITIVE_KO: {
                    validator.reportError(this, node, ValidationErrorMessage.Code.INVALID_VALUE, node.getNodeType().name());
                    break;
                }
                case PRIMITIVE_OK: {
                    break;
                }
                case NOT_PRIMITIVE: {
                    throw new RuntimeException("Internal inconsistency in reference resolution");
                }
            }
        }
    }

    @Override
    public void walk(Consumer<Format> consumer) {
        consumer.accept(this);
    }

    private void validateNotPrimitive(JsonNode node, Consumer<String> fieldReport, ValidatorEngine validator) {
        validator.validate(this.referred, node, fieldReport);
    }

    private PrimitiveAnalysis validatePrimitive(String typeName, JsonNode node, Consumer<String> fieldReport) {
        switch (typeName) {
            case "guid": {
                return PrimitiveAnalysis.fromBoolean(node.isTextual() && this.isValidGuid(node.textValue()));
            }
            case "integer": {
                return PrimitiveAnalysis.fromBoolean(node.isInt());
            }
            case "posinteger": {
                return PrimitiveAnalysis.fromBoolean(node.isInt() && node.intValue() >= 0);
            }
            case "string": {
                return PrimitiveAnalysis.fromBoolean(node.isTextual());
            }
            case "anyvalue": {
                return PrimitiveAnalysis.fromBoolean(node.isValueNode());
            }
            case "anyarray": {
                return PrimitiveAnalysis.fromBoolean(node.isArray());
            }
            case "any": {
                this.consumeAllFields(node, fieldReport);
                return PrimitiveAnalysis.PRIMITIVE_OK;
            }
        }
        return PrimitiveAnalysis.NOT_PRIMITIVE;
    }

    private boolean isValidGuid(String guid) {
        try {
            return GUIDReader.getGUID((String)guid) != null;
        }
        catch (InvalidGuidOperationException e) {
            return false;
        }
    }

    @Override
    public String debugInfo() {
        if (this.referred == null) {
            return this.type;
        }
        return this.referred.debugInfo();
    }

    @Override
    protected void resolve(Schema schema) {
        Consumer<String> reportNothing = string -> {};
        if (this.validatePrimitive(this.type, (JsonNode)NullNode.getInstance(), reportNothing) == PrimitiveAnalysis.NOT_PRIMITIVE) {
            this.referred = schema.getType(this.type);
            if (this.referred == null) {
                throw new IllegalArgumentException("Type " + this.type + " invalid: not a primitive nor a composite type");
            }
        }
    }
}

