/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema.meta;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.dsl.schema.meta.AnyKeyFormat;
import fr.gouv.vitam.common.dsl.schema.meta.ArrayFormat;
import fr.gouv.vitam.common.dsl.schema.meta.EnumFormat;
import fr.gouv.vitam.common.dsl.schema.meta.KeyChoiceFormat;
import fr.gouv.vitam.common.dsl.schema.meta.ObjectFormat;
import fr.gouv.vitam.common.dsl.schema.meta.ReferenceFormat;
import fr.gouv.vitam.common.dsl.schema.meta.Schema;
import fr.gouv.vitam.common.dsl.schema.meta.ShortReferenceFormat;
import fr.gouv.vitam.common.dsl.schema.meta.TypeChoiceArrayFormat;
import fr.gouv.vitam.common.dsl.schema.meta.TypeChoiceFormat;
import fr.gouv.vitam.common.dsl.schema.meta.UnionFormat;
import fr.gouv.vitam.common.dsl.schema.meta.ValidatorEngine;
import java.util.Iterator;
import java.util.function.Consumer;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, defaultImpl=ShortReferenceFormat.class, property="format")
@JsonSubTypes(value={@JsonSubTypes.Type(value=AnyKeyFormat.class, name="anykey"), @JsonSubTypes.Type(value=ArrayFormat.class, name="array"), @JsonSubTypes.Type(value=EnumFormat.class, name="enum"), @JsonSubTypes.Type(value=KeyChoiceFormat.class, name="keychoice"), @JsonSubTypes.Type(value=ObjectFormat.class, name="object"), @JsonSubTypes.Type(value=TypeChoiceFormat.class, name="typechoice"), @JsonSubTypes.Type(value=TypeChoiceArrayFormat.class, name="typechoicearray"), @JsonSubTypes.Type(value=UnionFormat.class, name="union"), @JsonSubTypes.Type(value=ReferenceFormat.class, name="ref")})
public abstract class Format {
    private String name;
    private boolean optional = false;
    private String hint;
    private int min = 0;
    private int max = Integer.MAX_VALUE;
    private Format reportingType;

    protected abstract void resolve(Schema var1);

    protected void consumeAllFields(JsonNode node, Consumer<String> fieldReport) {
        if (fieldReport != null) {
            Iterator it = node.fieldNames();
            while (it.hasNext()) {
                String fieldname = (String)it.next();
                fieldReport.accept(fieldname);
            }
        }
    }

    public abstract void validate(JsonNode var1, Consumer<String> var2, ValidatorEngine var3);

    public abstract void walk(Consumer<Format> var1);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public abstract String debugInfo();

    public String toString() {
        if (this.name != null) {
            return this.name + (this.optional ? "?: " : ": ") + this.debugInfo();
        }
        return this.debugInfo();
    }

    protected void setReportingType(Format format) {
        if (this.name == null) {
            this.name = format.name;
        }
        if (this.hint == null) {
            this.hint = format.hint;
        }
        this.reportingType = format;
    }

    public Format getReportingType() {
        return this.reportingType != null ? this.reportingType : this;
    }
}

