/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema;

import fr.gouv.vitam.common.dsl.schema.DslSchema;
import fr.gouv.vitam.common.dsl.schema.ValidationException;
import fr.gouv.vitam.common.dsl.schema.validator.BatchProcessingQuerySchemaValidator;
import fr.gouv.vitam.common.dsl.schema.validator.DslValidator;
import fr.gouv.vitam.common.dsl.schema.validator.GetByIdSchemaValidator;
import fr.gouv.vitam.common.dsl.schema.validator.ReclassificationQuerySchemaValidator;
import fr.gouv.vitam.common.dsl.schema.validator.SelectMultipleSchemaValidator;
import fr.gouv.vitam.common.dsl.schema.validator.SelectSingleSchemaValidator;
import fr.gouv.vitam.common.dsl.schema.validator.UpdateBulkSchemaValidator;
import fr.gouv.vitam.common.dsl.schema.validator.UpdateByIdSchemaValidator;
import fr.gouv.vitam.common.dsl.schema.validator.UpdateMultipleSchemaValidator;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;

@Priority(value=5000)
public class DslScannerFilter
implements ContainerRequestFilter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DslScannerFilter.class);
    private DslValidator selectMultipleSchemaValidator;
    private DslValidator selectSingleSchemaValidator;
    private DslValidator getByIdSchemaValidator;
    private DslValidator updateByIdSchemaValidator;
    private DslValidator batchProcessingQuerySchemaValidator;
    private DslValidator massUpdateSchemaValidator;
    private DslValidator bulkUpdateSchemaValidator;
    private DslValidator updateQueryReclassificationSchemaValidator;
    private DslSchema dslSchema;

    public DslScannerFilter(DslSchema dslSchema) throws IOException {
        this.dslSchema = dslSchema;
        this.selectMultipleSchemaValidator = new SelectMultipleSchemaValidator();
        this.selectSingleSchemaValidator = new SelectSingleSchemaValidator();
        this.getByIdSchemaValidator = new GetByIdSchemaValidator();
        this.updateByIdSchemaValidator = new UpdateByIdSchemaValidator();
        this.batchProcessingQuerySchemaValidator = new BatchProcessingQuerySchemaValidator();
        this.updateQueryReclassificationSchemaValidator = new ReclassificationQuerySchemaValidator();
        this.massUpdateSchemaValidator = new UpdateMultipleSchemaValidator();
        this.bulkUpdateSchemaValidator = new UpdateBulkSchemaValidator();
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            InputStream bodyInputStream = requestContext.getEntityStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bodyInputStream.transferTo((OutputStream)bout);
            switch (this.dslSchema) {
                case SELECT_MULTIPLE: {
                    this.selectMultipleSchemaValidator.validate(JsonHandler.getFromInputStream((InputStream)bout.toInputStream()));
                    break;
                }
                case SELECT_SINGLE: {
                    this.selectSingleSchemaValidator.validate(JsonHandler.getFromInputStream((InputStream)bout.toInputStream()));
                    break;
                }
                case BATCH_PROCESSING: {
                    this.batchProcessingQuerySchemaValidator.validate(JsonHandler.getFromInputStream((InputStream)bout.toInputStream()));
                    break;
                }
                case GET_BY_ID: {
                    this.getByIdSchemaValidator.validate(JsonHandler.getFromInputStream((InputStream)bout.toInputStream()));
                    break;
                }
                case UPDATE_BY_ID: {
                    this.updateByIdSchemaValidator.validate(JsonHandler.getFromBytes((byte[])bout.toByteArray()));
                    break;
                }
                case RECLASSIFICATION_QUERY: {
                    this.updateQueryReclassificationSchemaValidator.validate(JsonHandler.getFromBytes((byte[])bout.toByteArray()));
                    break;
                }
                case MASS_UPDATE: {
                    this.massUpdateSchemaValidator.validate(JsonHandler.getFromBytes((byte[])bout.toByteArray()));
                    break;
                }
                case BULK_UPDATE: {
                    this.bulkUpdateSchemaValidator.validate(JsonHandler.getFromInputStream((InputStream)bout.toInputStream()));
                    break;
                }
                default: {
                    requestContext.abortWith(VitamCodeHelper.toVitamError((VitamCode)VitamCode.GLOBAL_INTERNAL_SERVER_ERROR, (String)"Dsl schema is not valid.").toResponse());
                }
            }
            requestContext.setEntityStream(bout.toInputStream());
        }
        catch (ValidationException e) {
            LOGGER.warn((Throwable)((Object)e));
            requestContext.abortWith(e.getVitamError().toResponse());
        }
        catch (InvalidParseOperationException e) {
            LOGGER.warn((Throwable)e);
            requestContext.abortWith(VitamCodeHelper.toVitamError((VitamCode)VitamCode.GLOBAL_INTERNAL_SERVER_ERROR, (String)"Can not read Dsl query").toResponse());
        }
    }
}

