/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.elastic.kibana.interceptor.rest;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.elastic.kibana.interceptor.rest.InterceptorResource;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReplacePatternUtils {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(InterceptorResource.class);
    private static final String SHARP_REPLACEMENT = "\"#$1";
    private static final String UNDERSCORE_REPLACEMENT = "\"_$1";
    private static final String REGEXP_START_SHARP = "\"#(";
    private static final String REGEXP_START_UNDERSCORE = "\"_(";
    private static final String END_REGEXP = ")\\b";
    private final Pattern sharpPattern;
    private final Pattern underscorePattern;

    public ReplacePatternUtils(List<String> whiteList) {
        this.sharpPattern = Pattern.compile(this.buildRegexPatternWithWhiteList(whiteList, REGEXP_START_SHARP));
        this.underscorePattern = Pattern.compile(this.buildRegexPatternWithWhiteList(whiteList, REGEXP_START_UNDERSCORE));
    }

    private String buildRegexPatternWithWhiteList(List<String> whiteList, String regexStart) {
        int i = 0;
        StringBuilder regexExpressionBuilder = new StringBuilder(regexStart);
        for (String whiteListArgument : whiteList) {
            if (whiteList.size() - 1 == i) {
                regexExpressionBuilder.append(whiteListArgument);
            } else {
                regexExpressionBuilder.append(whiteListArgument).append("|");
            }
            ++i;
        }
        regexExpressionBuilder.append(END_REGEXP);
        return regexExpressionBuilder.toString();
    }

    public String replaceUnderscoreBySharp(String textToReplace) {
        LOGGER.debug("textToReplace" + textToReplace);
        String replacedString = this.replaceStringWithPattern(textToReplace, this.underscorePattern, SHARP_REPLACEMENT);
        LOGGER.debug("replacedString" + replacedString);
        return replacedString.replaceAll("_nbc", "#nbc");
    }

    public String replaceSharpByUnderscore(String textToReplace) {
        LOGGER.debug("textToReplace" + textToReplace);
        String replacedString = this.replaceStringWithPattern(textToReplace, this.sharpPattern, UNDERSCORE_REPLACEMENT);
        LOGGER.debug("replacedString" + replacedString);
        return replacedString.replaceAll("#nbc", "_nbc");
    }

    private String replaceStringWithPattern(String textToReplace, Pattern pattern, String replacement) {
        Matcher m = pattern.matcher(textToReplace);
        if (m.find()) {
            return m.replaceAll(replacement);
        }
        return textToReplace;
    }
}

