/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.core.identifier.search;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.internal.api.AccessInternalModule;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalException;
import fr.gouv.vitam.access.internal.core.AccessInternalModuleImpl;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.identifier.PurgedCollectionType;
import fr.gouv.vitam.common.model.identifier.PurgedPersistentIdentifier;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;

public class PurgedPersistentIdentifierSearchService {
    private final AccessInternalModule accessInternalModule;

    public PurgedPersistentIdentifierSearchService(AccessInternalModule accessInternalModule) {
        this.accessInternalModule = accessInternalModule;
    }

    public PurgedPersistentIdentifierSearchService() {
        this(new AccessInternalModuleImpl());
    }

    public Collection<PurgedPersistentIdentifier> search(String persistentIdentifier, @Nullable PurgedCollectionType type) {
        try {
            return ((Collection)JsonHandler.getFromJsonNode((JsonNode)this.accessInternalModule.selectPurgedPersistentIdentifier(persistentIdentifier, type), (TypeReference)new TypeReference<Collection<PurgedPersistentIdentifier>>(this){})).stream().sorted(Comparator.comparing(PurgedPersistentIdentifier::getOperationLastPersistentDate)).collect(Collectors.toList());
        }
        catch (InvalidParseOperationException e) {
            throw new VitamRuntimeException("Something wrong with persistent identifier search parsing or mapping", (Throwable)e);
        }
        catch (AccessInternalException e) {
            throw new VitamRuntimeException("Something wrong during persistent identifier search", (Throwable)e);
        }
    }
}

