/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.core.identifier.search;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.internal.api.AccessInternalModule;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalExecutionException;
import fr.gouv.vitam.access.internal.core.AccessInternalModuleImpl;
import fr.gouv.vitam.access.internal.core.identifier.search.MultiQuerySearchService;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import java.util.Collection;

public class ObjectGroupMultiQuerySearchService
implements MultiQuerySearchService<ObjectGroupResponse> {
    private final AccessInternalModule accessInternalModule;

    public ObjectGroupMultiQuerySearchService(AccessInternalModule accessInternalModule) {
        this.accessInternalModule = accessInternalModule;
    }

    public ObjectGroupMultiQuerySearchService() {
        this(new AccessInternalModuleImpl());
    }

    @Override
    public Collection<ObjectGroupResponse> search(SelectMultiQuery multiQuery) {
        try {
            JsonNode objectGroupResults = this.accessInternalModule.selectObjects((JsonNode)multiQuery.getFinalSelect());
            return RequestResponseOK.getFromJsonNode((JsonNode)objectGroupResults, ObjectGroupResponse.class).getResults();
        }
        catch (AccessInternalExecutionException | InvalidParseOperationException | VitamDBException e) {
            throw new VitamRuntimeException(e);
        }
    }
}

