/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.core.identifier;

import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.objectgroup.PersistentIdentifierModel;
import fr.gouv.vitam.common.model.objectgroup.QualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.VersionsModel;
import java.util.Objects;
import java.util.Optional;

public class PersistentIdentifierHelper {
    public static Optional<VersionsModel> findVersion(ObjectGroupResponse objectGroupResponse, String persistentIdentifier) {
        if (objectGroupResponse.getQualifiers() == null) {
            return Optional.empty();
        }
        for (QualifiersModel qualifiersModel : objectGroupResponse.getQualifiers()) {
            if (qualifiersModel.getVersions() == null) continue;
            for (VersionsModel versionsModel : qualifiersModel.getVersions()) {
                if (versionsModel.getPersistentIdentifier() == null) continue;
                for (PersistentIdentifierModel persistentIdentifierModel : versionsModel.getPersistentIdentifier()) {
                    if (!Objects.equals(persistentIdentifierModel.getPersistentIdentifierContent(), persistentIdentifier)) continue;
                    return Optional.of(versionsModel);
                }
            }
        }
        return Optional.empty();
    }
}

