/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import fr.gouv.vitam.access.internal.api.AccessInternalModule;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalExecutionException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalIllegalOperationException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalRuleExecutionException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalUnavailableDataFromAsyncOfferException;
import fr.gouv.vitam.access.internal.core.DslParserHelper;
import fr.gouv.vitam.access.internal.core.identifier.PersistentIdentifierHelper;
import fr.gouv.vitam.access.internal.core.identifier.query.PersistentIdentifierMultiQueryFactory;
import fr.gouv.vitam.access.internal.core.identifier.search.ObjectGroupMultiQuerySearchService;
import fr.gouv.vitam.access.internal.core.permission.VersionUsagePermissionValidator;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogInfoModel;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserHelper;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.database.utils.AccessContractRestrictionHelper;
import fr.gouv.vitam.common.database.utils.MetadataDocumentHelper;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.UpdatePermissionException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.CanonicalJsonFormatter;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.metrics.VitamCommonMetrics;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.model.MetadataStorageHelper;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamConstants;
import fr.gouv.vitam.common.model.VitamSession;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.identifier.PurgedCollectionType;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.objectgroup.QualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.VersionsModel;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.common.model.storage.AccessRequestReference;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.model.storage.StatusByAccessRequest;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.common.utils.ClassificationLevelUtil;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesException;
import fr.gouv.vitam.functional.administration.common.utils.ArchiveUnitUpdateUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.api.exception.MetadataInvalidSelectException;
import fr.gouv.vitam.metadata.api.exception.MetadataScrollLimitExceededException;
import fr.gouv.vitam.metadata.api.exception.MetadataScrollThresholdExceededException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageIllegalOperationClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageAlreadyExistException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.common.CompressInformation;
import io.prometheus.client.Counter;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class AccessInternalModuleImpl
implements AccessInternalModule {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessInternalModuleImpl.class);
    private static final String ACCESS_CONTRACT = "AccessContract";
    private static final String DIP_CONTAINER = "DIP";
    private static final String TRANSFER_SIP_CONTAINER = "TRANSFER";
    private static final String ID_CHECK_FAILED = "the unit_id should be filled";
    private static final String STP_UPDATE_UNIT = "STP_UPDATE_UNIT";
    private static final String STP_UPDATE_UNIT_DESC = "STP_UPDATE_UNIT_DESC";
    private static final String UNIT_METADATA_UPDATE = "UNIT_METADATA_UPDATE";
    private static final String UNIT_CHECK_PERMISSION = "UNIT_METADATA_UPDATE_CHECK_PERMISSION";
    private static final String UNIT_CHECK_RULES = "UNIT_METADATA_UPDATE_CHECK_RULES";
    private static final String UNIT_CHECK_DT = "UNIT_METADATA_UPDATE_CHECK_DT";
    private static final String UNIT_METADATA_STORAGE = "UNIT_METADATA_STORAGE";
    private static final String COMMIT_LIFE_CYCLE_UNIT = "COMMIT_LIFE_CYCLE_UNIT";
    private static final String DOLLAR_DIFF = "$diff";
    private static final String RESULTS = "$results";
    private static final String METADATA_INTERNAL_SERVER_ERROR = "Metadata internal server error";
    private static final String LOGBOOK_OPERATION_ALREADY_EXISTS = "logbook operation already exists";
    private static final String LOGBOOK_CLIENT_BAD_REQUEST_ERROR = "logbook client bad request error";
    private static final String LOGBOOK_CLIENT_NOT_FOUND_ERROR = "logbook client not found error";
    private static final String METADATA_EXECUTION_EXECUTION_ERROR = "metadata execution execution error";
    private static final String METADATA_NOT_FOUND_ERROR = "metadata not found execution error";
    private static final String DOCUMENT_CLIENT_SERVER_ERROR = "document client server error";
    private static final String METADATA_DOCUMENT_SIZE_ERROR = "metadata document size error";
    private static final String ILLEGAL_ARGUMENT = "illegal argument";
    private static final String PARSING_ERROR = "parsing error";
    private static final String CLIENT_SERVER_ERROR = "client server error";
    private static final String CLIENT_NOT_FOUND = "client not found";
    private static final String BAD_REQUEST = "bad request";
    private static final String DIFF = "#diff";
    private static final String ID = "#id";
    private static final String WORKSPACE_SERVER_EXCEPTION = "workspace server exception";
    private static final String STORAGE_SERVER_EXCEPTION = "Storage server exception";
    private static final String JSON = ".json";
    private static final String ARCHIVE_UNIT_NOT_FOUND = "Archive unit not found";
    private static final String ERROR_ADD_CONDITION = "Error during adding condition of Operations";
    private static final String ERROR_CHECK_PERMISSIONS = "Error during checking permission";
    private static final String ERROR_CHECK_RULES = "Error during checking updated rules";
    private static final String DT_NO_EXTISTING = "Archive unit profile could not be found";
    private static final String ERROR_UPDATE_RULE = "Can't Update Rule: ";
    private static final String ERROR_CREATE_RULE = "Can't Create Rule: ";
    private static final String ERROR_DELETE_RULE = "Can't Delete Rule: ";
    private static final String ERROR_PREVENT_INHERITANCE = " contains an inheritance prevention";
    private static final String RULES_KEY = "Rules";
    private static final String MANAGEMENT_KEY = "#management";
    private static final String FINAL_ACTION_KEY = "FinalAction";
    private static final String INHERITANCE_KEY = "Inheritance";
    private static final String PREVENT_INHERITANCE_KEY = "PreventInheritance";
    private static final String PREVENT_RULES_ID_KEY = "PreventRulesId";
    private static final String MANAGEMENT_PREFIX = "#management.";
    private static final String RULES_PREFIX = ".Rules";
    private static final String FINAL_ACTION_PREFIX = ".FinalAction";
    private static final String NOT_A_SELECT_OPERATION = "Not a Select operation";
    private static final String DATA_CATEGORY = "Data category ";
    private static final String ID_DOC_EMPTY = "idDocument is empty";
    private static final String UNSUPPORTED_CATEGORY = "Unsupported category ";
    private static final String ERROR_CODE = "errorCode";
    private static final String RULE_TYPE = "RuleType";
    private static final String OBJECT_TAG = "#object";
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final StorageClientFactory storageClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final MetaDataClientFactory metaDataClientFactory;
    private final VersionUsagePermissionValidator versionUsagePermissionValidator = new VersionUsagePermissionValidator();

    public AccessInternalModuleImpl() {
        this(LogbookLifeCyclesClientFactory.getInstance(), LogbookOperationsClientFactory.getInstance(), StorageClientFactory.getInstance(), WorkspaceClientFactory.getInstance((WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM), AdminManagementClientFactory.getInstance(), MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    public AccessInternalModuleImpl(LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory, StorageClientFactory storageClientFactory, WorkspaceClientFactory workspaceClientFactory, AdminManagementClientFactory adminManagementClientFactory, MetaDataClientFactory metaDataClientFactory) {
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.storageClientFactory = storageClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.metaDataClientFactory = metaDataClientFactory;
    }

    private static void checkActionsOnRules(UpdateMultiQuery request, List<String> deletedCategoryRules, Map<String, JsonNode> updatedCategoryRules) throws AccessInternalRuleExecutionException {
        Iterator actionsIterator = request.getActions().iterator();
        while (actionsIterator.hasNext()) {
            Action action = (Action)actionsIterator.next();
            BuilderToken.UPDATEACTION currentAction = action.getUPDATEACTION();
            if (!BuilderToken.UPDATEACTION.SET.equals((Object)currentAction) && !BuilderToken.UPDATEACTION.UNSET.equals((Object)currentAction)) continue;
            JsonNode object = action.getCurrentObject();
            if (BuilderToken.UPDATEACTION.UNSET.equals((Object)currentAction)) {
                ArrayNode values = (ArrayNode)object;
                int len = values.size();
                for (int i = 0; i < len; ++i) {
                    String unsetField = values.get(i).asText();
                    if (!unsetField.startsWith(MANAGEMENT_PREFIX) || !VitamConstants.getSupportedRules().contains(unsetField.substring(MANAGEMENT_PREFIX.length()))) continue;
                    deletedCategoryRules.add(unsetField.substring(MANAGEMENT_PREFIX.length()));
                }
                continue;
            }
            Iterator fields = object.fieldNames();
            while (fields.hasNext()) {
                JsonNode objectToPut = null;
                String field = (String)fields.next();
                if (!field.startsWith(MANAGEMENT_PREFIX)) continue;
                String ruleToBeChecked = field.substring(MANAGEMENT_PREFIX.length());
                if (ruleToBeChecked.contains(".")) {
                    String[] params = ruleToBeChecked.split("\\.");
                    String mainAtt = params[0];
                    String subAtt = params[params.length - 1];
                    objectToPut = JsonHandler.createObjectNode();
                    objectToPut.set(subAtt, object.get(field));
                    ruleToBeChecked = mainAtt;
                }
                if (!VitamConstants.getSupportedRules().contains(ruleToBeChecked)) continue;
                updatedCategoryRules.put(ruleToBeChecked, objectToPut != null ? objectToPut : object.get(field));
                actionsIterator.remove();
            }
        }
    }

    public JsonNode selectUnit(JsonNode jsonQuery) throws IllegalArgumentException, InvalidParseOperationException, AccessInternalExecutionException {
        JsonNode jsonNode = null;
        LOGGER.debug("DEBUG: start selectUnits {}", (Object)jsonQuery);
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            SanityChecker.checkJsonAll((JsonNode)jsonQuery);
            LOGGER.debug("{}", jsonNode);
            RequestParserMultiple parser = RequestParserHelper.getParser((JsonNode)jsonQuery.deepCopy());
            parser.getRequest().reset();
            if (!(parser instanceof SelectParserMultiple)) {
                throw new InvalidParseOperationException(NOT_A_SELECT_OPERATION);
            }
            jsonNode = metaDataClient.selectUnits(jsonQuery);
            LOGGER.debug("DEBUG {}", (Object)jsonNode);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(PARSING_ERROR, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(ILLEGAL_ARGUMENT, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("exeption thrown", (Throwable)e);
            throw new AccessInternalExecutionException((Throwable)e);
        }
        return jsonNode;
    }

    public JsonNode selectPurgedPersistentIdentifier(String persistentIdentifier, @Nullable PurgedCollectionType type) throws InvalidParseOperationException, AccessInternalException {
        JsonNode jsonNode;
        block8: {
            LOGGER.debug("DEBUG: purged persistent identifiers {}", (Object)persistentIdentifier);
            MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{persistentIdentifier});
                jsonNode = metaDataClient.getPurgedPersistentIdentifiers(persistentIdentifier, type);
                if (metaDataClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MetaDataClientServerException | MetaDataNotFoundException e) {
                    throw new AccessInternalException("metadata error : ", e);
                }
            }
            metaDataClient.close();
        }
        return jsonNode;
    }

    public JsonNode selectUnitbyId(JsonNode jsonQuery, String idUnit) throws InvalidParseOperationException, AccessInternalExecutionException, MetaDataNotFoundException {
        RequestParserMultiple parser = RequestParserHelper.getParser((JsonNode)jsonQuery.deepCopy());
        parser.getRequest().reset();
        if (!(parser instanceof SelectParserMultiple)) {
            throw new InvalidParseOperationException(NOT_A_SELECT_OPERATION);
        }
        return this.selectMetadataDocumentById(jsonQuery, idUnit, DataCategory.UNIT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonNode selectMetadataDocumentById(JsonNode jsonQuery, String idDocument, DataCategory dataCategory) throws InvalidParseOperationException, AccessInternalExecutionException, MetaDataNotFoundException {
        ParametersChecker.checkParameter((String)DATA_CATEGORY, (Object[])new Object[]{dataCategory});
        ParametersChecker.checkParameter((String)ID_DOC_EMPTY, (String[])new String[]{idDocument});
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            switch (dataCategory) {
                case UNIT: {
                    JsonNode jsonNode = metaDataClient.selectUnitbyId(jsonQuery, idDocument);
                    return jsonNode;
                }
                case OBJECTGROUP: {
                    JsonNode jsonNode = metaDataClient.selectObjectGrouptbyId(jsonQuery, idDocument);
                    return jsonNode;
                }
                default: {
                    throw new IllegalArgumentException(UNSUPPORTED_CATEGORY + String.valueOf(dataCategory));
                }
            }
        }
        catch (MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | MetadataInvalidSelectException | ProcessingException e) {
            throw new AccessInternalExecutionException(e);
        }
    }

    private JsonNode selectMetadataRawDocumentById(String idDocument, DataCategory dataCategory) throws AccessInternalExecutionException {
        JsonNode jsonResponse;
        block13: {
            ParametersChecker.checkParameter((String)DATA_CATEGORY, (Object[])new Object[]{dataCategory});
            ParametersChecker.checkParameter((String)ID_DOC_EMPTY, (String[])new String[]{idDocument});
            try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
                RequestResponse requestResponse = switch (dataCategory) {
                    case DataCategory.UNIT -> metaDataClient.getUnitByIdRaw(idDocument);
                    case DataCategory.OBJECTGROUP -> metaDataClient.getObjectGroupByIdRaw(idDocument);
                    default -> throw new IllegalArgumentException(UNSUPPORTED_CATEGORY + String.valueOf(dataCategory));
                };
                if (requestResponse.isOk()) {
                    jsonResponse = requestResponse.toJsonNode();
                    break block13;
                }
                throw new ProcessingException("Document not found");
            }
            catch (VitamClientException e) {
                LOGGER.error((Throwable)e);
                throw new AccessInternalExecutionException((Throwable)e);
            }
        }
        return jsonResponse;
    }

    public JsonNode selectObjectGroupById(JsonNode jsonQuery, String idObjectGroup) throws InvalidParseOperationException, AccessInternalExecutionException, MetaDataNotFoundException {
        RequestParserMultiple parser = RequestParserHelper.getParser((JsonNode)jsonQuery.deepCopy());
        parser.getRequest().reset();
        if (!(parser instanceof SelectParserMultiple)) {
            throw new InvalidParseOperationException(NOT_A_SELECT_OPERATION);
        }
        return this.selectMetadataDocumentById(jsonQuery, idObjectGroup, DataCategory.OBJECTGROUP);
    }

    private VersionsModel getObjectVersionsModel(String idObjectGroup, String qualifier, int version) throws InvalidParseOperationException, AccessInternalExecutionException, MetaDataNotFoundException {
        ParametersChecker.checkParameter((String)"ObjectGroup id should be filled", (String[])new String[]{idObjectGroup});
        ParametersChecker.checkParameter((String)"You must specify a valid object qualifier", (String[])new String[]{qualifier});
        Integer tenantId = ParameterHelper.getTenantParameter();
        ParametersChecker.checkParameter((String)"You must specify a valid tenant", (Object[])new Object[]{tenantId});
        ParametersChecker.checkValue((String)"version", (long)version, (long)0L);
        SelectMultiQuery request = new SelectMultiQuery();
        request.addRoots(new String[]{idObjectGroup});
        request.addUsedProjection(new String[]{"#qualifiers.versions", "#qualifiers.qualifier"});
        JsonNode jsonResponse = this.selectObjectGroupById((JsonNode)request.getFinalSelect(), idObjectGroup);
        if (jsonResponse == null) {
            throw new AccessInternalExecutionException("Null json response node from metadata");
        }
        ObjectGroupResponse objectGroupResponse = (ObjectGroupResponse)JsonHandler.getFromJsonNode((JsonNode)jsonResponse.get(RESULTS), ObjectGroupResponse.class);
        if (objectGroupResponse.getQualifiers() != null) {
            String dataObjectVersion = qualifier + "_" + version;
            for (QualifiersModel qualifiersResponse : objectGroupResponse.getQualifiers()) {
                if (qualifiersResponse.getQualifier() != null && qualifiersResponse.getQualifier().contains("_")) {
                    qualifiersResponse.setQualifier(qualifiersResponse.getQualifier().split("_")[0]);
                }
                if (!qualifier.equals(qualifiersResponse.getQualifier())) continue;
                for (VersionsModel versionResponse : qualifiersResponse.getVersions()) {
                    if (!dataObjectVersion.equals(versionResponse.getDataObjectVersion())) continue;
                    return versionResponse;
                }
            }
        }
        return null;
    }

    public Response getOneObjectFromObjectGroup(String idObjectGroup, String qualifier, int version, String idUnit) throws StorageNotFoundException, AccessInternalExecutionException, MetaDataNotFoundException, InvalidParseOperationException, AccessInternalUnavailableDataFromAsyncOfferException {
        VersionsModel versionsModel = this.getObjectVersionsModel(idObjectGroup, qualifier, version);
        return this.getObject(idUnit, versionsModel, version);
    }

    /*
     * Exception decompiling
     */
    public Response getAccessLog(JsonNode params) throws AccessInternalExecutionException, StorageNotFoundException, ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void zipWorkspace(WorkspaceClient workspaceClient, String outputFile, String containerName, List<String> inputFiles) throws ContentAddressableStorageException {
        if (!workspaceClient.isExistingContainer(containerName)) {
            LOGGER.error(containerName + " does not exist");
            throw new ContentAddressableStorageAlreadyExistException(containerName + " does not exist");
        }
        CompressInformation compressInformation = new CompressInformation();
        compressInformation.setFiles(inputFiles);
        compressInformation.setOutputFile(outputFile);
        compressInformation.setOutputContainer(containerName);
        workspaceClient.compress(containerName, compressInformation);
    }

    private Response getAccessLogFile(String accessLogId) throws StorageNotFoundException, AccessInternalExecutionException {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block8: {
            StorageClient storageClient = this.storageClientFactory.getClient();
            try {
                Response response = storageClient.getContainerAsync(VitamConfiguration.getDefaultStrategy(), accessLogId, DataCategory.STORAGEACCESSLOG, AccessLogUtils.getNoLogAccessLog());
                HashMap headers = new HashMap();
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response, Response.Status.OK, headers);
                if (storageClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (storageClient != null) {
                        try {
                            storageClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException e) {
                    throw new AccessInternalExecutionException(e);
                }
            }
            storageClient.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    public void checkClassificationLevel(JsonNode query) throws InvalidParseOperationException {
        String classificationFieldName = VitamFieldsHelper.management() + ".ClassificationRule.ClassificationLevel";
        JsonNode classificationLevel = DslParserHelper.getValueForUpdateDsl(query, classificationFieldName);
        if (classificationLevel == null) {
            return;
        }
        if (!classificationLevel.isTextual()) {
            throw new IllegalArgumentException("Illegal value for Classification Level. Expected string");
        }
        String classificationLevelValue = classificationLevel.asText();
        if (!ClassificationLevelUtil.checkClassificationLevel((String)classificationLevelValue)) {
            throw new IllegalArgumentException("Classification Level is not in the list of allowed values");
        }
    }

    public ObjectGroupResponse findOneObjectGroupByPersistentId(String persistentId, @Nullable JsonNode query) throws MetaDataNotFoundException, AccessUnauthorizedException {
        SelectMultiQuery selectMultiQuery = PersistentIdentifierMultiQueryFactory.createSelectMultiQuery(PurgedCollectionType.OBJECT, persistentId, query);
        ObjectGroupResponse objectGroupResponse = new ObjectGroupMultiQuerySearchService().search(selectMultiQuery).stream().findFirst().orElseThrow(() -> new MetaDataNotFoundException(String.format("No object group found with this persistent identifier: %s", persistentId)));
        return objectGroupResponse;
    }

    public Response getObjectByPersistentIdentifier(String persistentIdentifier) throws MetaDataNotFoundException, StorageNotFoundException, AccessInternalException, AccessUnauthorizedException {
        ObjectGroupResponse objectGroupResponse = this.findOneObjectGroupByPersistentId(persistentIdentifier, null);
        VersionsModel versionsModel = PersistentIdentifierHelper.findVersion(objectGroupResponse, persistentIdentifier).orElseThrow();
        this.versionUsagePermissionValidator.validate(versionsModel);
        List archiveUnitIds = objectGroupResponse.getUp();
        return this.getObject(this.findFirstAccessibleArchiveUnitId(archiveUnitIds), versionsModel);
    }

    protected String findFirstAccessibleArchiveUnitId(List<String> archiveUnitIds) throws AccessInternalException, MetaDataNotFoundException {
        if (archiveUnitIds == null || archiveUnitIds.isEmpty()) {
            throw new IllegalArgumentException("Archive unit ID list cannot be empty.");
        }
        Select select = new Select();
        try {
            InQuery inQuery = QueryHelper.in((String)VitamFieldsHelper.id(), (String[])archiveUnitIds.toArray(new String[0]));
            select.setQuery((Query)inQuery);
            select.addProjection(JsonHandler.createObjectNode().set(BuilderToken.PROJECTION.FIELDS.exactToken(), (JsonNode)JsonHandler.createObjectNode().put(BuilderToken.PROJECTIONARGS.ID.exactToken(), 1)));
            JsonNode unitResult = this.selectUnit(AccessContractRestrictionHelper.applyAccessContractRestrictionForUnitForSelect((JsonNode)select.getFinalSelect(), (AccessContractModel)VitamThreadUtils.getVitamSession().getContract()));
            if (unitResult.get(RESULTS).isNull() || unitResult.get(RESULTS).isEmpty()) {
                throw new MetaDataNotFoundException("No results found for the provided archive unit IDs.");
            }
            JsonNode unit = unitResult.get(RESULTS).get(0);
            return unit.get(ID).asText();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new AccessInternalException("Error creating or parsing query: " + e.getMessage(), e);
        }
    }

    private VitamAsyncInputStreamResponse getObject(String archiveUnitId, VersionsModel versionsModel) throws AccessInternalUnavailableDataFromAsyncOfferException, StorageNotFoundException, AccessInternalExecutionException {
        return this.getObject(archiveUnitId, versionsModel, versionsModel.getVersion());
    }

    private VitamAsyncInputStreamResponse getObject(String archiveUnitId, VersionsModel versionsModel, Integer version) throws AccessInternalUnavailableDataFromAsyncOfferException, AccessInternalExecutionException, StorageNotFoundException {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block14: {
            String qualifier = null;
            String strategyId = null;
            String mimetype = "application/octet-stream";
            String filename = null;
            String objectId = null;
            Long size = null;
            if (versionsModel != null) {
                qualifier = versionsModel.getQualifier().getName();
                if (versionsModel.getFormatIdentification() != null && !Strings.isNullOrEmpty((String)versionsModel.getFormatIdentification().getMimeType())) {
                    mimetype = versionsModel.getFormatIdentification().getMimeType();
                }
                if (versionsModel.getFileInfoModel() != null && !Strings.isNullOrEmpty((String)versionsModel.getFileInfoModel().getFilename())) {
                    filename = versionsModel.getFileInfoModel().getFilename();
                }
                objectId = versionsModel.getId();
                size = versionsModel.getSize();
                if (versionsModel.getStorage() != null) {
                    strategyId = versionsModel.getStorage().getStrategyId();
                }
            }
            if (Strings.isNullOrEmpty(filename)) {
                filename = objectId;
            }
            AccessLogInfoModel logInfo = AccessLogUtils.getInfoForAccessLog((String)qualifier, (Integer)version, (VitamSession)VitamThreadUtils.getVitamSession(), size, (String)archiveUnitId);
            StorageClient storageClient = this.storageClientFactory.getClient();
            try {
                Response response = storageClient.getContainerAsync(strategyId, objectId, DataCategory.OBJECT, logInfo);
                HashMap<String, Object> headers = new HashMap<String, Object>();
                headers.put("Content-Type", mimetype);
                headers.put("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                headers.put("X-Qualifier", qualifier);
                headers.put("X-Version", Integer.toString(version));
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response, Response.Status.OK, headers);
                if (storageClient == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (storageClient != null) {
                        try {
                            storageClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageUnavailableDataFromAsyncOfferClientException e) {
                    throw new AccessInternalUnavailableDataFromAsyncOfferException("Could not download object from async offer. Access request required", (Throwable)e);
                }
                catch (StorageServerClientException e) {
                    throw new AccessInternalExecutionException((Throwable)e);
                }
            }
            storageClient.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<AccessRequestReference> createObjectAccessRequestIfRequired(String idObjectGroup, String qualifier, int version) throws MetaDataNotFoundException, InvalidParseOperationException, AccessInternalExecutionException {
        VersionsModel objectVersion = this.getObjectVersionsModel(idObjectGroup, qualifier, version);
        if (objectVersion == null) {
            throw new MetaDataNotFoundException("No such object with usage '" + qualifier + "' and version " + version);
        }
        if (objectVersion.getId() == null) {
            throw new MetaDataNotFoundException("Physical objects cannot be downloaded (" + objectVersion.getDataObjectVersion() + ")");
        }
        if (objectVersion.getStorage() == null) throw new IllegalStateException("Object with usage '" + qualifier + "' and version " + version + " has no storage strategy information.");
        if (objectVersion.getStorage().getStrategyId() == null) {
            throw new IllegalStateException("Object with usage '" + qualifier + "' and version " + version + " has no storage strategy information.");
        }
        String objectId = objectVersion.getId();
        String strategyId = objectVersion.getStorage().getStrategyId();
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            Optional optionalAccessRequest = storageClient.createAccessRequestIfRequired(strategyId, null, DataCategory.OBJECT, List.of(objectId));
            if (optionalAccessRequest.isPresent()) {
                LOGGER.debug("Access Request Id '" + (String)optionalAccessRequest.get() + "' created for object " + objectId + " with version " + objectVersion.getDataObjectVersion() + " of object group id " + idObjectGroup);
                Optional<AccessRequestReference> optional2 = Optional.of(new AccessRequestReference((String)optionalAccessRequest.get(), strategyId));
                return optional2;
            }
            LOGGER.debug("No access Request Id required for accessing object " + objectId + " with version " + objectVersion.getDataObjectVersion() + " of object group id " + idObjectGroup);
            Optional<AccessRequestReference> optional = Optional.empty();
            return optional;
        }
        catch (StorageServerClientException e) {
            throw new AccessInternalExecutionException("Could not create access request for strategy " + strategyId + " and object " + objectId, (Throwable)e);
        }
    }

    public List<StatusByAccessRequest> checkAccessRequestStatuses(List<AccessRequestReference> accessRequestReferences) throws AccessInternalExecutionException, AccessInternalIllegalOperationException {
        ArrayList<StatusByAccessRequest> arrayList;
        block13: {
            int distinctAccessRequestIds = accessRequestReferences.stream().map(AccessRequestReference::getAccessRequestId).collect(Collectors.toSet()).size();
            if (accessRequestReferences.size() != distinctAccessRequestIds) {
                throw new IllegalArgumentException("Duplicate access request ids " + String.valueOf(accessRequestReferences));
            }
            ArrayListValuedHashMap accessRequestIdsByStrategyId = new ArrayListValuedHashMap();
            accessRequestReferences.forEach(objectAccessRequest -> accessRequestIdsByStrategyId.put((Object)objectAccessRequest.getStorageStrategyId(), (Object)objectAccessRequest.getAccessRequestId()));
            StorageClient storageClient = this.storageClientFactory.getClient();
            try {
                ArrayList<StatusByAccessRequest> results = new ArrayList<StatusByAccessRequest>();
                for (String strategyId : accessRequestIdsByStrategyId.keySet()) {
                    for (List accessRequestIdBulk : Lists.partition((List)accessRequestIdsByStrategyId.get((Object)strategyId), (int)VitamConfiguration.getBatchSize())) {
                        Map accessRequestStatuses = storageClient.checkAccessRequestStatuses(strategyId, null, accessRequestIdBulk, false);
                        for (Map.Entry entry : accessRequestStatuses.entrySet()) {
                            results.add(new StatusByAccessRequest(new AccessRequestReference((String)entry.getKey(), strategyId), (AccessRequestStatus)entry.getValue()));
                        }
                    }
                }
                arrayList = results;
                if (storageClient == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (storageClient != null) {
                        try {
                            storageClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageServerClientException e) {
                    throw new AccessInternalExecutionException("A technical error occurred while checking access request statuses", (Throwable)e);
                }
                catch (StorageIllegalOperationClientException e) {
                    throw new AccessInternalIllegalOperationException("Illegal Access Request operation on synchronous offer", (Throwable)e);
                }
            }
            storageClient.close();
        }
        return arrayList;
    }

    public void removeAccessRequest(String strategyId, String accessRequestId) throws AccessInternalExecutionException, AccessInternalIllegalOperationException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            storageClient.removeAccessRequest(strategyId, null, accessRequestId, false);
        }
        catch (StorageServerClientException e) {
            throw new AccessInternalExecutionException("A technical error occurred while removing access request id '" + accessRequestId + "' for strategy '" + strategyId + "'", (Throwable)e);
        }
        catch (StorageIllegalOperationClientException e) {
            throw new AccessInternalIllegalOperationException("Illegal Access Request operation on synchronous offer", (Throwable)e);
        }
    }

    public Response streamUnits(JsonNode query) throws AccessInternalExecutionException, MetadataScrollLimitExceededException, MetadataScrollThresholdExceededException {
        Response response;
        block8: {
            MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
            try {
                response = metaDataClient.streamUnits(query);
                if (metaDataClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MetaDataClientServerException e) {
                    throw new AccessInternalExecutionException((Throwable)e);
                }
            }
            metaDataClient.close();
        }
        return response;
    }

    public Response streamObjects(JsonNode query) throws AccessInternalExecutionException, MetadataScrollLimitExceededException, MetadataScrollThresholdExceededException {
        Response response;
        block8: {
            MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
            try {
                response = metaDataClient.streamObjects(query);
                if (metaDataClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MetaDataClientServerException e) {
                    throw new AccessInternalExecutionException((Throwable)e);
                }
            }
            metaDataClient.close();
        }
        return response;
    }

    public Response getObjectByUnitPersistentIdentifier(String persistentIdentifier, String qualifier, Integer version) throws StorageNotFoundException, MetaDataNotFoundException, AccessInternalException {
        try {
            SelectMultiQuery selectMultiQuery = new SelectParserMultiple().getRequest();
            selectMultiQuery.addQueries(new Query[]{QueryHelper.and().add(new Query[]{QueryHelper.eq((String)"PersistentIdentifier.PersistentIdentifierContent", (String)persistentIdentifier), QueryHelper.exists((String)OBJECT_TAG)})});
            selectMultiQuery.addUsedProjection(new String[]{VitamFieldsHelper.id(), OBJECT_TAG});
            JsonNode unitResult = this.selectUnit(AccessContractRestrictionHelper.applyAccessContractRestrictionForUnitForSelect((JsonNode)selectMultiQuery.getFinalSelect(), (AccessContractModel)VitamThreadUtils.getVitamSession().getContract()));
            if (unitResult.get(RESULTS).isNull() || unitResult.get(RESULTS).isEmpty()) {
                throw new MetaDataNotFoundException("No unit found for the persistent identifier provided");
            }
            JsonNode unit = unitResult.get(RESULTS).get(0);
            String objectGroupId = unit.get(OBJECT_TAG).textValue();
            SelectMultiQuery request = new SelectMultiQuery();
            request.addRoots(new String[]{objectGroupId});
            request.addUsedProjection(new String[]{"#qualifiers.versions", "#qualifiers.qualifier"});
            JsonNode objectGroupResponse = this.selectObjectGroupById((JsonNode)request.getFinalSelect(), objectGroupId);
            ObjectGroupResponse objectGroup = (ObjectGroupResponse)JsonHandler.getFromJsonNode((JsonNode)objectGroupResponse.get(RESULTS), ObjectGroupResponse.class);
            if (objectGroup == null) {
                throw new MetaDataNotFoundException("No object group found for the unit persistent identifier provided");
            }
            VersionsModel versionFound = objectGroup.getQualifiers().stream().filter(qualifiersModel -> qualifiersModel.getQualifier().equals(qualifier)).map(QualifiersModel::getVersions).flatMap(Collection::stream).filter(versionsModel -> versionsModel.getDataObjectVersion().startsWith(qualifier)).filter(versionsModel -> version == null || versionsModel.getDataObjectVersion().endsWith(version.toString())).findFirst().orElseThrow(() -> new MetaDataNotFoundException(String.format("Object group not contains specified version %d for qualifier %s", version, qualifier)));
            this.versionUsagePermissionValidator.validate(versionFound);
            Integer finalVersion = Optional.ofNullable(version).orElse(this.findLatestVersionByQualifier(objectGroup, qualifier));
            return this.getOneObjectFromObjectGroup(objectGroupId, qualifier, finalVersion, unit.get(VitamFieldsHelper.id()).asText());
        }
        catch (AccessInternalExecutionException | AccessInternalUnavailableDataFromAsyncOfferException | InvalidCreateOperationException | AccessUnauthorizedException | InvalidParseOperationException e) {
            throw new AccessInternalException("Error creating or parsing query: " + e.getMessage(), e);
        }
    }

    public JsonNode updateUnitById(JsonNode queryJson, String idUnit, String requestId) throws MetaDataNotFoundException, IllegalArgumentException, InvalidParseOperationException, AccessInternalExecutionException, UpdatePermissionException, AccessInternalRuleExecutionException {
        GUID idRequest;
        GUID idGUID;
        ParametersChecker.checkParameter((String)ID_CHECK_FAILED, (String[])new String[]{idUnit});
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        boolean globalStep = true;
        boolean stepCheckPermission = true;
        boolean stepCheckRules = true;
        boolean stepMetadataUpdate = true;
        boolean stepStorageUpdate = true;
        boolean stepLFCCommit = true;
        try {
            idGUID = GUIDReader.getGUID((String)idUnit);
            idRequest = GUIDReader.getGUID((String)requestId);
        }
        catch (InvalidGuidOperationException e) {
            LOGGER.error("idUnit is not a valid GUID - metadata not found execution error", (Throwable)e);
            throw new MetaDataNotFoundException("idUnit is not a valid GUID - metadata not found execution error", (Throwable)e);
        }
        RequestParserMultiple parser = RequestParserHelper.getParser((JsonNode)queryJson);
        if (!(parser instanceof UpdateParserMultiple)) {
            parser.getRequest().reset();
            throw new IllegalArgumentException("Request is not an update operation");
        }
        GUID updateOpGuidStart = idRequest;
        Boolean requestUpdateManagment = this.updateContainsManagmentFields(queryJson);
        String masterStpOperation = requestUpdateManagment != false ? STP_UPDATE_UNIT : STP_UPDATE_UNIT_DESC;
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
             LogbookOperationsClient logbookOperationClient = this.logbookOperationsClientFactory.getClient();
             LogbookLifeCyclesClient logbookLifeCycleClient = this.logbookLifeCyclesClientFactory.getClient();){
            LogbookOperationParameters logbookOpStpParamStart = this.getLogbookOperationUpdateUnitParameters(updateOpGuidStart, updateOpGuidStart, StatusCode.STARTED, VitamLogbookMessages.getCodeOp((String)masterStpOperation, (StatusCode)StatusCode.STARTED), idRequest, masterStpOperation, true);
            logbookOpStpParamStart.putParameterValue(LogbookParameterName.objectIdentifier, idUnit);
            logbookOpStpParamStart.putParameterValue(LogbookParameterName.outcomeDetail, "STP_UPDATE_UNIT." + String.valueOf(StatusCode.STARTED));
            logbookOperationClient.create(new LogbookOperationParameters[]{logbookOpStpParamStart});
            globalStep = false;
            stepCheckPermission = false;
            this.checkPermissions(requestUpdateManagment);
            stepCheckPermission = true;
            if (requestUpdateManagment.booleanValue()) {
                stepCheckRules = false;
                this.checkAndUpdateRuleQuery((UpdateParserMultiple)parser);
                stepCheckRules = true;
            }
            try {
                queryJson = ((UpdateParserMultiple)parser).getRequest().addActions(new Action[]{UpdateActionHelper.push((String)VitamFieldsHelper.operations(), (String[])new String[]{updateOpGuidStart.toString()})}).getFinalUpdate();
            }
            catch (InvalidCreateOperationException e) {
                LOGGER.error((Throwable)e);
                throw new AccessInternalExecutionException(ERROR_ADD_CONDITION, (Throwable)e);
            }
            stepMetadataUpdate = false;
            jsonNode = metaDataClient.updateUnitById(queryJson, idUnit);
            stepMetadataUpdate = true;
            LogbookLifeCycleUnitParameters logbookLCParamEnd = this.getLogbookLifeCycleUpdateUnitParameters(updateOpGuidStart, StatusCode.OK, idGUID, UNIT_METADATA_UPDATE);
            logbookLCParamEnd.putParameterValue(LogbookParameterName.eventDetailData, this.getDiffMessageFor((JsonNode)jsonNode, idUnit));
            stepLFCCommit = false;
            logbookLifeCycleClient.update((LogbookLifeCycleParameters)logbookLCParamEnd, LifeCycleStatusCode.LIFE_CYCLE_COMMITTED);
            stepLFCCommit = true;
            stepStorageUpdate = false;
            this.replaceStoredUnitMetadata(idUnit, requestId);
            stepStorageUpdate = true;
            globalStep = true;
            this.finalizeStepOperation(updateOpGuidStart, idRequest, idUnit, globalStep, stepCheckPermission, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, null, masterStpOperation, requestUpdateManagment);
        }
        catch (InvalidParseOperationException ipoe) {
            ObjectNode evDetData = JsonHandler.createObjectNode();
            evDetData.put(ERROR_CODE, ipoe.getMessage());
            this.rollBackLogbook(updateOpGuidStart, idRequest, idUnit, globalStep, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, stepCheckPermission, JsonHandler.unprettyPrint((Object)evDetData), masterStpOperation, requestUpdateManagment);
            LOGGER.error(PARSING_ERROR, (Throwable)ipoe);
            throw ipoe;
        }
        catch (IllegalArgumentException iae) {
            this.rollBackLogbook(updateOpGuidStart, idRequest, idUnit, globalStep, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, stepCheckPermission, null, masterStpOperation, requestUpdateManagment);
            LOGGER.error(ILLEGAL_ARGUMENT, (Throwable)iae);
            throw iae;
        }
        catch (MetaDataNotFoundException mdnfe) {
            ObjectNode evDetData = JsonHandler.createObjectNode();
            evDetData.put(ERROR_CODE, DT_NO_EXTISTING);
            this.rollBackLogbook(updateOpGuidStart, idRequest, idUnit, globalStep, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, stepCheckPermission, JsonHandler.unprettyPrint((Object)evDetData), masterStpOperation, requestUpdateManagment);
            LOGGER.error(METADATA_NOT_FOUND_ERROR, (Throwable)mdnfe);
            throw mdnfe;
        }
        catch (MetaDataDocumentSizeException mddse) {
            this.rollBackLogbook(updateOpGuidStart, idRequest, idUnit, globalStep, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, stepCheckPermission, null, masterStpOperation, requestUpdateManagment);
            LOGGER.error(METADATA_DOCUMENT_SIZE_ERROR, (Throwable)mddse);
            throw new AccessInternalExecutionException((Throwable)mddse);
        }
        catch (LogbookClientServerException lcse) {
            this.rollBackLogbook(updateOpGuidStart, idRequest, idUnit, globalStep, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, stepCheckPermission, null, masterStpOperation, requestUpdateManagment);
            LOGGER.error(DOCUMENT_CLIENT_SERVER_ERROR, (Throwable)lcse);
            throw new AccessInternalExecutionException((Throwable)lcse);
        }
        catch (MetaDataExecutionException mdee) {
            this.rollBackLogbook(updateOpGuidStart, idRequest, idUnit, globalStep, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, stepCheckPermission, null, masterStpOperation, requestUpdateManagment);
            LOGGER.error(METADATA_EXECUTION_EXECUTION_ERROR, (Throwable)mdee);
            throw new AccessInternalExecutionException((Throwable)mdee);
        }
        catch (LogbookClientNotFoundException lcnfe) {
            this.rollBackLogbook(updateOpGuidStart, idRequest, idUnit, globalStep, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, stepCheckPermission, null, masterStpOperation, requestUpdateManagment);
            LOGGER.error(LOGBOOK_CLIENT_NOT_FOUND_ERROR, (Throwable)lcnfe);
            throw new AccessInternalExecutionException((Throwable)lcnfe);
        }
        catch (LogbookClientBadRequestException lcbre) {
            this.rollBackLogbook(updateOpGuidStart, idRequest, idUnit, globalStep, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, stepCheckPermission, null, masterStpOperation, requestUpdateManagment);
            LOGGER.error(LOGBOOK_CLIENT_BAD_REQUEST_ERROR, (Throwable)lcbre);
            throw new AccessInternalExecutionException((Throwable)lcbre);
        }
        catch (LogbookClientAlreadyExistsException e) {
            LOGGER.error(LOGBOOK_OPERATION_ALREADY_EXISTS, (Throwable)e);
            throw new AccessInternalExecutionException((Throwable)e);
        }
        catch (MetaDataClientServerException e) {
            LOGGER.error(METADATA_INTERNAL_SERVER_ERROR, (Throwable)e);
            this.rollBackLogbook(updateOpGuidStart, idRequest, idUnit, globalStep, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, stepCheckPermission, null, masterStpOperation, requestUpdateManagment);
            throw new AccessInternalExecutionException((Throwable)e);
        }
        catch (StorageClientException e) {
            try {
                this.finalizeStepOperation(updateOpGuidStart, idRequest, idUnit, globalStep, stepCheckPermission, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, null, masterStpOperation, requestUpdateManagment);
            }
            catch (LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException e1) {
                LOGGER.error(STORAGE_SERVER_EXCEPTION, e1);
            }
            LOGGER.error(STORAGE_SERVER_EXCEPTION, (Throwable)e);
            throw new AccessInternalExecutionException(STORAGE_SERVER_EXCEPTION, (Throwable)e);
        }
        catch (ContentAddressableStorageException e) {
            this.rollBackLogbook(updateOpGuidStart, idRequest, idUnit, globalStep, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, stepCheckPermission, null, masterStpOperation, requestUpdateManagment);
            LOGGER.error(WORKSPACE_SERVER_EXCEPTION, (Throwable)e);
        }
        catch (AccessInternalRuleExecutionException e) {
            ObjectNode evDetData = JsonHandler.createObjectNode();
            evDetData.put(ERROR_CODE, e.getMessage());
            this.rollBackLogbook(updateOpGuidStart, idRequest, idUnit, globalStep, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, stepCheckPermission, JsonHandler.unprettyPrint((Object)evDetData), masterStpOperation, requestUpdateManagment);
            LOGGER.error(ERROR_CHECK_RULES, (Throwable)e);
            throw e;
        }
        catch (UpdatePermissionException e) {
            ObjectNode evDetData = JsonHandler.createObjectNode();
            evDetData.put(ERROR_CODE, e.getMessage());
            this.rollBackLogbook(updateOpGuidStart, idRequest, idUnit, globalStep, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, stepCheckPermission, JsonHandler.unprettyPrint((Object)evDetData), masterStpOperation, requestUpdateManagment);
            LOGGER.error(ERROR_CHECK_PERMISSIONS, (Throwable)e);
            throw e;
        }
        catch (AccessInternalException e) {
            LOGGER.error(ARCHIVE_UNIT_NOT_FOUND, (Throwable)e);
            throw new AccessInternalExecutionException((Throwable)e);
        }
        return jsonNode;
    }

    private void checkPermissions(Boolean managementUpdate) throws UpdatePermissionException {
        AccessContractModel accessContract = VitamThreadUtils.getVitamSession().getContract();
        if (!accessContract.getWritingPermission().booleanValue()) {
            throw new UpdatePermissionException(VitamCode.UPDATE_UNIT_PERMISSION.name());
        }
        if (accessContract.getWritingRestrictedDesc() == null) {
            throw new UpdatePermissionException(VitamCode.UPDATE_UNIT_DESC_PERMISSION.name());
        }
        if (managementUpdate.booleanValue() && BooleanUtils.isTrue((Boolean)accessContract.getWritingRestrictedDesc())) {
            throw new UpdatePermissionException(VitamCode.UPDATE_UNIT_DESC_PERMISSION.name());
        }
    }

    private boolean updateContainsManagmentFields(JsonNode queryDsl) {
        ArrayNode actions = (ArrayNode)queryDsl.get("$action");
        for (JsonNode node : actions) {
            JsonNode fieldNode = node.get("$set");
            if (fieldNode == null) {
                fieldNode = node.get("$unset");
            }
            if (fieldNode == null) {
                LOGGER.debug("Ignored field: " + JsonHandler.unprettyPrint((Object)node));
                continue;
            }
            Iterator fieldNames = fieldNode.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                if (!"ArchiveUnitProfile".equals(fieldName) && !fieldName.startsWith(MANAGEMENT_KEY)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceStoredUnitMetadata(String idUnit, String requestId) throws ContentAddressableStorageException, StorageClientException, AccessInternalException {
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            String fileName = idUnit + JSON;
            JsonNode unitWithLfc = this.getUnitRawWithLfc(idUnit);
            workspaceClient.createContainer(requestId);
            InputStream inputStream = CanonicalJsonFormatter.serialize((JsonNode)unitWithLfc);
            workspaceClient.putObject(requestId, "Units" + File.separator + fileName, inputStream);
            String strategyId = MetadataDocumentHelper.getStrategyIdFromRawUnitOrGot((JsonNode)MetadataStorageHelper.getUnitFromUnitWithLFC((JsonNode)unitWithLfc));
            this.storeMetaDataUnit(strategyId, new ObjectDescription(DataCategory.UNIT, requestId, fileName, "Units" + File.separator + fileName));
        }
        finally {
            this.cleanWorkspace(requestId);
        }
    }

    private JsonNode getUnitRawWithLfc(String idUnit) throws AccessInternalException {
        JsonNode jsonResponse = this.selectMetadataRawDocumentById(idUnit, DataCategory.UNIT);
        JsonNode unit = this.extractNodeFromResponse(jsonResponse, ARCHIVE_UNIT_NOT_FOUND);
        MetadataDocumentHelper.removeComputedFieldsFromUnit((JsonNode)unit);
        JsonNode lfc = this.getRawUnitLifeCycleById(idUnit);
        return MetadataStorageHelper.getUnitWithLFC((JsonNode)unit, (JsonNode)lfc);
    }

    private JsonNode getRawUnitLifeCycleById(String idDocument) throws AccessInternalExecutionException {
        JsonNode jsonNode;
        block8: {
            ParametersChecker.checkParameter((String)ID_DOC_EMPTY, (String[])new String[]{idDocument});
            LogbookLifeCyclesClient logbookClient = this.logbookLifeCyclesClientFactory.getClient();
            try {
                jsonNode = logbookClient.getRawUnitLifeCycleById(idDocument);
                if (logbookClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (logbookClient != null) {
                        try {
                            logbookClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | LogbookClientException e) {
                    throw new AccessInternalExecutionException(e);
                }
            }
            logbookClient.close();
        }
        return jsonNode;
    }

    private JsonNode extractNodeFromResponse(JsonNode jsonResponse, String error) throws AccessInternalException {
        if (jsonResponse == null) {
            LOGGER.error(error);
            throw new AccessInternalException(error);
        }
        JsonNode jsonNode = jsonResponse.get(RESULTS);
        if (jsonNode == null || jsonNode.size() == 0) {
            LOGGER.error(error);
            throw new AccessInternalException(error);
        }
        return jsonNode.get(0);
    }

    private void storeMetaDataUnit(String strategyId, ObjectDescription description) throws StorageClientException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            storageClient.storeFileFromWorkspace(strategyId, description.getType(), description.getObjectName(), description);
        }
    }

    private void finalizeStepOperation(GUID updateOpGuidStart, GUID idRequest, String idUnit, boolean globalStep, boolean stepCheckPermission, boolean stepMetadataUpdate, boolean stepStorageUpdate, boolean stepCheckRules, boolean stepLFCCommit, String evDetData, String masterOperation, boolean isManagementUpdate) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            LogbookOperationParameters logbookOpStpParamEnd;
            GUID parentEventGuid = GUIDFactory.newEventGUID((GUID)updateOpGuidStart);
            if (!stepCheckPermission) {
                LogbookOperationParameters logbookOpParamEnd = this.getLogbookOperationUpdateUnitParameters(GUIDFactory.newEventGUID((GUID)updateOpGuidStart), updateOpGuidStart, StatusCode.KO, VitamLogbookMessages.getCodeOp((String)UNIT_CHECK_PERMISSION, (StatusCode)StatusCode.KO), idRequest, UNIT_CHECK_PERMISSION, false);
                logbookOpParamEnd.putParameterValue(LogbookParameterName.eventDetailData, evDetData);
                logbookOpParamEnd.putParameterValue(LogbookParameterName.objectIdentifier, idUnit);
                logbookOperationsClient.update(new LogbookOperationParameters[]{logbookOpParamEnd});
            } else {
                LogbookOperationParameters logbookOpParamEnd = this.getLogbookOperationUpdateUnitParameters(GUIDFactory.newEventGUID((GUID)updateOpGuidStart), updateOpGuidStart, StatusCode.OK, VitamLogbookMessages.getCodeOp((String)UNIT_CHECK_PERMISSION, (StatusCode)StatusCode.OK), idRequest, UNIT_CHECK_PERMISSION, false);
                logbookOpParamEnd.putParameterValue(LogbookParameterName.objectIdentifier, idUnit);
                logbookOperationsClient.update(new LogbookOperationParameters[]{logbookOpParamEnd});
                if (!stepCheckRules) {
                    logbookOpParamEnd = this.getLogbookOperationUpdateUnitParameters(GUIDFactory.newEventGUID((GUID)updateOpGuidStart), updateOpGuidStart, StatusCode.KO, VitamLogbookMessages.getCodeOp((String)UNIT_CHECK_RULES, (StatusCode)StatusCode.KO), idRequest, UNIT_CHECK_RULES, false);
                    logbookOpParamEnd.putParameterValue(LogbookParameterName.eventDetailData, evDetData);
                    logbookOpParamEnd.putParameterValue(LogbookParameterName.objectIdentifier, idUnit);
                    logbookOperationsClient.update(new LogbookOperationParameters[]{logbookOpParamEnd});
                } else {
                    if (isManagementUpdate) {
                        logbookOpParamEnd = this.getLogbookOperationUpdateUnitParameters(GUIDFactory.newEventGUID((GUID)updateOpGuidStart), updateOpGuidStart, StatusCode.OK, VitamLogbookMessages.getCodeOp((String)UNIT_CHECK_RULES, (StatusCode)StatusCode.OK), idRequest, UNIT_CHECK_RULES, false);
                        logbookOpParamEnd.putParameterValue(LogbookParameterName.objectIdentifier, idUnit);
                        logbookOperationsClient.update(new LogbookOperationParameters[]{logbookOpParamEnd});
                    }
                    logbookOpParamEnd = this.getLogbookOperationUpdateUnitParameters(GUIDFactory.newEventGUID((GUID)updateOpGuidStart), updateOpGuidStart, StatusCode.OK, VitamLogbookMessages.getCodeOp((String)UNIT_CHECK_DT, (StatusCode)StatusCode.OK), idRequest, UNIT_CHECK_DT, false);
                    logbookOpParamEnd.putParameterValue(LogbookParameterName.objectIdentifier, idUnit);
                    logbookOperationsClient.update(new LogbookOperationParameters[]{logbookOpParamEnd});
                    if (!stepMetadataUpdate) {
                        logbookOpParamEnd = this.getLogbookOperationUpdateUnitParameters(GUIDFactory.newEventGUID((GUID)updateOpGuidStart), updateOpGuidStart, StatusCode.KO, VitamLogbookMessages.getCodeOp((String)UNIT_METADATA_UPDATE, (StatusCode)StatusCode.KO), idRequest, UNIT_METADATA_UPDATE, false);
                        logbookOpParamEnd.putParameterValue(LogbookParameterName.objectIdentifier, idUnit);
                        logbookOpParamEnd.putParameterValue(LogbookParameterName.eventDetailData, evDetData);
                        logbookOperationsClient.update(new LogbookOperationParameters[]{logbookOpParamEnd});
                    } else {
                        logbookOpParamEnd = this.getLogbookOperationUpdateUnitParameters(GUIDFactory.newEventGUID((GUID)updateOpGuidStart), updateOpGuidStart, StatusCode.OK, VitamLogbookMessages.getCodeOp((String)UNIT_METADATA_UPDATE, (StatusCode)StatusCode.OK), idRequest, UNIT_METADATA_UPDATE, false);
                        logbookOpParamEnd.putParameterValue(LogbookParameterName.objectIdentifier, idUnit);
                        logbookOperationsClient.update(new LogbookOperationParameters[]{logbookOpParamEnd});
                        if (!stepLFCCommit) {
                            logbookOpParamEnd = this.getLogbookOperationUpdateUnitParameters(GUIDFactory.newEventGUID((GUID)updateOpGuidStart), updateOpGuidStart, StatusCode.KO, VitamLogbookMessages.getCodeOp((String)COMMIT_LIFE_CYCLE_UNIT, (StatusCode)StatusCode.KO), idRequest, COMMIT_LIFE_CYCLE_UNIT, false);
                            logbookOpParamEnd.putParameterValue(LogbookParameterName.objectIdentifier, idUnit);
                            logbookOperationsClient.update(new LogbookOperationParameters[]{logbookOpParamEnd});
                        } else {
                            logbookOpParamEnd = this.getLogbookOperationUpdateUnitParameters(GUIDFactory.newEventGUID((GUID)updateOpGuidStart), updateOpGuidStart, StatusCode.OK, VitamLogbookMessages.getCodeOp((String)COMMIT_LIFE_CYCLE_UNIT, (StatusCode)StatusCode.OK), idRequest, COMMIT_LIFE_CYCLE_UNIT, false);
                            logbookOpParamEnd.putParameterValue(LogbookParameterName.objectIdentifier, idUnit);
                            logbookOperationsClient.update(new LogbookOperationParameters[]{logbookOpParamEnd});
                            if (!stepStorageUpdate) {
                                logbookOpParamEnd = this.getLogbookOperationUpdateUnitParameters(GUIDFactory.newEventGUID((GUID)updateOpGuidStart), updateOpGuidStart, StatusCode.KO, VitamLogbookMessages.getCodeOp((String)UNIT_METADATA_STORAGE, (StatusCode)StatusCode.KO), idRequest, UNIT_METADATA_STORAGE, false);
                                logbookOpParamEnd.putParameterValue(LogbookParameterName.objectIdentifier, idUnit);
                                logbookOperationsClient.update(new LogbookOperationParameters[]{logbookOpParamEnd});
                            } else {
                                logbookOpParamEnd = this.getLogbookOperationUpdateUnitParameters(GUIDFactory.newEventGUID((GUID)updateOpGuidStart), updateOpGuidStart, StatusCode.OK, VitamLogbookMessages.getCodeOp((String)UNIT_METADATA_STORAGE, (StatusCode)StatusCode.OK), idRequest, UNIT_METADATA_STORAGE, false);
                                logbookOpParamEnd.putParameterValue(LogbookParameterName.objectIdentifier, idUnit);
                                logbookOperationsClient.update(new LogbookOperationParameters[]{logbookOpParamEnd});
                            }
                        }
                    }
                }
            }
            if (!globalStep) {
                logbookOpStpParamEnd = this.getLogbookOperationUpdateUnitParameters(parentEventGuid, updateOpGuidStart, StatusCode.KO, VitamLogbookMessages.getCodeOp((String)masterOperation, (StatusCode)StatusCode.KO), idRequest, masterOperation, false);
                logbookOpStpParamEnd.putParameterValue(LogbookParameterName.outcomeDetail, "STP_UPDATE_UNIT." + String.valueOf(StatusCode.KO));
            } else {
                logbookOpStpParamEnd = this.getLogbookOperationUpdateUnitParameters(parentEventGuid, updateOpGuidStart, StatusCode.OK, VitamLogbookMessages.getCodeOp((String)masterOperation, (StatusCode)StatusCode.OK), idRequest, masterOperation, false);
                logbookOpStpParamEnd.putParameterValue(LogbookParameterName.outcomeDetail, "STP_UPDATE_UNIT." + String.valueOf(StatusCode.OK));
            }
            logbookOpStpParamEnd.putParameterValue(LogbookParameterName.objectIdentifier, idUnit);
            logbookOperationsClient.update(new LogbookOperationParameters[]{logbookOpStpParamEnd});
        }
    }

    private void rollBackLogbook(GUID updateOpGuidStart, GUID idRequest, String idUnit, boolean globalStep, boolean stepMetadataUpdate, boolean stepStorageUpdate, boolean stepCheckRules, boolean stepLFCCommit, boolean stepCheckPermission, String evDetData, String masterOperation, boolean isManagementUpdate) {
        try (LogbookLifeCyclesClient logbookLifeCyclesClient = this.logbookLifeCyclesClientFactory.getClient();){
            this.finalizeStepOperation(updateOpGuidStart, idRequest, idUnit, globalStep, stepCheckPermission, stepMetadataUpdate, stepStorageUpdate, stepCheckRules, stepLFCCommit, evDetData, masterOperation, isManagementUpdate);
            if (stepMetadataUpdate) {
                logbookLifeCyclesClient.rollBackUnitsByOperation(updateOpGuidStart.toString());
            }
            if (!stepStorageUpdate) {
                ((Counter.Child)VitamCommonMetrics.CONSISTENCY_ERROR_COUNTER.labels(new String[]{String.valueOf(ParameterHelper.getTenantParameter()), "StoreUnit"})).inc();
                LOGGER.error(String.format("[Consistency Error] : The Archive Unit with guid =%s is not saved in storage, tenant : %s, requestId : %s", idUnit, ParameterHelper.getTenantParameter(), idRequest.toString()));
            }
        }
        catch (LogbookClientBadRequestException lcbre) {
            LOGGER.error(BAD_REQUEST, (Throwable)lcbre);
        }
        catch (LogbookClientNotFoundException lcbre) {
            LOGGER.error(CLIENT_NOT_FOUND, (Throwable)lcbre);
        }
        catch (LogbookClientServerException lcse) {
            LOGGER.error(CLIENT_SERVER_ERROR, (Throwable)lcse);
        }
    }

    private LogbookLifeCycleUnitParameters getLogbookLifeCycleUpdateUnitParameters(GUID eventIdentifierProcess, StatusCode logbookOutcome, GUID objectIdentifier, String action) {
        LogbookTypeProcess eventTypeProcess = LogbookTypeProcess.UPDATE;
        GUID updateGuid = GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter());
        LogbookLifeCycleUnitParameters logbookLifeCycleUnitParameters = LogbookParameterHelper.newLogbookLifeCycleUnitParameters((GUID)updateGuid, (String)VitamLogbookMessages.getEventTypeLfc((String)action), (GUID)eventIdentifierProcess, (LogbookTypeProcess)eventTypeProcess, (StatusCode)logbookOutcome, (String)VitamLogbookMessages.getOutcomeDetailLfc((String)action, (StatusCode)logbookOutcome), (String)VitamLogbookMessages.getCodeLfc((String)action, (StatusCode)logbookOutcome), (GUID)objectIdentifier);
        return logbookLifeCycleUnitParameters;
    }

    private LogbookOperationParameters getLogbookOperationUpdateUnitParameters(GUID eventIdentifier, GUID eventIdentifierProcess, StatusCode logbookOutcome, String outcomeDetailMessage, GUID eventIdentifierRequest, String action, boolean addContract) {
        LogbookTypeProcess eventTypeProcess = LogbookTypeProcess.UPDATE;
        LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eventIdentifier, (String)action, (GUID)eventIdentifierProcess, (LogbookTypeProcess)eventTypeProcess, (StatusCode)logbookOutcome, (String)outcomeDetailMessage, (GUID)eventIdentifierRequest);
        if (addContract) {
            ObjectNode rightsStatementIdentifier = JsonHandler.createObjectNode();
            rightsStatementIdentifier.put(ACCESS_CONTRACT, VitamThreadUtils.getVitamSession().getContract().getIdentifier());
            parameters.putParameterValue(LogbookParameterName.rightsStatementIdentifier, rightsStatementIdentifier.toString());
        }
        return parameters;
    }

    private String getDiffMessageFor(JsonNode diff, String unitId) throws InvalidParseOperationException {
        JsonNode arrayNode;
        if (diff == null) {
            return "";
        }
        JsonNode jsonNode = arrayNode = diff.has(DOLLAR_DIFF) ? diff.get(DOLLAR_DIFF) : diff.get(RESULTS);
        if (arrayNode == null) {
            return "";
        }
        for (JsonNode diffNode : arrayNode) {
            if (diffNode.get(ID) == null || !unitId.equals(diffNode.get(ID).textValue())) continue;
            ObjectNode diffObject = JsonHandler.createObjectNode();
            diffObject.set("diff", diffNode.get(DIFF));
            diffObject.put("version", VitamConfiguration.getDiffVersion());
            return JsonHandler.writeAsString((Object)diffObject);
        }
        return "";
    }

    private void cleanWorkspace(String containerName) throws ContentAddressableStorageServerException, ContentAddressableStorageNotFoundException {
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            if (workspaceClient.isExistingContainer(containerName)) {
                workspaceClient.deleteContainer(containerName, true);
            }
        }
    }

    void checkAndUpdateRuleQuery(UpdateParserMultiple updateParser) throws AccessInternalRuleExecutionException, AccessInternalExecutionException, MetaDataNotFoundException {
        UpdateMultiQuery request = updateParser.getRequest();
        LinkedList<String> deletedCategoryRules = new LinkedList<String>();
        HashMap<String, JsonNode> updatedCategoryRules = new HashMap<String, JsonNode>();
        AccessInternalModuleImpl.checkActionsOnRules(request, deletedCategoryRules, updatedCategoryRules);
        if (deletedCategoryRules.isEmpty() && updatedCategoryRules.isEmpty()) {
            return;
        }
        String unitId = updateParser.getRequest().getRoots().toArray(new String[1])[0];
        JsonNode management = this.getUnitManagement(unitId);
        Set updatedCategories = updatedCategoryRules.keySet();
        for (String category : VitamConstants.getSupportedRules()) {
            JsonNode updatedPreventRulesNode;
            JsonNode updatedPreventInheritanceNode;
            JsonNode fullupdatedInheritanceNode;
            JsonNode finalAction;
            ArrayNode rulesForUpdatedCategory;
            ArrayNode rulesForCategory = null;
            JsonNode categoryNode = management.get(category);
            if (categoryNode != null) {
                rulesForCategory = (ArrayNode)categoryNode.get(RULES_KEY);
            }
            if (deletedCategoryRules.contains(category)) {
                this.checkDeletedCategories(categoryNode, category);
            }
            if (rulesForCategory != null && rulesForCategory.size() != 0) {
                boolean hasNewRules;
                ArrayNode updatedRules;
                if (!updatedCategories.contains(category)) continue;
                rulesForUpdatedCategory = (ArrayNode)((JsonNode)updatedCategoryRules.get(category)).get(RULES_KEY);
                finalAction = ((JsonNode)updatedCategoryRules.get(category)).get(FINAL_ACTION_KEY);
                JsonNode existingFinalAction = categoryNode.get(FINAL_ACTION_KEY);
                JsonNode classificationLevel = ((JsonNode)updatedCategoryRules.get(category)).get("ClassificationLevel");
                JsonNode classificationOwner = ((JsonNode)updatedCategoryRules.get(category)).get("ClassificationOwner");
                JsonNode classificationAudience = ((JsonNode)updatedCategoryRules.get(category)).get("ClassificationAudience");
                JsonNode classificationReassessingDate = ((JsonNode)updatedCategoryRules.get(category)).get("ClassificationReassessingDate");
                JsonNode classificationNeedReassessingAuthorization = ((JsonNode)updatedCategoryRules.get(category)).get("NeedReassessingAuthorization");
                fullupdatedInheritanceNode = ((JsonNode)updatedCategoryRules.get(category)).get(INHERITANCE_KEY);
                updatedPreventInheritanceNode = ((JsonNode)updatedCategoryRules.get(category)).get("Inheritance.PreventInheritance") != null ? ((JsonNode)updatedCategoryRules.get(category)).get("Inheritance.PreventInheritance") : ((JsonNode)updatedCategoryRules.get(category)).get(PREVENT_INHERITANCE_KEY);
                updatedPreventRulesNode = ((JsonNode)updatedCategoryRules.get(category)).get("Inheritance.PreventRulesId") != null ? ((JsonNode)updatedCategoryRules.get(category)).get("Inheritance.PreventRulesId") : ((JsonNode)updatedCategoryRules.get(category)).get(PREVENT_RULES_ID_KEY);
                boolean deleteAllRules = false;
                if (rulesForUpdatedCategory == null || rulesForUpdatedCategory.size() == 0) {
                    deleteAllRules = true;
                    updatedRules = JsonHandler.createArrayNode();
                } else {
                    updatedRules = this.checkUpdatedRules(category, rulesForCategory, rulesForUpdatedCategory, finalAction);
                    ArrayNode createdRules = this.checkAddedRules(category, rulesForCategory, rulesForUpdatedCategory, finalAction);
                    if (createdRules.size() != 0) {
                        updatedRules.addAll(createdRules);
                    }
                }
                boolean hasNewFinalAction = this.hasNewFinalAction(existingFinalAction, finalAction);
                boolean bl = hasNewRules = updatedRules.size() != 0 || fullupdatedInheritanceNode != null || updatedPreventInheritanceNode != null || updatedPreventRulesNode != null;
                if (!(hasNewRules || hasNewFinalAction || deleteAllRules)) {
                    return;
                }
                HashMap<CallSite, Object> action = new HashMap<CallSite, Object>();
                if (updatedRules.size() != 0) {
                    action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + RULES_PREFIX)), updatedRules);
                } else if (deleteAllRules) {
                    action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + RULES_PREFIX)), JsonHandler.createArrayNode());
                }
                if (hasNewFinalAction) {
                    action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + FINAL_ACTION_PREFIX)), finalAction);
                }
                if (fullupdatedInheritanceNode != null) {
                    action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + ".Inheritance")), fullupdatedInheritanceNode);
                }
                if (updatedPreventInheritanceNode != null) {
                    action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + ".Inheritance.PreventInheritance")), updatedPreventInheritanceNode);
                }
                if (updatedPreventRulesNode != null) {
                    action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + ".Inheritance.PreventRulesId")), updatedPreventRulesNode);
                }
                if (classificationLevel != null) {
                    action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + ".ClassificationLevel")), classificationLevel);
                }
                if (classificationOwner != null) {
                    action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + ".ClassificationOwner")), classificationOwner);
                }
                if (classificationAudience != null) {
                    action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + ".ClassificationAudience")), classificationAudience);
                }
                if (classificationNeedReassessingAuthorization != null) {
                    action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + ".NeedReassessingAuthorization")), classificationNeedReassessingAuthorization);
                }
                if (classificationReassessingDate != null) {
                    action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + ".ClassificationReassessingDate")), classificationReassessingDate);
                }
                try {
                    if (action.size() <= 0) continue;
                    request.addActions(new Action[]{new SetAction(action)});
                    continue;
                }
                catch (InvalidCreateOperationException e) {
                    throw new AccessInternalExecutionException(ERROR_ADD_CONDITION, (Throwable)e);
                }
            }
            if (!updatedCategories.contains(category)) continue;
            rulesForUpdatedCategory = (ArrayNode)((JsonNode)updatedCategoryRules.get(category)).get(RULES_KEY);
            finalAction = ((JsonNode)updatedCategoryRules.get(category)).get(FINAL_ACTION_KEY);
            JsonNode classificationLevel = ((JsonNode)updatedCategoryRules.get(category)).get("ClassificationLevel");
            JsonNode classificationOwner = ((JsonNode)updatedCategoryRules.get(category)).get("ClassificationOwner");
            fullupdatedInheritanceNode = ((JsonNode)updatedCategoryRules.get(category)).get(INHERITANCE_KEY);
            updatedPreventInheritanceNode = ((JsonNode)updatedCategoryRules.get(category)).get("Inheritance.PreventInheritance") != null ? ((JsonNode)updatedCategoryRules.get(category)).get("Inheritance.PreventInheritance") : ((JsonNode)updatedCategoryRules.get(category)).get(PREVENT_INHERITANCE_KEY);
            updatedPreventRulesNode = ((JsonNode)updatedCategoryRules.get(category)).get("Inheritance.PreventRulesId") != null ? ((JsonNode)updatedCategoryRules.get(category)).get("Inheritance.PreventRulesId") : ((JsonNode)updatedCategoryRules.get(category)).get(PREVENT_RULES_ID_KEY);
            ArrayNode createdRules = this.checkAddedRules(category, null, rulesForUpdatedCategory, finalAction);
            HashMap<CallSite, Object> action = new HashMap<CallSite, Object>();
            if (createdRules.size() != 0) {
                action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + RULES_PREFIX)), createdRules);
            }
            if (finalAction != null) {
                action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + FINAL_ACTION_PREFIX)), finalAction);
            }
            if (fullupdatedInheritanceNode != null) {
                action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + ".Inheritance")), fullupdatedInheritanceNode);
            }
            if (updatedPreventInheritanceNode != null) {
                action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + ".Inheritance.PreventInheritance")), updatedPreventInheritanceNode);
            }
            if (updatedPreventRulesNode != null) {
                action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + ".Inheritance.PreventRulesId")), updatedPreventRulesNode);
            }
            if (classificationLevel != null) {
                action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + ".ClassificationLevel")), classificationLevel);
            }
            if (classificationOwner != null) {
                action.put((CallSite)((Object)(MANAGEMENT_PREFIX + category + ".ClassificationOwner")), classificationOwner);
            }
            try {
                request.addActions(new Action[]{new SetAction(action)});
            }
            catch (InvalidCreateOperationException e) {
                throw new AccessInternalExecutionException(ERROR_ADD_CONDITION, (Throwable)e);
            }
        }
    }

    private boolean hasNewFinalAction(JsonNode existingFinalAction, JsonNode finalAction) {
        if (existingFinalAction == null && finalAction != null) {
            return true;
        }
        if (existingFinalAction != null && finalAction == null) {
            return false;
        }
        if (existingFinalAction == null && finalAction == null) {
            return false;
        }
        return !existingFinalAction.textValue().equalsIgnoreCase(finalAction.textValue());
    }

    private JsonNode getUnitManagement(String unitId) throws AccessInternalExecutionException, MetaDataNotFoundException {
        JsonNode jsonUnit = null;
        try {
            String emptyQuery = "{\"$queries\": [],\"$filter\": { },\"$projection\": {}}";
            JsonNode response = this.selectUnitbyId(JsonHandler.getFromString((String)emptyQuery), unitId);
            if (response == null || response.get(RESULTS) == null) {
                throw new AccessInternalExecutionException("Can't get unit by ID: " + unitId);
            }
            JsonNode results = response.get(RESULTS);
            if (results.size() != 1) {
                throw new AccessInternalExecutionException("Can't get unique unit by ID: " + unitId);
            }
            jsonUnit = results.get(0);
        }
        catch (AccessInternalExecutionException | InvalidParseOperationException | IllegalArgumentException e) {
            throw new AccessInternalExecutionException(e);
        }
        return jsonUnit.get(MANAGEMENT_KEY);
    }

    private void checkDeletedCategories(JsonNode categoryNode, String category) throws AccessInternalRuleExecutionException {
        if (this.checkInheritancePrevention(categoryNode)) {
            LOGGER.error(ERROR_DELETE_RULE + category + ERROR_PREVENT_INHERITANCE);
            throw new AccessInternalRuleExecutionException(VitamCode.ACCESS_INTERNAL_UPDATE_UNIT_DELETE_CATEGORY_INHERITANCE.name());
        }
    }

    private ArrayNode checkUpdatedRules(String category, ArrayNode rulesForCategory, ArrayNode rulesForUpdatedCategory, JsonNode finalAction) throws AccessInternalRuleExecutionException, AccessInternalExecutionException {
        ArrayNode updatedRules = JsonHandler.createArrayNode();
        if (rulesForCategory != null && rulesForUpdatedCategory != null) {
            for (JsonNode unitRule : rulesForCategory) {
                boolean findIt = false;
                Iterator updateRulesIterator = rulesForUpdatedCategory.iterator();
                while (!findIt && updateRulesIterator.hasNext()) {
                    JsonNode updateRule = (JsonNode)updateRulesIterator.next();
                    String updateRuleName = updateRule.get("Rule").asText();
                    if (unitRule.get("Rule") == null || !unitRule.get("Rule").asText().equals(updateRuleName)) continue;
                    findIt = true;
                    if (this.checkEndDateInRule(updateRule)) {
                        LOGGER.error(ERROR_UPDATE_RULE + String.valueOf(updateRule) + " contains an endDate");
                        throw new AccessInternalRuleExecutionException(VitamCode.ACCESS_INTERNAL_UPDATE_UNIT_UPDATE_RULE_END_DATE.name());
                    }
                    if (!this.checkRuleFinalAction(category, finalAction)) {
                        LOGGER.error(ERROR_UPDATE_RULE + String.valueOf(updateRule) + "(FinalAction: " + String.valueOf(finalAction) + ") contains wrong FinalAction");
                        throw new AccessInternalRuleExecutionException(VitamCode.ACCESS_INTERNAL_UPDATE_UNIT_UPDATE_RULE_FINAL_ACTION.name());
                    }
                    JsonNode ruleInReferential = this.checkExistingRule(updateRuleName);
                    if (ruleInReferential == null) {
                        LOGGER.error(ERROR_UPDATE_RULE + String.valueOf(updateRule.get("Rule")) + " is not in referential");
                        throw new AccessInternalRuleExecutionException(VitamCode.ACCESS_INTERNAL_UPDATE_UNIT_UPDATE_RULE_EXIST.name());
                    }
                    if (!category.equals(ruleInReferential.get(RULE_TYPE).asText())) {
                        LOGGER.error(ERROR_UPDATE_RULE + String.valueOf(updateRule.get("Rule")) + " is not a " + category);
                        throw new AccessInternalRuleExecutionException(VitamCode.ACCESS_INTERNAL_UPDATE_UNIT_UPDATE_RULE_CATEGORY.name());
                    }
                    try {
                        updateRule = ArchiveUnitUpdateUtils.computeEndDate((ObjectNode)((ObjectNode)updateRule), (JsonNode)ruleInReferential);
                    }
                    catch (IllegalArgumentException e) {
                        throw new AccessInternalRuleExecutionException(VitamCode.ACCESS_INTERNAL_UPDATE_UNIT_UPDATE_RULE_START_DATE.name());
                    }
                    updatedRules.add(updateRule);
                }
            }
        }
        return updatedRules;
    }

    private ArrayNode checkAddedRules(String category, ArrayNode rulesForCategory, ArrayNode rulesForUpdatedCategory, JsonNode finalAction) throws AccessInternalRuleExecutionException, AccessInternalExecutionException {
        ArrayNode createdRules = JsonHandler.createArrayNode();
        if (rulesForUpdatedCategory != null) {
            for (JsonNode updateRule : rulesForUpdatedCategory) {
                if (updateRule.get("Rule") == null) {
                    throw new AccessInternalRuleExecutionException(VitamCode.ACCESS_INTERNAL_UPDATE_UNIT_CHECK_RULES.name());
                }
                boolean findIt = false;
                if (rulesForCategory != null) {
                    for (JsonNode unitRule : rulesForCategory) {
                        if (unitRule.get("Rule") == null || !unitRule.get("Rule").asText().equals(updateRule.get("Rule").asText())) continue;
                        findIt = true;
                    }
                }
                if (findIt) continue;
                if (this.checkEndDateInRule(updateRule)) {
                    LOGGER.error(ERROR_CREATE_RULE + String.valueOf(updateRule) + " contains an endDate");
                    throw new AccessInternalRuleExecutionException(VitamCode.ACCESS_INTERNAL_UPDATE_UNIT_CREATE_RULE_END_DATE.name());
                }
                if (!this.checkRuleFinalAction(category, finalAction)) {
                    LOGGER.error(ERROR_CREATE_RULE + String.valueOf(updateRule) + "(FinalAction: " + String.valueOf(finalAction) + ") contains wrong FinalAction");
                    throw new AccessInternalRuleExecutionException(VitamCode.ACCESS_INTERNAL_UPDATE_UNIT_CREATE_RULE_FINAL_ACTION.name());
                }
                JsonNode ruleInReferential = this.checkExistingRule(updateRule.get("Rule").asText());
                if (ruleInReferential == null) {
                    LOGGER.error(ERROR_CREATE_RULE + String.valueOf(updateRule.get("Rule")) + " is not in referential");
                    throw new AccessInternalRuleExecutionException(VitamCode.ACCESS_INTERNAL_UPDATE_UNIT_CREATE_RULE_EXIST.name());
                }
                if (!category.equals(ruleInReferential.get(RULE_TYPE).asText())) {
                    LOGGER.error(ERROR_CREATE_RULE + String.valueOf(updateRule.get("Rule")) + " is not a " + category);
                    throw new AccessInternalRuleExecutionException(VitamCode.ACCESS_INTERNAL_UPDATE_UNIT_CREATE_RULE_CATEGORY.name());
                }
                try {
                    updateRule = ArchiveUnitUpdateUtils.computeEndDate((ObjectNode)((ObjectNode)updateRule), (JsonNode)ruleInReferential);
                }
                catch (IllegalArgumentException e) {
                    throw new AccessInternalRuleExecutionException(VitamCode.ACCESS_INTERNAL_UPDATE_UNIT_CREATE_RULE_START_DATE.name());
                }
                createdRules.add(updateRule);
            }
        }
        return createdRules;
    }

    private boolean checkInheritancePrevention(JsonNode categoryNode) {
        JsonNode inheritance = categoryNode.get(INHERITANCE_KEY);
        return inheritance != null && (inheritance.get(PREVENT_RULES_ID_KEY) != null || inheritance.get(PREVENT_INHERITANCE_KEY) != null);
    }

    private boolean checkEndDateInRule(JsonNode rule) {
        return rule.get("EndDate") != null;
    }

    private boolean checkRuleFinalAction(String category, JsonNode finalActionNode) {
        if ("AppraisalRule".equals(category)) {
            if (finalActionNode == null) {
                return false;
            }
            try {
                VitamConstants.AppraisalRuleFinalAction.fromValue((String)finalActionNode.asText());
            }
            catch (IllegalArgumentException e) {
                LOGGER.info("While update rules, No Appraisal FinalAction match " + String.valueOf(finalActionNode) + String.valueOf(e));
                return false;
            }
        } else if ("StorageRule".equals(category)) {
            if (finalActionNode == null) {
                return false;
            }
            try {
                VitamConstants.StorageRuleFinalAction.fromValue((String)finalActionNode.asText());
            }
            catch (IllegalArgumentException e) {
                LOGGER.info("While update rules, No Storage FinalAction match " + String.valueOf(finalActionNode) + String.valueOf(e));
                return false;
            }
        } else if (finalActionNode != null) {
            return false;
        }
        return true;
    }

    private JsonNode checkExistingRule(String ruleId) throws AccessInternalExecutionException {
        JsonNode response = null;
        try (AdminManagementClient client = this.adminManagementClientFactory.getClient();){
            response = client.getRuleByID(ruleId);
        }
        catch (FileRulesException e) {
            LOGGER.info("While update rules, No rules find for id " + ruleId + String.valueOf((Object)e));
            return null;
        }
        catch (InvalidParseOperationException | AdminManagementClientServerException e) {
            throw new AccessInternalExecutionException("Error during checking existing rules", e);
        }
        return response.get(RESULTS).get(0);
    }

    public Response findDIPByOperationId(String id) throws AccessInternalExecutionException {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block9: {
            WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
            try {
                Response dip = workspaceClient.getObject(DIP_CONTAINER, VitamThreadUtils.getVitamSession().getTenantId() + "/" + id);
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(dip, Response.Status.OK, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                if (workspaceClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageServerException e) {
                    throw new AccessInternalExecutionException((Throwable)e);
                }
                catch (ContentAddressableStorageNotFoundException e) {
                    LOGGER.warn("DIP file not found " + id);
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
            }
            workspaceClient.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    public Response findTransferSIPByOperationId(String id) throws AccessInternalExecutionException {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block9: {
            WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
            try {
                Response dip = workspaceClient.getObject(TRANSFER_SIP_CONTAINER, VitamThreadUtils.getVitamSession().getTenantId() + "/" + id);
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(dip, Response.Status.OK, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                if (workspaceClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageServerException e) {
                    throw new AccessInternalExecutionException((Throwable)e);
                }
                catch (ContentAddressableStorageNotFoundException e) {
                    LOGGER.warn("TRANSFER SIP file not found " + id);
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
            }
            workspaceClient.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    public JsonNode selectObjects(JsonNode jsonQuery) throws IllegalArgumentException, InvalidParseOperationException, AccessInternalExecutionException {
        JsonNode jsonNode = null;
        LOGGER.debug("DEBUG: start selectObjects {}", (Object)jsonQuery);
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            SanityChecker.checkJsonAll((JsonNode)jsonQuery);
            LOGGER.debug("{}", jsonNode);
            RequestParserMultiple parser = RequestParserHelper.getParser((JsonNode)jsonQuery.deepCopy());
            parser.getRequest().reset();
            if (!(parser instanceof SelectParserMultiple)) {
                throw new InvalidParseOperationException(NOT_A_SELECT_OPERATION);
            }
            jsonNode = metaDataClient.selectObjectGroups(jsonQuery);
            LOGGER.debug("DEBUG {}", (Object)jsonNode);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(PARSING_ERROR, (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(ILLEGAL_ARGUMENT, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("exeption thrown", (Throwable)e);
            throw new AccessInternalExecutionException((Throwable)e);
        }
        return jsonNode;
    }

    public JsonNode selectUnitsWithInheritedRules(JsonNode jsonQuery) throws IllegalArgumentException, InvalidParseOperationException, AccessInternalExecutionException {
        JsonNode jsonNode;
        block9: {
            ParametersChecker.checkParameter((String)DATA_CATEGORY, (Object[])new Object[]{jsonQuery});
            RequestParserMultiple parser = RequestParserHelper.getParser((JsonNode)jsonQuery.deepCopy());
            if (!(parser instanceof SelectParserMultiple)) {
                throw new InvalidParseOperationException(NOT_A_SELECT_OPERATION);
            }
            MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
            try {
                jsonNode = metaDataClient.selectUnitsWithInheritedRules(jsonQuery);
                if (metaDataClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | ProcessingException e) {
                    throw new AccessInternalExecutionException(e);
                }
            }
            metaDataClient.close();
        }
        return jsonNode;
    }

    private Integer findLatestVersionByQualifier(ObjectGroupResponse objectGroup, String qualifier) {
        int latestVersion = -1;
        for (QualifiersModel qualifierElt : objectGroup.getQualifiers()) {
            if (!qualifierElt.getQualifier().equals(qualifier)) continue;
            for (VersionsModel version : qualifierElt.getVersions()) {
                String dataObjectVersion = version.getDataObjectVersion();
                int versionNumber = Integer.parseInt(StringUtils.substringAfterLast((String)dataObjectVersion, (String)"_"));
                if (versionNumber <= latestVersion) continue;
                latestVersion = versionNumber;
            }
        }
        return latestVersion;
    }
}

