/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.client.OperationStatusClient;
import fr.gouv.vitam.access.external.client.VitamPoolingClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.export.transfer.TransferRequest;
import fr.gouv.vitam.common.xml.SecureXMLFactoryUtils;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import io.cucumber.java.After;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class TransferStep
extends CommonStep {
    public TransferStep(World world) {
        super(world);
    }

    @When(value="^je lance un transfert$")
    public void transfer() throws VitamException {
        this.cleanTempFile();
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        vitamContext.setAccessContract(this.world.getContractId());
        String query = this.world.getQuery();
        JsonNode jsonNode = JsonHandler.getFromString((String)query);
        TransferRequest transferRequest = (TransferRequest)JsonHandler.getFromJsonNode((JsonNode)jsonNode, TransferRequest.class);
        RequestResponse response = this.world.getAccessClient().transfer(vitamContext, transferRequest);
        Assertions.assertThat((boolean)response.isOk()).isTrue();
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
        boolean processTimeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 100, 1000L, TimeUnit.MILLISECONDS);
        if (!processTimeout) {
            Assertions.fail((String)"Transfer processing not finished. Timeout exceeded.");
        }
        ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
    }

    @When(value="^je t\u00e9l\u00e9charge le sip du transfert$")
    public void downloadSipTransfer() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        vitamContext.setAccessContract(this.world.getContractId());
        Response response = this.world.getAccessClient().getTransferById(vitamContext, this.world.getOperationId());
        Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
        File tempFile = Files.createTempFile("TRANSFER-" + this.world.getOperationId(), ".zip", new FileAttribute[0]).toFile();
        try (InputStream tansferInputStream = (InputStream)response.readEntity(InputStream.class);){
            Files.copy(tansferInputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        response.close();
        this.world.setTransferFile(tempFile.toPath());
    }

    @Then(value="^le transfert contient (\\d+) unit\u00e9s archivistiques$")
    public void checkSipTransferUnitCount(int nbUnits) throws Exception {
        try (ZipFile zipFile = new ZipFile(this.world.getTransferFile().toFile());){
            ZipArchiveEntry manifest = zipFile.getEntry("manifest.xml");
            try (InputStream is = zipFile.getInputStream(manifest);){
                int cpt = this.countElements(is, "ArchiveTransfer/DataObjectPackage/DescriptiveMetadata/ArchiveUnit");
                Assertions.assertThat((int)cpt).isEqualTo(nbUnits);
            }
        }
    }

    @Then(value="^le transfert contient (\\d+) groupes d'objets$")
    public void checkSipTransferObjectGroupCount(int nbObjectGroups) throws Exception {
        try (ZipFile zipFile = new ZipFile(this.world.getTransferFile().toFile());){
            ZipArchiveEntry manifest = zipFile.getEntry("manifest.xml");
            try (InputStream is = zipFile.getInputStream(manifest);){
                int cpt = this.countElements(is, "ArchiveTransfer/DataObjectPackage/DataObjectGroup");
                Assertions.assertThat((int)cpt).isEqualTo(nbObjectGroups);
            }
        }
    }

    @Then(value="^le transfert contient (\\d+) objets dont (\\d+) sont binaires$")
    public void checkSipTransferObjectCount(int nbObjects, int nbBinaryObjects) throws Exception {
        try (ZipFile zipFile = new ZipFile(this.world.getTransferFile().toFile());){
            ZipArchiveEntry manifest = zipFile.getEntry("manifest.xml");
            try (InputStream is = zipFile.getInputStream(manifest);){
                int cpt = this.countElements(is, "ArchiveTransfer/DataObjectPackage/DataObjectGroup/BinaryDataObject");
                Assertions.assertThat((int)cpt).isEqualTo(nbObjects);
            }
            List entries = EnumerationUtils.toList((Enumeration)zipFile.getEntries());
            long binaryFiles = entries.stream().filter(entry -> entry.getName().startsWith("Content/")).count();
            Assertions.assertThat((long)binaryFiles).isEqualTo((long)nbBinaryObjects);
        }
    }

    @When(value="^j'upload le sip du transfert")
    public void upload_this_sip_transfer() throws VitamException, IOException {
        try (InputStream inputStream = Files.newInputStream(this.world.getTransferFile(), StandardOpenOption.READ);){
            VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId());
            RequestResponse response = this.world.getIngestClient().ingest(vitamContext, inputStream, Contexts.DEFAULT_WORKFLOW.name(), ProcessAction.RESUME.name());
            String operationId = response.getHeaderString("X-Request-Id");
            this.world.setOperationId(operationId);
            VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
            boolean process_timeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 1800, 1000L, TimeUnit.MILLISECONDS);
            if (!process_timeout) {
                Assertions.fail((String)("Sip transfer processing not finished : operation (" + operationId + "). Timeout exceeded."));
            }
            ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
        }
    }

    @When(value="^je receptionne l'ATR du versement d'un transfert")
    public void transfer_reply() throws VitamException, IOException {
        try (InputStream inputStream = Files.newInputStream(this.world.getAtrFile(), StandardOpenOption.READ);){
            VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()).setAccessContract(this.world.getContractId());
            RequestResponse response = this.world.getAccessClient().transferReply(vitamContext, inputStream);
            Assertions.assertThat((boolean)response.isOk()).isTrue();
            String operationId = response.getHeaderString("X-Request-Id");
            this.world.setOperationId(operationId);
            VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
            boolean process_timeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 1800, 1000L, TimeUnit.MILLISECONDS);
            if (!process_timeout) {
                Assertions.fail((String)("Sip transfer reply processing not finished : operation (" + operationId + "). Timeout exceeded."));
            }
            ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
        }
    }

    private int countElements(InputStream inputStream, String path) throws XMLStreamException {
        int cpt = 0;
        Stack<String> elementNames = new Stack<String>();
        XMLEventReader eventReader = SecureXMLFactoryUtils.createSecureXMLEventReader((InputStream)inputStream);
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            switch (event.getEventType()) {
                case 1: {
                    StartElement startElement = event.asStartElement();
                    String qName = startElement.getName().getLocalPart();
                    elementNames.add(qName);
                    String fullElementName = String.join((CharSequence)"/", elementNames);
                    if (!fullElementName.equals(path)) break;
                    ++cpt;
                    break;
                }
                case 2: {
                    elementNames.pop();
                }
            }
        }
        return cpt;
    }

    @After
    public void afterScenario() {
        this.cleanTempFile();
    }

    private void cleanTempFile() {
        if (this.world.getTransferFile() != null) {
            FileUtils.deleteQuietly((File)this.world.getTransferFile().toFile());
            this.world.setTransferFile(null);
        }
    }
}

