/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import fr.gouv.vitam.storage.driver.model.StorageLogBackupResult;
import fr.gouv.vitam.storage.driver.model.StorageLogTraceabilityResult;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.storage.engine.common.model.response.StoredInfoResult;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageAlreadyExistException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import jakarta.ws.rs.core.Response;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class StorageStep
extends CommonStep {
    private String fileName;
    private static final String TEST_URI = "testStorage";
    private final String guid;
    private StoredInfoResult info;
    private Response.StatusType responseStatus;

    public StorageStep(World world) throws FileNotFoundException, InvalidParseOperationException {
        super(world);
        this.guid = GUIDFactory.newStorageOperationGUID((int)world.getTenantId(), (boolean)true).getId();
    }

    @Given(value="^un fichier nomm\u00e9 (.*)$")
    public void a_file_named(String fileName) {
        this.fileName = fileName;
    }

    @When(value="^je sauvegarde le fichier dans la strategie (.*)")
    public void save_this_file(String strategy) throws IOException {
        this.save(strategy);
        Assertions.assertThat((Object)this.info).isNotNull();
        Assertions.assertThat((String)this.info.getId()).isEqualTo(this.guid);
    }

    @When(value="^je lance une sauvegarde des journaux des \u00e9critures")
    public void storage_backup() throws IOException {
        this.runInVitamThread(() -> {
            try {
                VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
                VitamThreadUtils.getVitamSession().setContractId(this.world.getContractId());
                RequestResponseOK response = this.world.getStorageClient().storageLogBackup(Collections.singletonList(this.world.getTenantId()));
                StorageLogBackupResult storageLogTraceabilityResult = (StorageLogBackupResult)response.getResults().get(0);
                ((AbstractStringAssert)Assertions.assertThat((String)storageLogTraceabilityResult.getOperationId()).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
                this.world.setOperationId(storageLogTraceabilityResult.getOperationId());
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    @When(value="^je lance une sauvegarde des journaux des logs d'acc\u00e8s")
    public void storage_accesslog_backup() throws IOException {
        this.runInVitamThread(() -> {
            try {
                VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
                VitamThreadUtils.getVitamSession().setContractId(this.world.getContractId());
                RequestResponseOK response = this.world.getStorageClient().storageAccessLogBackup(Collections.singletonList(this.world.getTenantId()));
                StorageLogBackupResult storageLogTraceabilityResult = (StorageLogBackupResult)response.getResults().get(0);
                ((AbstractStringAssert)Assertions.assertThat((String)storageLogTraceabilityResult.getOperationId()).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
                this.world.setOperationId(storageLogTraceabilityResult.getOperationId());
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    @When(value="^je lance une s\u00e9curisation du journal des \u00e9critures")
    public void storage_log_traceability() throws IOException {
        this.runInVitamThread(() -> {
            try {
                VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
                VitamThreadUtils.getVitamSession().setContractId(this.world.getContractId());
                RequestResponseOK response = this.world.getStorageClient().storageLogTraceability(Collections.singletonList(this.world.getTenantId()));
                StorageLogTraceabilityResult storageLogTraceabilityResult = (StorageLogTraceabilityResult)response.getResults().get(0);
                ((AbstractStringAssert)Assertions.assertThat((String)storageLogTraceabilityResult.getOperationId()).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
                this.world.setOperationId(storageLogTraceabilityResult.getOperationId());
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    private void save(String strategy) {
        this.runInVitamThread(() -> {
            Path sip = Paths.get(this.world.getBaseDirectory(), this.fileName);
            try {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(this.world.getTenantId()));
                this.store(sip, TEST_URI, strategy, this.guid);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Then(value="^le fichier est bien stock\u00e9 dans les strategies suivantes")
    public void the_sip_is_stored_in_offers(DataTable dataTable) throws StorageException {
        List raws = dataTable.cells();
        for (List raw : raws.subList(1, raws.size())) {
            this.responseStatus = null;
            String strategy = (String)raw.get(1);
            this.the_sip_is_stored_in_offer(strategy);
            Assertions.assertThat((Object)this.responseStatus).isEqualTo((Object)Response.Status.OK);
        }
    }

    @Then(value="^je verifie que toutes ces strategies contiennent des fichiers")
    public void list_srategy(DataTable dataTable) throws StorageException, StorageServerClientException {
        List raws = dataTable.cells();
        for (List raw : raws.subList(1, raws.size())) {
            String strategy = (String)raw.get(1);
            CloseableIterator<ObjectEntry> result = this.container_has_files(strategy);
            try {
                Assertions.assertThat(result).isNotNull();
                Assertions.assertThat((boolean)result.hasNext()).isTrue();
            }
            finally {
                if (result == null) continue;
                result.close();
            }
        }
    }

    private CloseableIterator<ObjectEntry> container_has_files(String strategy) throws StorageServerClientException {
        AtomicReference result = new AtomicReference();
        this.runInVitamThread(() -> {
            try {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(this.world.getTenantId()));
                try {
                    result.set(this.world.getStorageClient().listContainer(strategy, null, DataCategory.OBJECT));
                }
                catch (StorageServerClientException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (AssertionError | Exception e) {
                throw new RuntimeException((Throwable)e);
            }
        });
        return (CloseableIterator)result.get();
    }

    private void the_sip_is_stored_in_offer(String strategy) {
        this.runInVitamThread(() -> {
            Response response = null;
            try {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(this.world.getTenantId()));
                response = this.world.getStorageClient().getContainerAsync(strategy, this.guid, DataCategory.OBJECT, AccessLogUtils.getNoLogAccessLog());
                this.responseStatus = response.getStatusInfo();
            }
            catch (AssertionError | Exception e) {
                try {
                    throw new RuntimeException((Throwable)e);
                }
                catch (Throwable throwable) {
                    this.world.getStorageClient().consumeAnyEntityAndClose(response);
                    throw throwable;
                }
            }
            this.world.getStorageClient().consumeAnyEntityAndClose(response);
        });
    }

    public boolean store(Path sip, String uri, String strategy, String guid) throws StorageServerClientException, StorageNotFoundClientException, StorageAlreadyExistsClientException, ContentAddressableStorageServerException, ContentAddressableStorageAlreadyExistException, ContentAddressableStorageNotFoundException, IOException {
        try (InputStream inputStream = Files.newInputStream(sip, StandardOpenOption.READ);){
            WorkspaceClient workspaceClient = WorkspaceClientFactory.getInstance((WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM).getClient();
            workspaceClient.createContainer(guid);
            workspaceClient.putObject(guid, uri, inputStream);
            ObjectDescription description = new ObjectDescription();
            description.setWorkspaceContainerGUID(guid);
            description.setWorkspaceObjectURI(uri);
            this.store_from_workSpace(guid, description, strategy);
            workspaceClient.deleteObject(guid, uri);
            boolean bl = true;
            return bl;
        }
    }

    private void store_from_workSpace(String uri, ObjectDescription description, String strategy) throws StorageNotFoundClientException, StorageServerClientException, StorageAlreadyExistsClientException {
        try (StorageClient storageClient = StorageClientFactory.getInstance().getClient();){
            this.info = storageClient.storeFileFromWorkspace(strategy, DataCategory.OBJECT, uri, description);
        }
    }
}

