/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Iterables;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookLifecycle;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AutoCloseableSoftAssertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.SoftAssertionError;
import org.assertj.core.api.StringAssert;

public class LogbookStep
extends CommonStep {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookStep.class);
    private boolean isRequestResponseLifecycle;
    private RequestResponse requestResponse;

    public LogbookStep(World world) {
        super(world);
    }

    @When(value="^je recherche le journal des op\u00e9rations")
    public void download_logbook_operation() {
        try {
            this.requestResponse = this.world.getLogbookService().getLogbookOperation(this.world.getAccessClient(), this.world.getTenantId(), this.world.getContractId(), this.world.getApplicationSessionId(), this.world.getOperationId());
            this.isRequestResponseLifecycle = false;
        }
        catch (VitamClientException e) {
            LOGGER.error(String.format("logbook operation could not be retrieved for operationId: %s", this.world.getOperationId()));
            Assertions.fail((String)String.format("logbook operation could not be retrieved for operationId: %s", this.world.getOperationId()));
        }
    }

    @When(value="^je recherche le JCV de l'unit\u00e9 archivistique dont le titre est (.*)")
    public void download_logbook_lifecycle_unit(String unitTitle) {
        try {
            String unitId = this.world.getAccessService().findUnitGUIDByTitleAndOperationId(this.world.getAccessClient(), this.world.getTenantId(), this.world.getContractId(), this.world.getApplicationSessionId(), this.world.getOperationId(), unitTitle);
            this.requestResponse = this.world.getAccessClient().selectUnitLifeCycleById(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), unitId, (JsonNode)new Select().getFinalSelectById());
            this.isRequestResponseLifecycle = true;
        }
        catch (InvalidCreateOperationException | VitamClientException e) {
            LOGGER.error(String.format("logbook lifecycle unit could not be retrieved for operationId and unit title: %s", this.world.getOperationId(), unitTitle));
            Assertions.fail((String)String.format("logbook lifecycle unit could not be retrieved for operationId and unit title: %s", this.world.getOperationId(), unitTitle));
        }
    }

    @When(value="^je recherche le JCV du groupe d'objet de l'unit\u00e9 archivistique dont le titre est (.*)")
    public void download_logbook_lifecycle_object_for_unit(String unitTitle) {
        try {
            String unitId = this.world.getAccessService().findUnitGUIDByTitleAndOperationId(this.world.getAccessClient(), this.world.getTenantId(), this.world.getContractId(), this.world.getApplicationSessionId(), this.world.getOperationId(), unitTitle);
            RequestResponse requestResponseUnit = this.world.getAccessClient().selectUnitbyId(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), (JsonNode)new SelectMultiQuery().getFinalSelectById(), unitId);
            if (requestResponseUnit.isOk()) {
                RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponseUnit;
                JsonNode unit = (JsonNode)requestResponseOK.getResults().get(0);
                if (unit.get(BuilderToken.PROJECTIONARGS.OBJECT.exactToken()).asText().isEmpty()) {
                    throw new VitamClientException("Unit does not have object");
                }
                this.requestResponse = this.world.getAccessClient().selectObjectGroupLifeCycleById(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), unit.get(BuilderToken.PROJECTIONARGS.OBJECT.exactToken()).asText(), (JsonNode)new Select().getFinalSelectById());
                this.isRequestResponseLifecycle = true;
            }
        }
        catch (InvalidCreateOperationException | VitamClientException e) {
            LOGGER.error(String.format("logbook lifecycle object group could not be retrieved for operationId and unit title: %s", this.world.getOperationId(), unitTitle));
            Assertions.fail((String)String.format("logbook lifecycle object group could not be retrieved for operationId and unit title: %s", this.world.getOperationId(), unitTitle));
        }
    }

    @Then(value="^le statut final du journal des op\u00e9rations est (.*)$")
    public void the_logbook_operation_has_a_status(String status) throws VitamClientException {
        LogbookEventOperation lastEvent = this.world.getLogbookService().checkFinalStatusLogbook(this.world, this.world.getAccessClient(), this.world.getTenantId(), this.world.getContractId(), this.world.getApplicationSessionId(), this.world.getOperationId(), status);
        this.world.setLogbookEvent((LogbookEvent)lastEvent);
    }

    @Then(value="^le champ '(.*)' de l'\u00e9venement final est : (.*)$")
    public void the_final_logbook_event_has_message(String field, String message) throws VitamClientException, InvalidParseOperationException {
        LogbookEvent logbookEvent = this.world.getLogbookEvent();
        Assertions.assertThat((Object)logbookEvent).isNotNull();
        JsonNode event = JsonHandler.toJsonNode((Object)logbookEvent);
        Assertions.assertThat((String)event.get(field).textValue()).contains(new CharSequence[]{message});
    }

    @Then(value="^le journal des op\u00e9rations est coh\u00e9rent$")
    public void the_logbook_operation_is_consistent() throws VitamClientException {
        if (this.requestResponse instanceof RequestResponseOK) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)this.requestResponse;
            LogbookOperation master = (LogbookOperation)requestResponseOK.getFirstResult();
            LogbookEventOperation lastEvent = (LogbookEventOperation)Iterables.getLast((Iterable)master.getEvents());
            StatusCode maxStatus = StatusCode.valueOf((String)master.getOutcome());
            StatusCode finalStatus = StatusCode.valueOf((String)lastEvent.getOutcome());
            String masterEvId = master.getEvId();
            String masterEvTypeProc = master.getEvTypeProc();
            HashSet<String> evIds = new HashSet<String>();
            evIds.add(masterEvId);
            for (LogbookEventOperation event : master.getEvents()) {
                ((AbstractStringAssert)Assertions.assertThat((String)event.getEvIdProc()).as("event has evIdProc value %s, but %s was expected. Event name is: %s", new Object[]{event.getEvIdProc(), masterEvId, event.getEvType()})).isEqualTo(masterEvId);
                ((AbstractStringAssert)Assertions.assertThat((String)event.getEvTypeProc()).as("event has evTypeProc value %s, but %s was expected. Event name is: %s", new Object[]{event.getEvTypeProc(), masterEvTypeProc, event.getEvType()})).isEqualTo(masterEvTypeProc);
                evIds.add(event.getEvId());
                StatusCode status = StatusCode.valueOf((String)event.getOutcome());
                if (status.getStatusLevel() <= maxStatus.getStatusLevel()) continue;
                maxStatus = status;
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)evIds.size()).as("all evId values should be differents but where not", new Object[0])).isEqualTo(master.getEvents().size() + 1);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)finalStatus).as("the final outcome is %s, but an outcome %s was seen in an event", new Object[]{finalStatus, maxStatus})).isGreaterThanOrEqualTo((Comparable)maxStatus);
        } else {
            LOGGER.error(String.format("logbook operation return a vitam error for operationId: %s", this.world.getOperationId()));
            Assertions.fail((String)String.format("logbook operation return a vitam error for operationId: %s", this.world.getOperationId()));
        }
    }

    @Then(value="^le journal ne contient pas de statut (.*)$")
    public void the_logbook_has_not_the_status(String status) throws VitamClientException {
        if (this.requestResponse instanceof RequestResponseOK) {
            if (this.isRequestResponseLifecycle) {
                this.the_logbook_lifecycle_has_not_the_status(status);
            } else {
                this.the_logbook_operation_has_not_the_status(status);
            }
        }
    }

    @Then(value="^l'outcome d\u00e9tail de l'\u00e9v\u00e9nement (.*) est (.*)$")
    public void the_outcome_detail_is(String eventName, String eventOutDetail) throws Throwable {
        if (this.requestResponse.isOk()) {
            if (this.isRequestResponseLifecycle) {
                this.the_logbook_lifecycle_outcome_detail_is(eventName, eventOutDetail);
            } else {
                this.the_logbook_operation_outcome_detail_is(eventName, eventOutDetail);
            }
        }
    }

    @Then(value="^le[s]? statut[s]? (?:de l'\u00e9v\u00e9nement|des \u00e9v\u00e9nements) (.*) (?:est|sont) (.*)$")
    public void the_status_are(String eventNamesStr, String eventStatus) throws VitamClientException, InvalidParseOperationException {
        List<String> eventNames = Arrays.asList(eventNamesStr.split(",\\s?"));
        if (this.requestResponse.isOk()) {
            if (this.isRequestResponseLifecycle) {
                this.the_logbook_lifecycle_status_are(eventNames, eventStatus);
            } else {
                this.the_logbook_operation_status_are(eventNames, eventStatus);
            }
        } else {
            VitamError error = (VitamError)this.requestResponse;
            LOGGER.error(String.format("logbook operation return a vitam error for operationId: %s, requestId is %s", this.world.getOperationId(), error.getCode()));
            Fail.fail((String)("cannot find logbook with id: " + this.world.getOperationId()));
        }
    }

    @Then(value="^le r\u00e9sultat de l'\u00e9v\u00e9nement (.*) est (.*)$")
    public void the_results_are(String eventName, String eventResults) throws VitamClientException, InvalidParseOperationException {
        if (this.requestResponse.isOk()) {
            if (this.isRequestResponseLifecycle) {
                this.the_logbook_lifecycle_results_are(eventName, eventResults);
            } else {
                this.the_logbook_operation_results_are(eventName, eventResults);
            }
        } else {
            VitamError error = (VitamError)this.requestResponse;
            LOGGER.error(String.format("logbook operation return a vitam error for operationId: %s, requestId is %s", this.world.getOperationId(), error.getCode()));
            Fail.fail((String)("cannot find logbook with id: " + this.world.getOperationId()));
        }
    }

    private void the_logbook_operation_results_are(String eventName, String eventResults) throws SoftAssertionError {
        RequestResponseOK requestResponseOK = (RequestResponseOK)this.requestResponse;
        List actual = ((LogbookOperation)requestResponseOK.getFirstResult()).getEvents();
        try (AutoCloseableSoftAssertions softly = new AutoCloseableSoftAssertions();){
            List<LogbookEvent> events = actual.stream().filter(event -> eventName.equals(event.getEvType())).filter(event -> !"STARTED".equals(event.getOutcome())).collect(Collectors.toList());
            this.the_logbook_event_result_check(eventName, eventResults, softly, events);
        }
    }

    private void the_logbook_lifecycle_results_are(String eventName, String eventResults) throws SoftAssertionError {
        RequestResponseOK requestResponseOK = (RequestResponseOK)this.requestResponse;
        List actual = ((LogbookLifecycle)requestResponseOK.getFirstResult()).getEvents();
        try (AutoCloseableSoftAssertions softly = new AutoCloseableSoftAssertions();){
            List<LogbookEvent> events = actual.stream().filter(event -> eventName.equals(event.getEvType())).filter(event -> !"STARTED".equals(event.getOutcome())).collect(Collectors.toList());
            this.the_logbook_event_result_check(eventName, eventResults, softly, events);
        }
    }

    private void the_logbook_event_result_check(String eventName, String eventResults, AutoCloseableSoftAssertions softly, List<LogbookEvent> events) {
        ((ListAssert)softly.assertThat(events).as("event %s is not present or finish.", new Object[]{eventName})).hasSize(1);
        LogbookEvent onlyElement = (LogbookEvent)Iterables.getOnlyElement(events);
        String currentResult = onlyElement.getOutDetail();
        ((StringAssert)softly.assertThat(currentResult).as("event %s has outcome detail %s but excepted outcome detail is %s.", new Object[]{eventName, currentResult, eventResults})).isEqualTo(eventResults);
    }

    private void the_logbook_operation_has_not_the_status(String status) {
        RequestResponseOK requestResponseOK = (RequestResponseOK)this.requestResponse;
        LogbookOperation master = (LogbookOperation)requestResponseOK.getFirstResult();
        ((AbstractStringAssert)Assertions.assertThat((String)master.getOutcome()).as("master has forbidden status %s", new Object[]{master.getOutcome(), master.getEvType()})).isNotEqualTo((Object)status);
        for (LogbookEventOperation event : master.getEvents()) {
            ((AbstractStringAssert)Assertions.assertThat((String)event.getOutcome()).as("event has forbidden status %s. Event name is: %s", new Object[]{event.getOutcome(), event.getEvType()})).isNotEqualTo((Object)status);
        }
    }

    private void the_logbook_lifecycle_has_not_the_status(String status) {
        RequestResponseOK requestResponseOK = (RequestResponseOK)this.requestResponse;
        LogbookLifecycle master = (LogbookLifecycle)requestResponseOK.getFirstResult();
        ((AbstractStringAssert)Assertions.assertThat((String)master.getOutcome()).as("master has forbidden status %s", new Object[]{master.getOutcome(), master.getEvType()})).isNotEqualTo((Object)status);
        for (LogbookEvent event : master.getEvents()) {
            ((AbstractStringAssert)Assertions.assertThat((String)event.getOutcome()).as("event has forbidden status %s. Event name is: %s", new Object[]{event.getOutcome(), event.getEvType()})).isNotEqualTo((Object)status);
        }
    }

    private void the_logbook_operation_status_are(List<String> eventNames, String eventStatus) throws SoftAssertionError {
        RequestResponseOK requestResponseOK = (RequestResponseOK)this.requestResponse;
        List actual = ((LogbookOperation)requestResponseOK.getFirstResult()).getEvents();
        try (AutoCloseableSoftAssertions softly = new AutoCloseableSoftAssertions();){
            for (String eventName : eventNames) {
                List<LogbookEvent> events = actual.stream().filter(event -> eventName.equals(event.getEvType())).filter(event -> !"STARTED".equals(event.getOutcome())).collect(Collectors.toList());
                this.the_logbook_event_status_check(eventStatus, softly, eventName, events);
            }
        }
    }

    private void the_logbook_lifecycle_status_are(List<String> eventNames, String eventStatus) throws SoftAssertionError {
        RequestResponseOK requestResponseOK = (RequestResponseOK)this.requestResponse;
        List actual = ((LogbookLifecycle)requestResponseOK.getFirstResult()).getEvents();
        try (AutoCloseableSoftAssertions softly = new AutoCloseableSoftAssertions();){
            for (String eventName : eventNames) {
                List<LogbookEvent> events = actual.stream().filter(event -> eventName.equals(event.getEvType())).filter(event -> !"STARTED".equals(event.getOutcome())).collect(Collectors.toList());
                this.the_logbook_event_status_check(eventStatus, softly, eventName, events);
            }
        }
    }

    private void the_logbook_event_status_check(String eventStatus, AutoCloseableSoftAssertions softly, String eventName, List<LogbookEvent> events) {
        ((ListAssert)softly.assertThat(events).as("event %s is not present or finish.", new Object[]{eventName})).hasSize(1);
        LogbookEvent onlyElement = (LogbookEvent)Iterables.getOnlyElement(events);
        String currentStatus = onlyElement.getOutcome();
        ((StringAssert)softly.assertThat(currentStatus).as("event %s has status %s but excepted status is %s.", new Object[]{eventName, currentStatus, eventStatus})).isEqualTo(eventStatus);
    }

    private void the_logbook_operation_outcome_detail_is(String eventName, String eventOutDetail) throws SoftAssertionError {
        RequestResponseOK requestResponseOK = (RequestResponseOK)this.requestResponse;
        List actual = ((LogbookOperation)requestResponseOK.getFirstResult()).getEvents();
        try (AutoCloseableSoftAssertions softly = new AutoCloseableSoftAssertions();){
            List<LogbookEvent> events = actual.stream().filter(event -> eventName.equals(event.getEvType())).filter(event -> !"STARTED".equals(event.getOutcome())).collect(Collectors.toList());
            this.the_logbook_event_outcome_detail_check(eventName, eventOutDetail, softly, events);
        }
    }

    private void the_logbook_lifecycle_outcome_detail_is(String eventName, String eventOutDetail) throws SoftAssertionError {
        RequestResponseOK requestResponseOK = (RequestResponseOK)this.requestResponse;
        List actual = ((LogbookLifecycle)requestResponseOK.getFirstResult()).getEvents();
        try (AutoCloseableSoftAssertions softly = new AutoCloseableSoftAssertions();){
            List<LogbookEvent> events = actual.stream().filter(event -> eventName.equals(event.getEvType())).filter(event -> !"STARTED".equals(event.getOutcome())).collect(Collectors.toList());
            this.the_logbook_event_outcome_detail_check(eventName, eventOutDetail, softly, events);
        }
    }

    private void the_logbook_event_outcome_detail_check(String eventName, String eventOutDetail, AutoCloseableSoftAssertions softly, List<LogbookEvent> events) {
        ((ListAssert)softly.assertThat(events).as("event %s is not present or finish.", new Object[]{eventName})).hasSize(1);
        LogbookEvent onlyElement = (LogbookEvent)Iterables.getOnlyElement(events);
        String currentOutDetail = onlyElement.getOutDetail();
        ((StringAssert)softly.assertThat(currentOutDetail).as("event %s has status %s but excepted status is %s.", new Object[]{eventName, currentOutDetail, eventOutDetail})).isEqualTo(eventOutDetail);
    }
}

