/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.api.AdminCollections;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.FileUtil;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.builder.request.single.Update;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.PermissionModel;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;

public class ContractsStep
extends CommonStep {
    public static final String CONTEXT_IDENTIFIER = "CT-000001";
    public static final String INGEST_CONTRACT_NOT_IN_CONTEXT = "IngestContractNotInContext";
    private String fileName;
    private JsonNode model;
    private String contractType;

    public ContractsStep(World world) {
        super(world);
    }

    public JsonNode getModel() {
        return this.model;
    }

    public String getContractType() {
        return this.contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public void setModel(JsonNode model) {
        this.model = model;
    }

    @Given(value="^un contract nomm\u00e9 (.*)$")
    public void a_contract_json_named(String fileName) {
        this.fileName = fileName;
    }

    @Then(value="^j'importe ce contrat de type (.*)")
    public void upload_contract(String type) throws Exception {
        this.uploadContract(type, CONTEXT_IDENTIFIER, true);
    }

    @Then(value="^j'importe ce contrat sans \u00e9chec de type (.*)")
    public void upload_contract_without_failure(String type) {
        try {
            this.uploadContract(type, CONTEXT_IDENTIFIER, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Then(value="^j'importe ce contrat incorrect de type (.*)")
    public void upload_incorrect_contract(String type) throws Exception {
        this.uploadContract(type, CONTEXT_IDENTIFIER, false);
    }

    private void uploadContract(String type, String contextIdentifier, Boolean expectedSuccessStatus) throws IOException, InvalidParseOperationException, AccessExternalClientException, VitamClientException, InvalidCreateOperationException {
        Path sip = Paths.get(this.world.getBaseDirectory(), this.fileName);
        try (InputStream inputStream = Files.newInputStream(sip, StandardOpenOption.READ);){
            RequestResponse res = this.world.getAdminClient().findContextById(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), contextIdentifier);
            Assertions.assertThat((boolean)res.isOk()).isTrue();
            ContextModel contextModel = (ContextModel)((RequestResponseOK)res).getFirstResult();
            Assertions.assertThat((Object)contextModel).isNotNull();
            List permissions = contextModel.getPermissions();
            Assertions.assertThat((List)permissions).isNotEmpty();
            AdminCollections collection = AdminCollections.valueOf((String)type);
            this.setContractType(collection.getName());
            if (AdminCollections.ACCESS_CONTRACTS.equals((Object)collection)) {
                this.uploadAccessContract(contextIdentifier, expectedSuccessStatus, sip, inputStream, permissions);
            } else if (AdminCollections.INGEST_CONTRACTS.equals((Object)collection)) {
                this.uploadIngestContract(contextIdentifier, expectedSuccessStatus, sip, inputStream, permissions);
            } else if (AdminCollections.MANAGEMENT_CONTRACTS.equals((Object)collection)) {
                this.uploadManagementContract(contextIdentifier, expectedSuccessStatus, sip, inputStream, permissions);
            }
        }
    }

    private void uploadIngestContract(String contextIdentifier, Boolean expectedSuccessStatus, Path sip, InputStream inputStream, List<PermissionModel> permissions) throws InvalidParseOperationException, AccessExternalClientException, InvalidCreateOperationException {
        List ingestContractModelList;
        RequestResponse response = this.world.getAdminClient().createIngestContracts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), inputStream);
        if (expectedSuccessStatus != null) {
            Assertions.assertThat((boolean)response.isOk()).isEqualTo((Object)expectedSuccessStatus);
        }
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        if ((expectedSuccessStatus == null || expectedSuccessStatus.booleanValue()) && (ingestContractModelList = (List)JsonHandler.getFromFileAsTypeReference((File)sip.toFile(), (TypeReference)new TypeReference<List<IngestContractModel>>(this){})) != null && !ingestContractModelList.isEmpty() && response.isOk()) {
            Set contractIdentifier = ingestContractModelList.stream().map(ic -> ic.getIdentifier()).collect(Collectors.toSet());
            contractIdentifier.remove(INGEST_CONTRACT_NOT_IN_CONTEXT);
            boolean changed = false;
            for (PermissionModel p : permissions) {
                if (p.getTenant().intValue() != this.world.getTenantId()) continue;
                if (null == p.getIngestContract()) {
                    p.setIngestContract(new HashSet());
                }
                changed = p.getIngestContract().addAll(contractIdentifier) || changed;
            }
            if (changed) {
                ContractsStep.updateContext(this.world.getAdminClient(), this.world.getApplicationSessionId(), contextIdentifier, permissions, expectedSuccessStatus);
            }
        }
    }

    private void uploadAccessContract(String contextIdentifier, Boolean expectedSuccessStatus, Path sip, InputStream inputStream, List<PermissionModel> permissions) throws InvalidParseOperationException, AccessExternalClientException, InvalidCreateOperationException {
        List accessContractModelList;
        RequestResponse response = this.world.getAdminClient().createAccessContracts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), inputStream);
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        if (expectedSuccessStatus != null) {
            Assertions.assertThat((boolean)response.isOk()).isEqualTo((Object)expectedSuccessStatus);
        }
        if ((expectedSuccessStatus == null || expectedSuccessStatus.booleanValue()) && (accessContractModelList = (List)JsonHandler.getFromFileAsTypeReference((File)sip.toFile(), (TypeReference)new TypeReference<List<IngestContractModel>>(this){})) != null && !accessContractModelList.isEmpty()) {
            Set contractIdentifier = accessContractModelList.stream().map(ac -> ac.getIdentifier()).collect(Collectors.toSet());
            boolean changed = false;
            for (PermissionModel p : permissions) {
                if (p.getTenant().intValue() != this.world.getTenantId()) continue;
                if (null == p.getAccessContract()) {
                    p.setAccessContract(new HashSet());
                }
                changed = p.getAccessContract().addAll(contractIdentifier) || changed;
            }
            if (changed) {
                ContractsStep.updateContext(this.world.getAdminClient(), this.world.getApplicationSessionId(), contextIdentifier, permissions, expectedSuccessStatus);
            }
        }
    }

    private void uploadManagementContract(String contextIdentifier, Boolean expectedSuccessStatus, Path sip, InputStream inputStream, List<PermissionModel> permissions) throws InvalidParseOperationException, AccessExternalClientException, InvalidCreateOperationException {
        RequestResponse response = this.world.getAdminClient().createManagementContracts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), inputStream);
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        if (expectedSuccessStatus != null) {
            Assertions.assertThat((boolean)response.isOk()).isEqualTo((Object)expectedSuccessStatus);
        }
    }

    public static void updateContext(AdminExternalClient adminExternalClient, String applicationSessionId, String contextIdentifier, List<PermissionModel> permissions, Boolean expectedSuccessStatus) throws InvalidParseOperationException, InvalidCreateOperationException, AccessExternalClientException {
        ObjectNode permissionsNode = JsonHandler.createObjectNode();
        permissionsNode.set("Permissions", JsonHandler.toJsonNode(permissions));
        VitamContext context = new VitamContext(Integer.valueOf(1));
        context.setApplicationSessionId(applicationSessionId);
        SetAction setPermission = UpdateActionHelper.set((ObjectNode)permissionsNode);
        Update update = new Update();
        update.addActions(new Action[]{setPermission});
        ObjectNode queryDsl = update.getFinalUpdateById();
        RequestResponse requestResponse = adminExternalClient.updateContext(context, contextIdentifier, (JsonNode)queryDsl);
        if (expectedSuccessStatus != null) {
            Assertions.assertThat((boolean)requestResponse.isOk()).isEqualTo((Object)expectedSuccessStatus);
        }
    }

    @When(value="^je cherche un contrat de type (.*) et nomm\u00e9 (.*)")
    public void search_contracts(String type, String name) throws AccessExternalClientException, InvalidParseOperationException, InvalidCreateOperationException, VitamClientException {
        this.setModel(this.retriveContract(type, name));
    }

    private JsonNode retriveContract(String type, String name) throws InvalidCreateOperationException, VitamClientException, InvalidParseOperationException {
        AdminCollections collection = AdminCollections.valueOf((String)type);
        Select select = new Select();
        select.setQuery((Query)QueryHelper.eq((String)"Name", (String)name));
        ObjectNode query = select.getFinalSelect();
        switch (collection) {
            case ACCESS_CONTRACTS: {
                RequestResponse accessResponse = this.world.getAdminClient().findAccessContracts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), (JsonNode)query);
                Assertions.assertThat((boolean)accessResponse.isOk()).isTrue();
                List accessContracts = ((RequestResponseOK)accessResponse).getResultsAsJsonNodes();
                if (accessContracts != null && !accessContracts.isEmpty()) {
                    return (JsonNode)accessContracts.get(0);
                }
                return null;
            }
            case INGEST_CONTRACTS: {
                RequestResponse ingestResponse = this.world.getAdminClient().findIngestContracts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), (JsonNode)query);
                Assertions.assertThat((boolean)ingestResponse.isOk()).isTrue();
                List ingestContracts = ((RequestResponseOK)ingestResponse).getResultsAsJsonNodes();
                if (ingestContracts != null && !ingestContracts.isEmpty()) {
                    return (JsonNode)ingestContracts.get(0);
                }
                return null;
            }
            case MANAGEMENT_CONTRACTS: {
                RequestResponse managementResponse = this.world.getAdminClient().findManagementContracts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), (JsonNode)query);
                Assertions.assertThat((boolean)managementResponse.isOk()).isTrue();
                List managementContracts = ((RequestResponseOK)managementResponse).getResultsAsJsonNodes();
                if (managementContracts != null && !managementContracts.isEmpty()) {
                    return (JsonNode)managementContracts.get(0);
                }
                return null;
            }
        }
        throw new VitamClientException("Contract type not valid");
    }

    @Then(value="^le contrat existe$")
    public void contract_found() {
        Assertions.assertThat((Iterable)this.getModel()).isNotNull();
    }

    @Then(value="^le contrat n'existe pas$")
    public void contract_not_found() {
        Assertions.assertThat((Iterable)this.getModel()).isNull();
    }

    @Then(value="^les m\u00e9tadonn\u00e9es du contrat sont$")
    public void metadata_are(DataTable dataTable) throws Throwable {
        List raws = dataTable.cells();
        for (List raw : raws) {
            String index = (String)raw.get(0);
            String value = (String)raw.get(1);
            Assertions.assertThat((String)value).contains(new CharSequence[]{this.getModel().get(index).asText()});
        }
    }

    @When(value="^je modifie un contrat de type (.*) avec le fichier de requ\u00eate suivant (.*) le statut de la requ\u00eate est (.*)$")
    public void update_contract_by_query(String type, String queryFilename, Integer statusCode) throws IOException, InvalidParseOperationException, AccessExternalClientException, VitamClientException {
        AdminCollections collection = AdminCollections.valueOf((String)type);
        String contractIdentifier = this.getModel().get("Identifier").asText();
        Path queryFile = Paths.get(this.world.getBaseDirectory(), queryFilename);
        String query = FileUtil.readFile((File)queryFile.toFile());
        JsonNode queryDsl = JsonHandler.getFromString((String)query);
        RequestResponse requestResponse = null;
        switch (collection) {
            case ACCESS_CONTRACTS: {
                requestResponse = this.world.getAdminClient().updateAccessContract(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), contractIdentifier, queryDsl);
                Assertions.assertThat((Integer)statusCode).isEqualTo(requestResponse.getStatus());
                break;
            }
            case INGEST_CONTRACTS: {
                requestResponse = this.world.getAdminClient().updateIngestContract(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), contractIdentifier, queryDsl);
                Assertions.assertThat((Integer)statusCode).isEqualTo(requestResponse.getStatus());
                break;
            }
            case MANAGEMENT_CONTRACTS: {
                requestResponse = this.world.getAdminClient().updateManagementContract(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), contractIdentifier, queryDsl);
                Assertions.assertThat((Integer)statusCode).isEqualTo(requestResponse.getStatus());
                break;
            }
            default: {
                throw new VitamClientException("Contract type not valid");
            }
        }
        String operationId = requestResponse.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
    }

    @When(value="^je modifie un contrat d'acc\u00e8s et le statut de la requ\u00eate est (.*)$")
    public void update_access_contract(Integer statusCode) throws InvalidParseOperationException, AccessExternalClientException {
        String contractIdentifier = this.getModel().get("Identifier").asText();
        JsonNode queryDsl = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse requestResponse = null;
        requestResponse = this.world.getAdminClient().updateAccessContract(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), contractIdentifier, queryDsl);
        Assertions.assertThat((Integer)statusCode).isEqualTo(requestResponse.getStatus());
        String operationId = requestResponse.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
    }

    @Then(value="^le[s]? contract[s]? (.*) de type (.*) (?:d\u00e9finie|d\u00e9finies) dans le fichier (.*)$")
    public void verify_contrat_or_import(String contractNames, String type, String fileName) throws Exception {
        boolean shouldImport = false;
        for (String contractName : contractNames.split(",\\s?")) {
            JsonNode jsonNode = this.retriveContract(type, contractName);
            if (jsonNode != null) continue;
            shouldImport = true;
            break;
        }
        if (shouldImport) {
            this.a_contract_json_named(fileName);
            this.upload_contract(type);
        }
    }
}

