/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.OperationStatusClient;
import fr.gouv.vitam.access.external.client.VitamPoolingClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Java6Assertions;

public class AuditStep
extends CommonStep {
    private static final String AUDIT_QUERY = "{auditActions:\"%s\",auditType:\"originatingagency\",objectId:\"%s\"}";
    private Response.Status auditStatus;

    public AuditStep(World world) {
        super(world);
    }

    @When(value="^je lance un audit de coh\u00e9rence$")
    public void evidenceAudit() throws VitamException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        vitamContext.setAccessContract(this.world.getContractId());
        String query = this.world.getQuery();
        JsonNode queryString = JsonHandler.getFromString((String)query);
        RequestResponse response = this.world.getAdminClient().evidenceAudit(vitamContext, queryString);
        Assertions.assertThat((boolean)response.isOk()).isTrue();
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
        boolean processTimeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 100, 1000L, TimeUnit.MILLISECONDS);
        if (!processTimeout) {
            Java6Assertions.fail((String)"audit processing not finished. Timeout exceeded.");
        }
        ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
    }

    @When(value="^je lance un audit rectificatif sur l'operation (.*)")
    public void rectificationAudit(String id) throws VitamException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        vitamContext.setAccessContract(this.world.getContractId());
        RequestResponse response = this.world.getAdminClient().rectificationAudit(vitamContext, id);
        Assertions.assertThat((boolean)response.isOk()).isTrue();
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
        boolean processTimeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 100, 1000L, TimeUnit.MILLISECONDS);
        if (!processTimeout) {
            Java6Assertions.fail((String)"dip processing not finished. Timeout exceeded.");
        }
        ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
    }

    @When(value="^je veux faire un audit sur (.*) des objets par service producteur \"([^\"]*)\"$")
    public void je_lance_l_audit_en_service_producteur(String action, String originatingAgnecy) throws Throwable {
        this.auditStatus = null;
        String auditActions = this.getAuditAction(action);
        String QUERY = String.format(AUDIT_QUERY, auditActions, originatingAgnecy);
        JsonNode auditOption = JsonHandler.getFromString((String)QUERY);
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse response = this.world.getAdminClient().launchAudit(vitamContext, auditOption);
        Assertions.assertThat((boolean)response.isOk()).isTrue();
        this.auditStatus = Response.Status.ACCEPTED;
    }

    @When(value="^je veux faire un audit sur (.*) des objets par tenant (\\d+)$")
    public void je_veux_faire_l_audit_des_objets_de_tenant(String action, int tenant) throws Throwable {
        this.auditStatus = null;
        String auditActions = this.getAuditAction(action);
        String QUERY = String.format(AUDIT_QUERY, auditActions, tenant);
        JsonNode auditOption = JsonHandler.getFromString((String)QUERY);
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse response = this.world.getAdminClient().launchAudit(vitamContext, auditOption);
        Assertions.assertThat((boolean)response.isOk()).isTrue();
        this.auditStatus = Response.Status.ACCEPTED;
    }

    @When(value="^je veux faire un audit sur (.*) des objets li\u00e9s aux unit\u00e9s archivistiques de la requ\u00eate$")
    public void je_veux_faire_l_audit_des_objets_par_requete(String action) throws Throwable {
        this.auditStatus = null;
        JsonNode query = JsonHandler.getFromString((String)this.world.getQuery());
        String auditActions = this.getAuditAction(action);
        ObjectNode auditOption = JsonHandler.createObjectNode();
        auditOption.put("auditActions", auditActions);
        auditOption.put("auditType", "dsl");
        auditOption.set("query", query);
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse response = this.world.getAdminClient().launchAudit(vitamContext, (JsonNode)auditOption);
        Assertions.assertThat((boolean)response.isOk()).isTrue();
        this.auditStatus = Response.Status.ACCEPTED;
    }

    @Then(value="^le r\u00e9ultat de l'audit est succ\u00e8s$")
    public void audit_result_is_success() {
        Assertions.assertThat((int)this.auditStatus.getStatusCode()).isEqualTo(202);
    }

    @Nonnull
    private String getAuditAction(String action) {
        return switch (action) {
            case "l'existence" -> "AUDIT_FILE_EXISTING";
            case "l'int\u00e9grit\u00e9" -> "AUDIT_FILE_INTEGRITY";
            default -> throw new UnsupportedOperationException("Unknown action " + action);
        };
    }
}

