/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.assertj.core.api.Assertions;

public class AgenciesStep
extends CommonStep {
    private String fileName;
    private JsonNode model;

    public AgenciesStep(World world) {
        super(world);
    }

    public JsonNode getModel() {
        return this.model;
    }

    public void setModel(JsonNode model) {
        this.model = model;
    }

    @Given(value="^un fichier de service producteur nomm\u00e9 (.*)$")
    public void a_sip_named(String fileName) {
        this.fileName = fileName;
    }

    @Then(value="^j'importe les services producteurs$")
    public void uploadAgency() {
        this.uploadAgency(true);
    }

    @Then(value="^j'importe les services producteurs sans \u00e9chec$")
    public void uploadAgency_without_failure() {
        this.uploadAgency(null);
    }

    @Then(value="^j'importe les services producteurs incorrects")
    public void uploadAgency_with_failure() {
        this.uploadAgency(false);
    }

    private void uploadAgency(Boolean expectedStatus) {
        Path sip = Paths.get(this.world.getBaseDirectory(), this.fileName);
        try (InputStream inputStream = Files.newInputStream(sip, StandardOpenOption.READ);){
            RequestResponse response = this.world.getAdminClient().createAgencies(new VitamContext(Integer.valueOf(this.world.getTenantId())), inputStream, this.fileName);
            if (expectedStatus != null) {
                if (expectedStatus.booleanValue()) {
                    Assertions.assertThat((int)response.getHttpCode()).isEqualTo(Response.Status.CREATED.getStatusCode());
                } else {
                    Assertions.assertThat((int)response.getHttpCode()).isNotEqualTo(Response.Status.CREATED.getStatusCode());
                }
            }
            String operationId = response.getHeaderString("X-Request-Id");
            this.world.setOperationId(operationId);
        }
        catch (Exception e) {
            Assertions.fail((String)"should not produce this exception", (Throwable)e);
        }
    }

    @When(value="^je cherche un service producteur nomm\u00e9 (.*)")
    public void search_contracts(String name) throws AccessExternalClientException, InvalidParseOperationException, InvalidCreateOperationException, VitamClientException {
        Select select = new Select();
        select.setQuery((Query)QueryHelper.eq((String)"Name", (String)name));
        ObjectNode query = select.getFinalSelect();
        RequestResponse ingestResponse = this.world.getAdminClient().findAgencies(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract("ContratTNR"), (JsonNode)query);
        Assertions.assertThat((boolean)ingestResponse.isOk()).isTrue();
        List results = ((RequestResponseOK)ingestResponse).getResultsAsJsonNodes();
        if (!results.isEmpty()) {
            this.setModel((JsonNode)results.get(0));
        } else {
            this.setModel(null);
        }
    }

    @Then(value="^le service producteur existe$")
    public void agencies_found() {
        Assertions.assertThat((Iterable)this.getModel()).isNotNull();
    }

    @Then(value="^le service producteur n'existe pas$")
    public void agencies_not_found() {
        Assertions.assertThat((Iterable)this.getModel()).isNull();
    }

    @Then(value="^les m\u00e9tadonn\u00e9es du service sont$")
    public void metadata_are(DataTable dataTable) throws Throwable {
        List raws = dataTable.cells();
        for (List raw : raws) {
            String index = (String)raw.get(0);
            String value = (String)raw.get(1);
            Assertions.assertThat((String)value).contains(new CharSequence[]{this.getModel().get(index).asText()});
        }
    }
}

