/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.service;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;

public class XmlTestHelper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(XmlTestHelper.class);

    public static void checkTagCountInXmlFile(Path file, int count, String tag) throws IOException {
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            XmlTestHelper.checkTagCountInXmlFile(inputStream, count, tag);
        }
    }

    public static void checkTagCountInXmlFile(InputStream is, int count, String tag) throws IOException {
        String xml = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        int realCount = StringUtils.countMatches((CharSequence)xml, (CharSequence)("</" + tag + ">")) + StringUtils.countMatches((CharSequence)xml, (CharSequence)("<" + tag + "/>"));
        if (realCount != count) {
            LOGGER.error(String.format("expected %d tags %s but was %d", count, tag, realCount));
            Assertions.fail((String)String.format("expected %d tags %s but was %d", count, tag, realCount));
        }
    }
}

