/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Iterables;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.functionaltest.cucumber.service.LogHelper;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class LogbookService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookService.class);

    public RequestResponse<LogbookOperation> getLogbookOperation(AccessExternalClient accessClient, int tenantId, String contractId, String applicationSessionId, String operationId) throws VitamClientException {
        return accessClient.selectOperationbyId(new VitamContext(Integer.valueOf(tenantId)).setAccessContract(contractId).setApplicationSessionId(applicationSessionId), operationId, (JsonNode)new Select().getFinalSelectById());
    }

    public LogbookEventOperation checkFinalStatusLogbook(World world, AccessExternalClient accessClient, int tenantId, String contractId, String applicationSessionId, String operationId, String status) throws VitamClientException {
        RequestResponse<LogbookOperation> requestResponse = this.getLogbookOperation(accessClient, tenantId, contractId, applicationSessionId, operationId);
        if (!(requestResponse instanceof RequestResponseOK)) {
            LOGGER.error(String.format("logbook operation return a vitam error for operationId: %s", operationId));
            Assertions.fail((String)String.format("logbook operation return a vitam error for operationId: %s", operationId));
        }
        RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
        LogbookOperation actual = (LogbookOperation)requestResponseOK.getFirstResult();
        LogHelper.logJson(world, "LogbookOperation", actual);
        LogbookEventOperation last = (LogbookEventOperation)Iterables.getLast((Iterable)actual.getEvents());
        if (!StringUtils.equals((CharSequence)"FATAL", (CharSequence)status)) {
            ((AbstractStringAssert)Assertions.assertThat((String)last.getEvType()).as("last event is type %s, but %s was expected.", new Object[]{last.getEvType(), actual.getEvType()})).isEqualTo(actual.getEvType());
        }
        if (!status.contains("|")) {
            ((AbstractStringAssert)Assertions.assertThat((String)last.getOutcome()).as("last event has status %s, but %s was expected. Event name is: %s", new Object[]{last.getOutcome(), status, last.getEvType()})).isEqualTo(status);
            return last;
        }
        String[] statuses = status.split("\\|");
        boolean atLeastOneOK = false;
        for (String currStatus : statuses) {
            atLeastOneOK = last.getOutcome().equals(currStatus);
            if (atLeastOneOK) break;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)atLeastOneOK).as("last event has status %s, but %s was expected. Event name is: %s", new Object[]{last.getOutcome(), status, last.getEvType()})).isEqualTo(true);
        return last;
    }
}

